/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.impl;

import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.VcsLogBranchFilter;
import com.intellij.vcs.log.VcsLogDateFilter;
import com.intellij.vcs.log.VcsLogDetailsFilter;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.VcsLogHashFilter;
import com.intellij.vcs.log.VcsLogRootFilter;
import com.intellij.vcs.log.VcsLogStructureFilter;
import com.intellij.vcs.log.VcsLogTextFilter;
import com.intellij.vcs.log.VcsLogUserFilter;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsLogFilterCollectionImpl
implements VcsLogFilterCollection {
    @NotNull
    public static final VcsLogFilterCollection EMPTY = new VcsLogFilterCollectionBuilder().build();
    @Nullable
    private final VcsLogBranchFilter myBranchFilter;
    @Nullable
    private final VcsLogUserFilter myUserFilter;
    @Nullable
    private final VcsLogHashFilter myHashFilter;
    @Nullable
    private final VcsLogDateFilter myDateFilter;
    @Nullable
    private final VcsLogTextFilter myTextFilter;
    @Nullable
    private final VcsLogStructureFilter myStructureFilter;
    @Nullable
    private final VcsLogRootFilter myRootFilter;

    public VcsLogFilterCollectionImpl(@Nullable VcsLogBranchFilter branchFilter, @Nullable VcsLogUserFilter userFilter, @Nullable VcsLogHashFilter hashFilter, @Nullable VcsLogDateFilter dateFilter, @Nullable VcsLogTextFilter textFilter, @Nullable VcsLogStructureFilter structureFilter, @Nullable VcsLogRootFilter rootFilter) {
        this.myBranchFilter = branchFilter;
        this.myUserFilter = userFilter;
        this.myHashFilter = hashFilter;
        this.myDateFilter = dateFilter;
        this.myTextFilter = textFilter;
        this.myStructureFilter = structureFilter;
        this.myRootFilter = rootFilter;
    }

    @Nullable
    public VcsLogBranchFilter getBranchFilter() {
        return this.myBranchFilter;
    }

    @Nullable
    public VcsLogHashFilter getHashFilter() {
        return this.myHashFilter;
    }

    @Nullable
    public VcsLogUserFilter getUserFilter() {
        return this.myUserFilter;
    }

    @Nullable
    public VcsLogDateFilter getDateFilter() {
        return this.myDateFilter;
    }

    @Nullable
    public VcsLogTextFilter getTextFilter() {
        return this.myTextFilter;
    }

    @Nullable
    public VcsLogStructureFilter getStructureFilter() {
        return this.myStructureFilter;
    }

    @Nullable
    public VcsLogRootFilter getRootFilter() {
        return this.myRootFilter;
    }

    public boolean isEmpty() {
        return this.myBranchFilter == null && this.getDetailsFilters().isEmpty();
    }

    @NotNull
    public List<VcsLogDetailsFilter> getDetailsFilters() {
        List list2 = ContainerUtil.skipNulls(Arrays.asList(this.myUserFilter, this.myDateFilter, this.myTextFilter, this.myStructureFilter));
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/impl/VcsLogFilterCollectionImpl", "getDetailsFilters"));
        }
        return list2;
    }

    public String toString() {
        return "filters: (" + (this.myBranchFilter != null ? this.myBranchFilter + ", " : "") + (this.myUserFilter != null ? this.myUserFilter + ", " : "") + (this.myHashFilter != null ? this.myHashFilter + ", " : "") + (this.myDateFilter != null ? this.myDateFilter + ", " : "") + (this.myTextFilter != null ? this.myTextFilter + ", " : "") + (this.myStructureFilter != null ? this.myStructureFilter + ", " : "") + (this.myRootFilter != null ? this.myRootFilter : "") + ")";
    }

    public static class VcsLogFilterCollectionBuilder {
        @Nullable
        private VcsLogBranchFilter myBranchFilter;
        @Nullable
        private VcsLogUserFilter myUserFilter;
        @Nullable
        private VcsLogHashFilter myHashFilter;
        @Nullable
        private VcsLogDateFilter myDateFilter;
        @Nullable
        private VcsLogTextFilter myTextFilter;
        @Nullable
        private VcsLogStructureFilter myStructureFilter;
        @Nullable
        private VcsLogRootFilter myRootFilter;

        public VcsLogFilterCollectionBuilder() {
        }

        public VcsLogFilterCollectionBuilder(@NotNull VcsLogFilterCollection filterCollection) {
            if (filterCollection == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filterCollection", "com/intellij/vcs/log/impl/VcsLogFilterCollectionImpl$VcsLogFilterCollectionBuilder", "<init>"));
            }
            this.myBranchFilter = filterCollection.getBranchFilter();
            this.myUserFilter = filterCollection.getUserFilter();
            this.myHashFilter = filterCollection.getHashFilter();
            this.myDateFilter = filterCollection.getDateFilter();
            this.myTextFilter = filterCollection.getTextFilter();
            this.myStructureFilter = filterCollection.getStructureFilter();
            this.myRootFilter = filterCollection.getRootFilter();
        }

        @NotNull
        public VcsLogFilterCollectionBuilder with(@Nullable VcsLogBranchFilter filter2) {
            this.myBranchFilter = filter2;
            VcsLogFilterCollectionBuilder vcsLogFilterCollectionBuilder = this;
            if (vcsLogFilterCollectionBuilder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/impl/VcsLogFilterCollectionImpl$VcsLogFilterCollectionBuilder", "with"));
            }
            return vcsLogFilterCollectionBuilder;
        }

        @NotNull
        public VcsLogFilterCollectionBuilder with(@Nullable VcsLogUserFilter filter2) {
            this.myUserFilter = filter2;
            VcsLogFilterCollectionBuilder vcsLogFilterCollectionBuilder = this;
            if (vcsLogFilterCollectionBuilder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/impl/VcsLogFilterCollectionImpl$VcsLogFilterCollectionBuilder", "with"));
            }
            return vcsLogFilterCollectionBuilder;
        }

        @NotNull
        public VcsLogFilterCollectionBuilder with(@Nullable VcsLogHashFilter filter2) {
            this.myHashFilter = filter2;
            VcsLogFilterCollectionBuilder vcsLogFilterCollectionBuilder = this;
            if (vcsLogFilterCollectionBuilder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/impl/VcsLogFilterCollectionImpl$VcsLogFilterCollectionBuilder", "with"));
            }
            return vcsLogFilterCollectionBuilder;
        }

        @NotNull
        public VcsLogFilterCollectionBuilder with(@Nullable VcsLogDateFilter filter2) {
            this.myDateFilter = filter2;
            VcsLogFilterCollectionBuilder vcsLogFilterCollectionBuilder = this;
            if (vcsLogFilterCollectionBuilder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/impl/VcsLogFilterCollectionImpl$VcsLogFilterCollectionBuilder", "with"));
            }
            return vcsLogFilterCollectionBuilder;
        }

        @NotNull
        public VcsLogFilterCollectionBuilder with(@Nullable VcsLogTextFilter filter2) {
            this.myTextFilter = filter2;
            VcsLogFilterCollectionBuilder vcsLogFilterCollectionBuilder = this;
            if (vcsLogFilterCollectionBuilder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/impl/VcsLogFilterCollectionImpl$VcsLogFilterCollectionBuilder", "with"));
            }
            return vcsLogFilterCollectionBuilder;
        }

        @NotNull
        public VcsLogFilterCollectionBuilder with(@Nullable VcsLogStructureFilter filter2) {
            this.myStructureFilter = filter2;
            VcsLogFilterCollectionBuilder vcsLogFilterCollectionBuilder = this;
            if (vcsLogFilterCollectionBuilder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/impl/VcsLogFilterCollectionImpl$VcsLogFilterCollectionBuilder", "with"));
            }
            return vcsLogFilterCollectionBuilder;
        }

        @NotNull
        public VcsLogFilterCollectionBuilder with(@Nullable VcsLogRootFilter filter2) {
            this.myRootFilter = filter2;
            VcsLogFilterCollectionBuilder vcsLogFilterCollectionBuilder = this;
            if (vcsLogFilterCollectionBuilder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/impl/VcsLogFilterCollectionImpl$VcsLogFilterCollectionBuilder", "with"));
            }
            return vcsLogFilterCollectionBuilder;
        }

        @NotNull
        public VcsLogFilterCollection build() {
            VcsLogFilterCollectionImpl vcsLogFilterCollectionImpl = new VcsLogFilterCollectionImpl(this.myBranchFilter, this.myUserFilter, this.myHashFilter, this.myDateFilter, this.myTextFilter, this.myStructureFilter, this.myRootFilter);
            if (vcsLogFilterCollectionImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/impl/VcsLogFilterCollectionImpl$VcsLogFilterCollectionBuilder", "build"));
            }
            return vcsLogFilterCollectionImpl;
        }
    }
}

