/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.impl;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.graph.PermanentGraph;
import com.intellij.vcs.log.impl.CommonUiProperties;
import com.intellij.vcs.log.impl.MainVcsLogUiProperties;
import com.intellij.vcs.log.impl.VcsLogUiProperties;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class VcsLogUiPropertiesImpl
implements PersistentStateComponent<State>,
MainVcsLogUiProperties {
    private static final int RECENTLY_FILTERED_VALUES_LIMIT = 10;
    private static final Set<VcsLogUiProperties.VcsLogUiProperty> SUPPORTED_PROPERTIES = ContainerUtil.newHashSet((Object[])new VcsLogUiProperties.VcsLogUiProperty[]{CommonUiProperties.SHOW_DETAILS, MainVcsLogUiProperties.SHOW_LONG_EDGES, MainVcsLogUiProperties.BEK_SORT_TYPE, MainVcsLogUiProperties.SHOW_ROOT_NAMES, MainVcsLogUiProperties.COMPACT_REFERENCES_VIEW, MainVcsLogUiProperties.SHOW_TAG_NAMES, MainVcsLogUiProperties.TEXT_FILTER_MATCH_CASE, MainVcsLogUiProperties.TEXT_FILTER_REGEX, CommonUiProperties.COLUMN_ORDER});
    private final Set<VcsLogUiProperties.PropertiesChangeListener> myListeners = ContainerUtil.newLinkedHashSet();

    @NotNull
    public abstract State getState();

    @Override
    @NotNull
    public <T> T get(@NotNull VcsLogUiProperties.VcsLogUiProperty<T> property) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/intellij/vcs/log/impl/VcsLogUiPropertiesImpl", "get"));
        }
        if (CommonUiProperties.SHOW_DETAILS.equals(property)) {
            Boolean bl = this.getState().SHOW_DETAILS_IN_CHANGES;
            if (bl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/impl/VcsLogUiPropertiesImpl", "get"));
            }
            return (T)bl;
        }
        if (SHOW_LONG_EDGES.equals(property)) {
            Boolean bl = this.getState().LONG_EDGES_VISIBLE;
            if (bl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/impl/VcsLogUiPropertiesImpl", "get"));
            }
            return (T)bl;
        }
        if (SHOW_ROOT_NAMES.equals(property)) {
            Boolean bl = this.getState().SHOW_ROOT_NAMES;
            if (bl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/impl/VcsLogUiPropertiesImpl", "get"));
            }
            return (T)bl;
        }
        if (COMPACT_REFERENCES_VIEW.equals(property)) {
            Boolean bl = this.getState().COMPACT_REFERENCES_VIEW;
            if (bl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/impl/VcsLogUiPropertiesImpl", "get"));
            }
            return (T)bl;
        }
        if (SHOW_TAG_NAMES.equals(property)) {
            Boolean bl = this.getState().SHOW_TAG_NAMES;
            if (bl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/impl/VcsLogUiPropertiesImpl", "get"));
            }
            return (T)bl;
        }
        if (BEK_SORT_TYPE.equals(property)) {
            PermanentGraph.SortType sortType = PermanentGraph.SortType.values()[this.getState().BEK_SORT_TYPE];
            if (sortType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/impl/VcsLogUiPropertiesImpl", "get"));
            }
            return (T)sortType;
        }
        if (TEXT_FILTER_MATCH_CASE.equals(property)) {
            Boolean bl = this.getTextFilterSettings().MATCH_CASE;
            if (bl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/impl/VcsLogUiPropertiesImpl", "get"));
            }
            return (T)bl;
        }
        if (TEXT_FILTER_REGEX.equals(property)) {
            Boolean bl = this.getTextFilterSettings().REGEX;
            if (bl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/impl/VcsLogUiPropertiesImpl", "get"));
            }
            return (T)bl;
        }
        if (CommonUiProperties.COLUMN_ORDER.equals(property)) {
            ArrayList order = this.getState().COLUMN_ORDER;
            if (order == null) {
                order = ContainerUtil.newArrayList();
            }
            ArrayList arrayList = order;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/impl/VcsLogUiPropertiesImpl", "get"));
            }
            return (T)arrayList;
        }
        if (property instanceof MainVcsLogUiProperties.VcsLogHighlighterProperty) {
            Boolean result2 = this.getState().HIGHLIGHTERS.get(((MainVcsLogUiProperties.VcsLogHighlighterProperty)property).getId());
            if (result2 == null) {
                Boolean bl = Boolean.TRUE;
                if (bl == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/impl/VcsLogUiPropertiesImpl", "get"));
                }
                return (T)bl;
            }
            Boolean bl = result2;
            if (bl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/impl/VcsLogUiPropertiesImpl", "get"));
            }
            return (T)bl;
        }
        if (property instanceof CommonUiProperties.TableColumnProperty) {
            Integer savedWidth = this.getState().COLUMN_WIDTH.get(((CommonUiProperties.TableColumnProperty)property).getColumn());
            if (savedWidth == null) {
                Integer n2 = -1;
                if (n2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/impl/VcsLogUiPropertiesImpl", "get"));
                }
                return (T)n2;
            }
            Integer n3 = savedWidth;
            if (n3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/impl/VcsLogUiPropertiesImpl", "get"));
            }
            return (T)n3;
        }
        throw new UnsupportedOperationException("Property " + property + " does not exist");
    }

    @Override
    public <T> void set(@NotNull VcsLogUiProperties.VcsLogUiProperty<T> property, @NotNull T value2) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/intellij/vcs/log/impl/VcsLogUiPropertiesImpl", "set"));
        }
        if (value2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/vcs/log/impl/VcsLogUiPropertiesImpl", "set"));
        }
        if (CommonUiProperties.SHOW_DETAILS.equals(property)) {
            this.getState().SHOW_DETAILS_IN_CHANGES = (Boolean)value2;
        } else if (SHOW_LONG_EDGES.equals(property)) {
            this.getState().LONG_EDGES_VISIBLE = (Boolean)value2;
        } else if (SHOW_ROOT_NAMES.equals(property)) {
            this.getState().SHOW_ROOT_NAMES = (Boolean)value2;
        } else if (COMPACT_REFERENCES_VIEW.equals(property)) {
            this.getState().COMPACT_REFERENCES_VIEW = (Boolean)value2;
        } else if (SHOW_TAG_NAMES.equals(property)) {
            this.getState().SHOW_TAG_NAMES = (Boolean)value2;
        } else if (BEK_SORT_TYPE.equals(property)) {
            this.getState().BEK_SORT_TYPE = ((PermanentGraph.SortType)value2).ordinal();
        } else if (TEXT_FILTER_REGEX.equals(property)) {
            this.getTextFilterSettings().REGEX = (Boolean)value2;
        } else if (TEXT_FILTER_MATCH_CASE.equals(property)) {
            this.getTextFilterSettings().MATCH_CASE = (Boolean)value2;
        } else if (CommonUiProperties.COLUMN_ORDER.equals(property)) {
            this.getState().COLUMN_ORDER = (List)value2;
        } else if (property instanceof MainVcsLogUiProperties.VcsLogHighlighterProperty) {
            this.getState().HIGHLIGHTERS.put(((MainVcsLogUiProperties.VcsLogHighlighterProperty)property).getId(), (Boolean)value2);
        } else if (property instanceof CommonUiProperties.TableColumnProperty) {
            this.getState().COLUMN_WIDTH.put(((CommonUiProperties.TableColumnProperty)property).getColumn(), (Integer)value2);
        } else {
            throw new UnsupportedOperationException("Property " + property + " does not exist");
        }
        this.myListeners.forEach(l2 -> {
            if (property == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/intellij/vcs/log/impl/VcsLogUiPropertiesImpl", "lambda$set$0"));
            }
            l2.onPropertyChanged(property);
        });
    }

    @Override
    public <T> boolean exists(@NotNull VcsLogUiProperties.VcsLogUiProperty<T> property) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/intellij/vcs/log/impl/VcsLogUiPropertiesImpl", "exists"));
        }
        return SUPPORTED_PROPERTIES.contains(property) || property instanceof MainVcsLogUiProperties.VcsLogHighlighterProperty || property instanceof CommonUiProperties.TableColumnProperty;
    }

    @NotNull
    private TextFilterSettings getTextFilterSettings() {
        TextFilterSettings settings = this.getState().TEXT_FILTER_SETTINGS;
        if (settings == null) {
            this.getState().TEXT_FILTER_SETTINGS = settings = new TextFilterSettings();
        }
        TextFilterSettings textFilterSettings = settings;
        if (textFilterSettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/impl/VcsLogUiPropertiesImpl", "getTextFilterSettings"));
        }
        return textFilterSettings;
    }

    @Override
    public void addRecentlyFilteredUserGroup(@NotNull List<String> usersInGroup) {
        if (usersInGroup == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usersInGroup", "com/intellij/vcs/log/impl/VcsLogUiPropertiesImpl", "addRecentlyFilteredUserGroup"));
        }
        VcsLogUiPropertiesImpl.addRecentGroup(usersInGroup, this.getState().RECENTLY_FILTERED_USER_GROUPS);
    }

    @Override
    public void addRecentlyFilteredBranchGroup(@NotNull List<String> valuesInGroup) {
        if (valuesInGroup == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valuesInGroup", "com/intellij/vcs/log/impl/VcsLogUiPropertiesImpl", "addRecentlyFilteredBranchGroup"));
        }
        VcsLogUiPropertiesImpl.addRecentGroup(valuesInGroup, this.getState().RECENTLY_FILTERED_BRANCH_GROUPS);
    }

    private static void addRecentGroup(@NotNull List<String> valuesInGroup, @NotNull Deque<UserGroup> stateField) {
        if (valuesInGroup == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valuesInGroup", "com/intellij/vcs/log/impl/VcsLogUiPropertiesImpl", "addRecentGroup"));
        }
        if (stateField == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stateField", "com/intellij/vcs/log/impl/VcsLogUiPropertiesImpl", "addRecentGroup"));
        }
        UserGroup group = new UserGroup();
        group.users = valuesInGroup;
        if (stateField.contains(group)) {
            return;
        }
        stateField.addFirst(group);
        if (stateField.size() > 10) {
            stateField.removeLast();
        }
    }

    @Override
    @NotNull
    public List<List<String>> getRecentlyFilteredUserGroups() {
        List<List<String>> list2 = VcsLogUiPropertiesImpl.getRecentGroup(this.getState().RECENTLY_FILTERED_USER_GROUPS);
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/impl/VcsLogUiPropertiesImpl", "getRecentlyFilteredUserGroups"));
        }
        return list2;
    }

    @Override
    @NotNull
    public List<List<String>> getRecentlyFilteredBranchGroups() {
        List<List<String>> list2 = VcsLogUiPropertiesImpl.getRecentGroup(this.getState().RECENTLY_FILTERED_BRANCH_GROUPS);
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/impl/VcsLogUiPropertiesImpl", "getRecentlyFilteredBranchGroups"));
        }
        return list2;
    }

    @NotNull
    private static List<List<String>> getRecentGroup(Deque<UserGroup> stateField) {
        List list2 = ContainerUtil.map2List(stateField, group -> group.users);
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/impl/VcsLogUiPropertiesImpl", "getRecentGroup"));
        }
        return list2;
    }

    @Override
    public void saveFilterValues(@NotNull String filterName, @Nullable List<String> values) {
        if (filterName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filterName", "com/intellij/vcs/log/impl/VcsLogUiPropertiesImpl", "saveFilterValues"));
        }
        if (values != null) {
            this.getState().FILTERS.put(filterName, values);
        } else {
            this.getState().FILTERS.remove(filterName);
        }
    }

    @Override
    @Nullable
    public List<String> getFilterValues(@NotNull String filterName) {
        if (filterName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filterName", "com/intellij/vcs/log/impl/VcsLogUiPropertiesImpl", "getFilterValues"));
        }
        return this.getState().FILTERS.get(filterName);
    }

    @Override
    public void addChangeListener(@NotNull VcsLogUiProperties.PropertiesChangeListener listener2) {
        if (listener2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/vcs/log/impl/VcsLogUiPropertiesImpl", "addChangeListener"));
        }
        this.myListeners.add(listener2);
    }

    @Override
    public void removeChangeListener(@NotNull VcsLogUiProperties.PropertiesChangeListener listener2) {
        if (listener2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/vcs/log/impl/VcsLogUiPropertiesImpl", "removeChangeListener"));
        }
        this.myListeners.remove(listener2);
    }

    public static abstract class MainVcsLogUiPropertiesListener
    implements VcsLogUiProperties.PropertiesChangeListener {
        public abstract void onShowDetailsChanged();

        public abstract void onShowLongEdgesChanged();

        public abstract void onBekChanged();

        public abstract void onShowRootNamesChanged();

        public abstract void onCompactReferencesViewChanged();

        public abstract void onShowTagNamesChanged();

        public abstract void onTextFilterSettingsChanged();

        public abstract void onHighlighterChanged();

        public abstract void onColumnWidthChanged(int var1);

        public abstract void onColumnOrderChanged();

        @Override
        public <T> void onPropertyChanged(@NotNull VcsLogUiProperties.VcsLogUiProperty<T> property) {
            if (property == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/intellij/vcs/log/impl/VcsLogUiPropertiesImpl$MainVcsLogUiPropertiesListener", "onPropertyChanged"));
            }
            if (CommonUiProperties.SHOW_DETAILS.equals(property)) {
                this.onShowDetailsChanged();
            } else if (MainVcsLogUiProperties.SHOW_LONG_EDGES.equals(property)) {
                this.onShowLongEdgesChanged();
            } else if (MainVcsLogUiProperties.SHOW_ROOT_NAMES.equals(property)) {
                this.onShowRootNamesChanged();
            } else if (MainVcsLogUiProperties.COMPACT_REFERENCES_VIEW.equals(property)) {
                this.onCompactReferencesViewChanged();
            } else if (MainVcsLogUiProperties.SHOW_TAG_NAMES.equals(property)) {
                this.onShowTagNamesChanged();
            } else if (MainVcsLogUiProperties.BEK_SORT_TYPE.equals(property)) {
                this.onBekChanged();
            } else if (MainVcsLogUiProperties.TEXT_FILTER_REGEX.equals(property) || MainVcsLogUiProperties.TEXT_FILTER_MATCH_CASE.equals(property)) {
                this.onTextFilterSettingsChanged();
            } else if (CommonUiProperties.COLUMN_ORDER.equals(property)) {
                this.onColumnOrderChanged();
            } else if (property instanceof MainVcsLogUiProperties.VcsLogHighlighterProperty) {
                this.onHighlighterChanged();
            } else if (property instanceof CommonUiProperties.TableColumnProperty) {
                this.onColumnWidthChanged(((CommonUiProperties.TableColumnProperty)property).getColumn());
            } else {
                throw new UnsupportedOperationException("Property " + property + " does not exist");
            }
        }
    }

    private static class TextFilterSettings {
        public boolean REGEX = false;
        public boolean MATCH_CASE = false;

        private TextFilterSettings() {
        }
    }

    public static class UserGroup {
        public List<String> users = new ArrayList<String>();

        public boolean equals(Object o2) {
            if (this == o2) {
                return true;
            }
            if (o2 == null || this.getClass() != o2.getClass()) {
                return false;
            }
            UserGroup group = (UserGroup)o2;
            return this.users.equals(group.users);
        }

        public int hashCode() {
            return this.users.hashCode();
        }
    }

    public static class State {
        public boolean SHOW_DETAILS_IN_CHANGES = true;
        public boolean LONG_EDGES_VISIBLE = false;
        public int BEK_SORT_TYPE = 0;
        public boolean SHOW_ROOT_NAMES = false;
        public Deque<UserGroup> RECENTLY_FILTERED_USER_GROUPS = new ArrayDeque<UserGroup>();
        public Deque<UserGroup> RECENTLY_FILTERED_BRANCH_GROUPS = new ArrayDeque<UserGroup>();
        public Map<String, Boolean> HIGHLIGHTERS = ContainerUtil.newTreeMap();
        public Map<String, List<String>> FILTERS = ContainerUtil.newTreeMap();
        public boolean COMPACT_REFERENCES_VIEW = true;
        public boolean SHOW_TAG_NAMES = false;
        public TextFilterSettings TEXT_FILTER_SETTINGS = new TextFilterSettings();
        public Map<Integer, Integer> COLUMN_WIDTH = ContainerUtil.newHashMap();
        public List<Integer> COLUMN_ORDER = ContainerUtil.newArrayList();
    }
}

