/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsLogUserFilter;
import com.intellij.vcs.log.VcsUser;
import com.intellij.vcs.log.util.VcsUserUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class VcsLogUserFilterImpl
implements VcsLogUserFilter {
    private static final Logger LOG = Logger.getInstance(VcsLogUserFilterImpl.class);
    @NotNull
    public static final String ME = "me";
    @NotNull
    private final Collection<String> myUsers;
    @NotNull
    private final Map<VirtualFile, VcsUser> myData;
    @NotNull
    private final MultiMap<String, VcsUser> myAllUsersByNames;
    @NotNull
    private final MultiMap<String, VcsUser> myAllUsersByEmails;

    public VcsLogUserFilterImpl(@NotNull Collection<String> users, @NotNull Map<VirtualFile, VcsUser> meData, @NotNull Set<VcsUser> allUsers) {
        if (users == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "users", "com/intellij/vcs/log/impl/VcsLogUserFilterImpl", "<init>"));
        }
        if (meData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "meData", "com/intellij/vcs/log/impl/VcsLogUserFilterImpl", "<init>"));
        }
        if (allUsers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allUsers", "com/intellij/vcs/log/impl/VcsLogUserFilterImpl", "<init>"));
        }
        this.myAllUsersByNames = MultiMap.create();
        this.myAllUsersByEmails = MultiMap.create();
        this.myUsers = users;
        this.myData = meData;
        for (VcsUser user : allUsers) {
            String email;
            String nameFromEmail;
            String name = user.getName();
            if (!name.isEmpty()) {
                this.myAllUsersByNames.putValue((Object)VcsUserUtil.getNameInStandardForm(name), (Object)user);
            }
            if ((nameFromEmail = VcsUserUtil.getNameFromEmail(email = user.getEmail())) == null) continue;
            this.myAllUsersByEmails.putValue((Object)VcsUserUtil.getNameInStandardForm(nameFromEmail), (Object)user);
        }
    }

    @NotNull
    public Collection<VcsUser> getUsers(@NotNull VirtualFile root) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/vcs/log/impl/VcsLogUserFilterImpl", "getUsers"));
        }
        HashSet result2 = ContainerUtil.newHashSet();
        for (String user : this.myUsers) {
            result2.addAll(this.getUsers(root, user));
        }
        HashSet hashSet = result2;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/impl/VcsLogUserFilterImpl", "getUsers"));
        }
        return hashSet;
    }

    @NotNull
    private Set<VcsUser> getUsers(@NotNull VirtualFile root, @NotNull String name) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/vcs/log/impl/VcsLogUserFilterImpl", "getUsers"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/vcs/log/impl/VcsLogUserFilterImpl", "getUsers"));
        }
        HashSet users = ContainerUtil.newHashSet();
        if (ME.equals(name)) {
            VcsUser vcsUser = this.myData.get(root);
            if (vcsUser != null) {
                users.addAll(this.getUsers(vcsUser.getName()));
                String emailNamePart = VcsUserUtil.getNameFromEmail(vcsUser.getEmail());
                if (emailNamePart != null) {
                    users.addAll(this.getUsers(emailNamePart));
                }
            }
        } else {
            users.addAll(this.getUsers(name));
        }
        HashSet hashSet = users;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/impl/VcsLogUserFilterImpl", "getUsers"));
        }
        return hashSet;
    }

    @NotNull
    public Collection<String> getUserNamesForPresentation() {
        Collection<String> collection = this.myUsers;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/impl/VcsLogUserFilterImpl", "getUserNamesForPresentation"));
        }
        return collection;
    }

    public boolean matches(@NotNull VcsCommitMetadata commit) {
        if (commit == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commit", "com/intellij/vcs/log/impl/VcsLogUserFilterImpl", "matches"));
        }
        return ContainerUtil.exists(this.myUsers, name -> {
            if (commit == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commit", "com/intellij/vcs/log/impl/VcsLogUserFilterImpl", "lambda$matches$0"));
            }
            Set<VcsUser> users = this.getUsers(commit.getRoot(), (String)name);
            if (!users.isEmpty()) {
                return users.contains(commit.getAuthor());
            }
            if (!name.equals(ME)) {
                boolean result2;
                String lowerUser = VcsUserUtil.nameToLowerCase(name);
                boolean bl = result2 = VcsUserUtil.nameToLowerCase(commit.getAuthor().getName()).equals(lowerUser) || VcsUserUtil.emailToLowerCase(commit.getAuthor().getEmail()).startsWith(lowerUser + "@");
                if (result2) {
                    LOG.warn("Unregistered author " + commit.getAuthor() + " for commit " + ((Hash)commit.getId()).asString() + "; search pattern " + name);
                }
                return result2;
            }
            return false;
        });
    }

    private Set<VcsUser> getUsers(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/vcs/log/impl/VcsLogUserFilterImpl", "getUsers"));
        }
        HashSet result2 = ContainerUtil.newHashSet();
        result2.addAll(this.myAllUsersByNames.get((Object)VcsUserUtil.getNameInStandardForm(name)));
        result2.addAll(this.myAllUsersByEmails.get((Object)VcsUserUtil.getNameInStandardForm(name)));
        return result2;
    }

    public String toString() {
        return "author: " + StringUtil.join(this.myUsers, (String)", ");
    }
}

