/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.impl;

import com.intellij.vcs.log.VcsUser;
import com.intellij.vcs.log.util.VcsUserUtil;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class VcsUserImpl
implements VcsUser {
    @NotNull
    private final String myName;
    @NotNull
    private final String myEmail;

    public VcsUserImpl(@NotNull String name, @NotNull String email) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/vcs/log/impl/VcsUserImpl", "<init>"));
        }
        if (email == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "email", "com/intellij/vcs/log/impl/VcsUserImpl", "<init>"));
        }
        this.myName = name;
        this.myEmail = VcsUserUtil.emailToLowerCase(email);
    }

    @NotNull
    public String getName() {
        String string2 = this.myName;
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/impl/VcsUserImpl", "getName"));
        }
        return string2;
    }

    @NotNull
    public String getEmail() {
        String string2 = this.myEmail;
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/impl/VcsUserImpl", "getEmail"));
        }
        return string2;
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        VcsUserImpl user = (VcsUserImpl)o2;
        if (!this.myName.equals(user.myName)) {
            return false;
        }
        return this.myEmail.equals(user.myEmail);
    }

    public int hashCode() {
        return Objects.hash(this.myName, this.myEmail);
    }

    public String toString() {
        return VcsUserUtil.toExactString(this);
    }
}

