/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.paint;

import java.awt.Point;
import org.jetbrains.annotations.NotNull;

public class PositionUtil {
    private static float distance(int x1, int y1, int x2, int y2) {
        return (float)Math.hypot(x1 - x2, y1 - y2);
    }

    public static boolean overUpEdge(int upPosition, int downPosition, int x2, int y2, int rowHeight, int nodeWidth, float lineThickness) {
        int x1 = nodeWidth * downPosition + nodeWidth / 2;
        int y1 = rowHeight / 2;
        int x22 = nodeWidth * upPosition + nodeWidth / 2;
        int y22 = -rowHeight / 2;
        return PositionUtil.distance(x1, y1, x2, y2) + PositionUtil.distance(x22, y22, x2, y2) < PositionUtil.distance(x1, y1, x22, y22) + lineThickness;
    }

    public static boolean overDownEdge(int upPosition, int downPosition, int x2, int y2, int rowHeight, int nodeWidth, float lineThickness) {
        int x1 = nodeWidth * upPosition + nodeWidth / 2;
        int y1 = rowHeight / 2;
        int x22 = nodeWidth * downPosition + nodeWidth / 2;
        int y22 = rowHeight + rowHeight / 2;
        return PositionUtil.distance(x1, y1, x2, y2) + PositionUtil.distance(x22, y22, x2, y2) < PositionUtil.distance(x1, y1, x22, y22) + lineThickness;
    }

    public static boolean overNode(int position, int x2, int y2, int rowHeight, int nodeWidth, int circleRadius) {
        int x0 = nodeWidth * position + nodeWidth / 2;
        int y0 = rowHeight / 2;
        return PositionUtil.distance(x0, y0, x2, y2) <= (float)circleRadius;
    }

    public static int getYInsideRow(@NotNull Point point, int rowHeight) {
        if (point == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "point", "com/intellij/vcs/log/paint/PositionUtil", "getYInsideRow"));
        }
        return point.y - PositionUtil.getRowIndex(point, rowHeight) * rowHeight;
    }

    public static int getRowIndex(@NotNull Point point, int rowHeight) {
        if (point == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "point", "com/intellij/vcs/log/paint/PositionUtil", "getRowIndex"));
        }
        return point.y / rowHeight;
    }
}

