/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.paint;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.ui.JBColor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.graph.EdgePrintElement;
import com.intellij.vcs.log.graph.NodePrintElement;
import com.intellij.vcs.log.graph.PrintElement;
import com.intellij.vcs.log.graph.impl.print.elements.TerminalEdgePrintElement;
import com.intellij.vcs.log.paint.ColorGenerator;
import com.intellij.vcs.log.paint.GraphCellPainter;
import com.intellij.vcs.log.paint.PaintParameters;
import com.intellij.vcs.log.paint.PositionUtil;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimpleGraphCellPainter
implements GraphCellPainter {
    private static final Color MARK_COLOR = JBColor.BLACK;
    private static final double ARROW_ANGLE_COS2 = 0.7;
    private static final double ARROW_LENGTH = 0.3;
    @NotNull
    private final ColorGenerator myColorGenerator;

    public SimpleGraphCellPainter(@NotNull ColorGenerator colorGenerator) {
        if (colorGenerator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "colorGenerator", "com/intellij/vcs/log/paint/SimpleGraphCellPainter", "<init>"));
        }
        this.myColorGenerator = colorGenerator;
    }

    protected int getRowHeight() {
        return 22;
    }

    private float[] getDashLength(int edgeLength) {
        int space = this.getRowHeight() / 4 - 1;
        int dash = this.getRowHeight() / 4 + 1;
        int count = edgeLength / (2 * (dash + space));
        assert (count != 0);
        int dashApprox = (edgeLength / 2 - count * space) / count;
        return new float[]{2 * dashApprox, 2 * space};
    }

    @NotNull
    private BasicStroke getOrdinaryStroke() {
        BasicStroke basicStroke = new BasicStroke(PaintParameters.getLineThickness(this.getRowHeight()), 1, 2);
        if (basicStroke == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/paint/SimpleGraphCellPainter", "getOrdinaryStroke"));
        }
        return basicStroke;
    }

    @NotNull
    private BasicStroke getSelectedStroke() {
        BasicStroke basicStroke = new BasicStroke(PaintParameters.getSelectedLineThickness(this.getRowHeight()), 1, 2);
        if (basicStroke == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/paint/SimpleGraphCellPainter", "getSelectedStroke"));
        }
        return basicStroke;
    }

    @NotNull
    private Stroke getDashedStroke(float[] dash) {
        BasicStroke basicStroke = new BasicStroke(PaintParameters.getLineThickness(this.getRowHeight()), 1, 2, 0.0f, dash, dash[0] / 2.0f);
        if (basicStroke == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/paint/SimpleGraphCellPainter", "getDashedStroke"));
        }
        return basicStroke;
    }

    @NotNull
    private Stroke getSelectedDashedStroke(float[] dash) {
        BasicStroke basicStroke = new BasicStroke(PaintParameters.getSelectedLineThickness(this.getRowHeight()), 1, 2, 0.0f, dash, dash[0] / 2.0f);
        if (basicStroke == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/paint/SimpleGraphCellPainter", "getSelectedDashedStroke"));
        }
        return basicStroke;
    }

    private void paintUpLine(@NotNull Graphics2D g2, @NotNull Color color, int from, int to, boolean hasArrow, boolean isUsual, boolean isSelected, boolean isTerminal) {
        if (g2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g2", "com/intellij/vcs/log/paint/SimpleGraphCellPainter", "paintUpLine"));
        }
        if (color == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "color", "com/intellij/vcs/log/paint/SimpleGraphCellPainter", "paintUpLine"));
        }
        int nodeWidth = PaintParameters.getNodeWidth(this.getRowHeight());
        if (from == to) {
            int x2 = nodeWidth * from + nodeWidth / 2;
            int y1 = this.getRowHeight() / 2 - 1;
            int y2 = isTerminal ? PaintParameters.getCircleRadius(this.getRowHeight()) / 2 + 1 : 0;
            this.paintLine(g2, color, hasArrow, x2, y1, x2, y2, x2, y2, isUsual, isSelected);
        } else {
            assert (!isTerminal);
            int x1 = nodeWidth * from + nodeWidth / 2;
            int y1 = this.getRowHeight() / 2;
            int x2 = nodeWidth * to + nodeWidth / 2;
            int y2 = -this.getRowHeight() / 2;
            this.paintLine(g2, color, hasArrow, x1, y1, x2, y2, (x1 + x2) / 2, (y1 + y2) / 2, isUsual, isSelected);
        }
    }

    private void paintDownLine(@NotNull Graphics2D g2, @NotNull Color color, int from, int to, boolean hasArrow, boolean isUsual, boolean isSelected, boolean isTerminal) {
        if (g2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g2", "com/intellij/vcs/log/paint/SimpleGraphCellPainter", "paintDownLine"));
        }
        if (color == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "color", "com/intellij/vcs/log/paint/SimpleGraphCellPainter", "paintDownLine"));
        }
        int nodeWidth = PaintParameters.getNodeWidth(this.getRowHeight());
        if (from == to) {
            int y2 = this.getRowHeight() - 1 - (isTerminal ? PaintParameters.getCircleRadius(this.getRowHeight()) / 2 + 1 : 0);
            int y1 = this.getRowHeight() / 2;
            int x2 = nodeWidth * from + nodeWidth / 2;
            this.paintLine(g2, color, hasArrow, x2, y1, x2, y2, x2, y2, isUsual, isSelected);
        } else {
            assert (!isTerminal);
            int x1 = nodeWidth * from + nodeWidth / 2;
            int y1 = this.getRowHeight() / 2;
            int x2 = nodeWidth * to + nodeWidth / 2;
            int y2 = this.getRowHeight() + this.getRowHeight() / 2;
            this.paintLine(g2, color, hasArrow, x1, y1, x2, y2, (x1 + x2) / 2, (y1 + y2) / 2, isUsual, isSelected);
        }
    }

    private void paintLine(@NotNull Graphics2D g2, @NotNull Color color, boolean hasArrow, int x1, int y1, int x2, int y2, int startArrowX, int startArrowY, boolean isUsual, boolean isSelected) {
        if (g2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g2", "com/intellij/vcs/log/paint/SimpleGraphCellPainter", "paintLine"));
        }
        if (color == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "color", "com/intellij/vcs/log/paint/SimpleGraphCellPainter", "paintLine"));
        }
        g2.setColor(color);
        int length = x1 == x2 ? this.getRowHeight() : (int)Math.ceil(Math.hypot(x1 - x2, y1 - y2));
        this.setStroke(g2, isUsual || hasArrow, isSelected, length);
        g2.drawLine(x1, y1, x2, y2);
        if (hasArrow) {
            Pair<Integer, Integer> rotate1 = SimpleGraphCellPainter.rotate(x1, y1, startArrowX, startArrowY, Math.sqrt(0.7), Math.sqrt(0.30000000000000004), 0.3 * (double)this.getRowHeight());
            Pair<Integer, Integer> rotate2 = SimpleGraphCellPainter.rotate(x1, y1, startArrowX, startArrowY, Math.sqrt(0.7), -Math.sqrt(0.30000000000000004), 0.3 * (double)this.getRowHeight());
            g2.drawLine(startArrowX, startArrowY, (Integer)rotate1.first, (Integer)rotate1.second);
            g2.drawLine(startArrowX, startArrowY, (Integer)rotate2.first, (Integer)rotate2.second);
        }
    }

    @NotNull
    private static Pair<Integer, Integer> rotate(double x2, double y2, double centerX, double centerY, double cos, double sin, double arrowLength) {
        double translateX = x2 - centerX;
        double translateY = y2 - centerY;
        double d2 = Math.hypot(translateX, translateY);
        double scaleX = arrowLength * translateX / d2;
        double scaleY = arrowLength * translateY / d2;
        double rotateX = scaleX * cos - scaleY * sin;
        double rotateY = scaleX * sin + scaleY * cos;
        Pair pair = Pair.create((Object)((int)Math.round(rotateX + centerX)), (Object)((int)Math.round(rotateY + centerY)));
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/paint/SimpleGraphCellPainter", "rotate"));
        }
        return pair;
    }

    private void paintCircle(@NotNull Graphics2D g2, int position, @NotNull Color color, boolean select) {
        if (g2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g2", "com/intellij/vcs/log/paint/SimpleGraphCellPainter", "paintCircle"));
        }
        if (color == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "color", "com/intellij/vcs/log/paint/SimpleGraphCellPainter", "paintCircle"));
        }
        int nodeWidth = PaintParameters.getNodeWidth(this.getRowHeight());
        int circleRadius = PaintParameters.getCircleRadius(this.getRowHeight());
        int selectedCircleRadius = PaintParameters.getSelectedCircleRadius(this.getRowHeight());
        int x0 = nodeWidth * position + nodeWidth / 2;
        int y0 = this.getRowHeight() / 2;
        int r2 = circleRadius;
        if (select) {
            r2 = selectedCircleRadius;
        }
        Ellipse2D.Double circle = new Ellipse2D.Double((double)(x0 - r2) + 0.5, (double)(y0 - r2) + 0.5, 2 * r2, 2 * r2);
        g2.setColor(color);
        g2.fill(circle);
    }

    private void setStroke(@NotNull Graphics2D g2, boolean usual, boolean select, int edgeLength) {
        if (g2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g2", "com/intellij/vcs/log/paint/SimpleGraphCellPainter", "setStroke"));
        }
        if (usual) {
            if (select) {
                g2.setStroke(this.getSelectedStroke());
            } else {
                g2.setStroke(this.getOrdinaryStroke());
            }
        } else if (select) {
            g2.setStroke(this.getSelectedDashedStroke(this.getDashLength(edgeLength)));
        } else {
            g2.setStroke(this.getDashedStroke(this.getDashLength(edgeLength)));
        }
    }

    @NotNull
    private Color getColor(@NotNull PrintElement printElement) {
        if (printElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "printElement", "com/intellij/vcs/log/paint/SimpleGraphCellPainter", "getColor"));
        }
        Color color = this.myColorGenerator.getColor(printElement.getColorId());
        if (color == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/paint/SimpleGraphCellPainter", "getColor"));
        }
        return color;
    }

    private static boolean isUsual(@NotNull PrintElement printElement) {
        if (printElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "printElement", "com/intellij/vcs/log/paint/SimpleGraphCellPainter", "isUsual"));
        }
        if (!(printElement instanceof EdgePrintElement)) {
            return true;
        }
        EdgePrintElement.LineStyle lineStyle = ((EdgePrintElement)printElement).getLineStyle();
        return lineStyle == EdgePrintElement.LineStyle.SOLID;
    }

    @Override
    public void draw(@NotNull Graphics2D g2, @NotNull Collection<? extends PrintElement> printElements) {
        if (g2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g2", "com/intellij/vcs/log/paint/SimpleGraphCellPainter", "draw"));
        }
        if (printElements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "printElements", "com/intellij/vcs/log/paint/SimpleGraphCellPainter", "draw"));
        }
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        for (PrintElement printElement : printElements) {
            if (printElement.isSelected()) continue;
            this.drawElement(g2, printElement, false);
        }
        List selected = ContainerUtil.filter(printElements, (Condition)new Condition<PrintElement>(){

            public boolean value(PrintElement printElement) {
                return printElement.isSelected();
            }
        });
        for (PrintElement printElement : selected) {
            this.drawElement(g2, printElement, true);
        }
        for (PrintElement printElement : selected) {
            this.drawElement(g2, printElement, false);
        }
    }

    protected void drawElement(@NotNull Graphics2D g2, @NotNull PrintElement printElement, boolean isSelected) {
        if (g2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g2", "com/intellij/vcs/log/paint/SimpleGraphCellPainter", "drawElement"));
        }
        if (printElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "printElement", "com/intellij/vcs/log/paint/SimpleGraphCellPainter", "drawElement"));
        }
        if (printElement instanceof EdgePrintElement) {
            if (isSelected) {
                this.printEdge(g2, MARK_COLOR, true, (EdgePrintElement)printElement);
            } else {
                this.printEdge(g2, this.getColor(printElement), false, (EdgePrintElement)printElement);
            }
        }
        if (printElement instanceof NodePrintElement) {
            int position = printElement.getPositionInCurrentRow();
            if (isSelected) {
                this.paintCircle(g2, position, MARK_COLOR, true);
            } else {
                this.paintCircle(g2, position, this.getColor(printElement), false);
            }
        }
    }

    private void printEdge(@NotNull Graphics2D g2, @NotNull Color color, boolean isSelected, @NotNull EdgePrintElement edgePrintElement) {
        if (g2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g2", "com/intellij/vcs/log/paint/SimpleGraphCellPainter", "printEdge"));
        }
        if (color == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "color", "com/intellij/vcs/log/paint/SimpleGraphCellPainter", "printEdge"));
        }
        if (edgePrintElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "edgePrintElement", "com/intellij/vcs/log/paint/SimpleGraphCellPainter", "printEdge"));
        }
        int from = edgePrintElement.getPositionInCurrentRow();
        int to = edgePrintElement.getPositionInOtherRow();
        boolean isUsual = SimpleGraphCellPainter.isUsual((PrintElement)edgePrintElement);
        if (edgePrintElement.getType() == EdgePrintElement.Type.DOWN) {
            this.paintDownLine(g2, color, from, to, edgePrintElement.hasArrow(), isUsual, isSelected, edgePrintElement instanceof TerminalEdgePrintElement);
        } else {
            this.paintUpLine(g2, color, from, to, edgePrintElement.hasArrow(), isUsual, isSelected, edgePrintElement instanceof TerminalEdgePrintElement);
        }
    }

    @Override
    @Nullable
    public PrintElement getElementUnderCursor(@NotNull Collection<? extends PrintElement> printElements, int x2, int y2) {
        if (printElements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "printElements", "com/intellij/vcs/log/paint/SimpleGraphCellPainter", "getElementUnderCursor"));
        }
        int nodeWidth = PaintParameters.getNodeWidth(this.getRowHeight());
        for (PrintElement printElement : printElements) {
            if (!(printElement instanceof NodePrintElement)) continue;
            int circleRadius = PaintParameters.getCircleRadius(this.getRowHeight());
            if (!PositionUtil.overNode(printElement.getPositionInCurrentRow(), x2, y2, this.getRowHeight(), nodeWidth, circleRadius)) continue;
            return printElement;
        }
        for (PrintElement printElement : printElements) {
            if (!(printElement instanceof EdgePrintElement)) continue;
            EdgePrintElement edgePrintElement = (EdgePrintElement)printElement;
            float lineThickness = PaintParameters.getLineThickness(this.getRowHeight());
            if (!(edgePrintElement.getType() == EdgePrintElement.Type.DOWN ? PositionUtil.overDownEdge(edgePrintElement.getPositionInCurrentRow(), edgePrintElement.getPositionInOtherRow(), x2, y2, this.getRowHeight(), nodeWidth, lineThickness) : PositionUtil.overUpEdge(edgePrintElement.getPositionInOtherRow(), edgePrintElement.getPositionInCurrentRow(), x2, y2, this.getRowHeight(), nodeWidth, lineThickness))) continue;
            return printElement;
        }
        return null;
    }
}

