/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.actions;

import com.intellij.ide.actions.CloseTabToolbarAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.util.ContentUtilEx;
import com.intellij.util.ContentsUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CloseLogTabAction
extends CloseTabToolbarAction {
    public void update(@NotNull AnActionEvent e2) {
        if (e2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/vcs/log/ui/actions/CloseLogTabAction", "update"));
        }
        super.update(e2);
        if (e2.getProject() == null) {
            e2.getPresentation().setEnabledAndVisible(false);
            return;
        }
        ContentManager contentManager = CloseLogTabAction.getContentManager(e2.getProject());
        if (contentManager == null || CloseLogTabAction.getTabbedContent(contentManager) == null) {
            e2.getPresentation().setEnabledAndVisible(false);
            return;
        }
        e2.getPresentation().setEnabledAndVisible(true);
    }

    public void actionPerformed(@NotNull AnActionEvent e2) {
        if (e2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/vcs/log/ui/actions/CloseLogTabAction", "actionPerformed"));
        }
        Project project2 = e2.getProject();
        assert (project2 != null);
        ContentManager contentManager = CloseLogTabAction.getContentManager(project2);
        if (contentManager == null) {
            return;
        }
        Content selectedContent = CloseLogTabAction.getTabbedContent(contentManager);
        if (selectedContent != null) {
            ContentsUtil.closeContentTab((ContentManager)contentManager, (Content)selectedContent);
        }
    }

    @Nullable
    private static Content getTabbedContent(@NotNull ContentManager contentManager) {
        if (contentManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contentManager", "com/intellij/vcs/log/ui/actions/CloseLogTabAction", "getTabbedContent"));
        }
        Content content2 = contentManager.getSelectedContent();
        if (content2 != null && (ContentUtilEx.isContentTab(content2, "Log") || ContentUtilEx.isContentTab(content2, "History"))) {
            return content2;
        }
        return null;
    }

    @Nullable
    private static ContentManager getContentManager(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/vcs/log/ui/actions/CloseLogTabAction", "getContentManager"));
        }
        ToolWindow toolWindow = ToolWindowManager.getInstance((Project)project2).getToolWindow(ToolWindowId.VCS);
        if (toolWindow == null) {
            return null;
        }
        return toolWindow.getContentManager();
    }
}

