/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.vcs.log.VcsLogDataKeys;
import com.intellij.vcs.log.VcsLogUi;
import com.intellij.vcs.log.ui.VcsLogUiImpl;
import com.intellij.vcs.log.ui.frame.MainFrame;
import java.awt.Component;
import org.jetbrains.annotations.NotNull;

public class FocusTextFilterAction
extends DumbAwareAction {
    public FocusTextFilterAction() {
        super("Focus Text Filter", "Focus text filter or move focus back to the commits list", null);
    }

    public void update(@NotNull AnActionEvent e2) {
        if (e2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/vcs/log/ui/actions/FocusTextFilterAction", "update"));
        }
        Project project2 = e2.getProject();
        VcsLogUi ui = (VcsLogUi)e2.getData(VcsLogDataKeys.VCS_LOG_UI);
        e2.getPresentation().setEnabledAndVisible(project2 != null && ui != null && ui instanceof VcsLogUiImpl);
    }

    public void actionPerformed(@NotNull AnActionEvent e2) {
        if (e2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/vcs/log/ui/actions/FocusTextFilterAction", "actionPerformed"));
        }
        Project project2 = (Project)e2.getRequiredData(CommonDataKeys.PROJECT);
        MainFrame mainFrame = ((VcsLogUiImpl)e2.getRequiredData(VcsLogDataKeys.VCS_LOG_UI)).getMainFrame();
        if (mainFrame.getTextFilter().getTextEditor().hasFocus()) {
            IdeFocusManager.getInstance((Project)project2).requestFocus((Component)((Object)mainFrame.getGraphTable()), true);
        } else {
            IdeFocusManager.getInstance((Project)project2).requestFocus((Component)mainFrame.getTextFilter(), true);
        }
    }
}

