/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.actions;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.textCompletion.DefaultTextCompletionValueDescriptor;
import com.intellij.util.textCompletion.ValuesCompletionProvider;
import com.intellij.util.ui.ColorIcon;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcs.log.VcsLogRefs;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.ui.VcsLogColorManager;
import com.intellij.vcs.log.ui.actions.TextFieldWithProgress;
import com.intellij.vcs.log.ui.table.VcsLogGraphTable;
import com.intellij.vcsUtil.VcsImplUtil;
import java.awt.Color;
import java.awt.Component;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GoToHashOrRefPopup {
    private static final Logger LOG = Logger.getInstance(GoToHashOrRefPopup.class);
    @NotNull
    private final TextFieldWithProgress myTextField;
    @NotNull
    private final Function<String, Future> myOnSelectedHash;
    @NotNull
    private final Function<VcsRef, Future> myOnSelectedRef;
    @NotNull
    private final JBPopup myPopup;
    @Nullable
    private Future myFuture;
    @Nullable
    private VcsRef mySelectedRef;

    public GoToHashOrRefPopup(@NotNull Project project2, @NotNull VcsLogRefs variants, Collection<VirtualFile> roots, @NotNull Function<String, Future> onSelectedHash, @NotNull Function<VcsRef, Future> onSelectedRef, @NotNull VcsLogColorManager colorManager, @NotNull Comparator<VcsRef> comparator2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/vcs/log/ui/actions/GoToHashOrRefPopup", "<init>"));
        }
        if (variants == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variants", "com/intellij/vcs/log/ui/actions/GoToHashOrRefPopup", "<init>"));
        }
        if (onSelectedHash == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "onSelectedHash", "com/intellij/vcs/log/ui/actions/GoToHashOrRefPopup", "<init>"));
        }
        if (onSelectedRef == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "onSelectedRef", "com/intellij/vcs/log/ui/actions/GoToHashOrRefPopup", "<init>"));
        }
        if (colorManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "colorManager", "com/intellij/vcs/log/ui/actions/GoToHashOrRefPopup", "<init>"));
        }
        if (comparator2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comparator", "com/intellij/vcs/log/ui/actions/GoToHashOrRefPopup", "<init>"));
        }
        this.myOnSelectedHash = onSelectedHash;
        this.myOnSelectedRef = onSelectedRef;
        this.myTextField = new TextFieldWithProgress(project2, new VcsRefCompletionProvider(project2, variants, roots, colorManager, comparator2)){

            @Override
            public void onOk() {
                if (GoToHashOrRefPopup.this.myFuture == null) {
                    Future future2 = GoToHashOrRefPopup.this.mySelectedRef == null || !GoToHashOrRefPopup.this.mySelectedRef.getName().equals(this.getText().trim()) ? (Future)GoToHashOrRefPopup.this.myOnSelectedHash.fun((Object)this.getText().trim()) : (Future)GoToHashOrRefPopup.this.myOnSelectedRef.fun((Object)GoToHashOrRefPopup.this.mySelectedRef);
                    GoToHashOrRefPopup.this.myFuture = future2;
                    this.showProgress();
                    ApplicationManager.getApplication().executeOnPooledThread(() -> {
                        try {
                            future2.get();
                            GoToHashOrRefPopup.this.okPopup();
                        }
                        catch (InterruptedException | CancellationException ex) {
                            GoToHashOrRefPopup.this.cancelPopup();
                        }
                        catch (ExecutionException ex) {
                            LOG.error((Throwable)ex);
                            GoToHashOrRefPopup.this.cancelPopup();
                        }
                    });
                }
            }
        };
        this.myTextField.setAlignmentX(0.0f);
        JBLabel label = new JBLabel("Enter hash or branch/tag name:");
        label.setFont(UIUtil.getLabelFont().deriveFont(1));
        label.setAlignmentX(0.0f);
        JPanel panel2 = new JPanel();
        BoxLayout layout = new BoxLayout(panel2, 3);
        panel2.setLayout(layout);
        panel2.add((Component)label);
        panel2.add(this.myTextField);
        panel2.setBorder(new EmptyBorder(2, 2, 2, 2));
        this.myPopup = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)panel2, this.myTextField.getPreferableFocusComponent()).setCancelOnClickOutside(true).setCancelOnWindowDeactivation(true).setCancelKeyEnabled(true).setRequestFocus(true).createPopup();
        this.myPopup.addListener((JBPopupListener)new JBPopupListener.Adapter(){

            public void onClosed(LightweightWindowEvent event) {
                if (!event.isOk() && GoToHashOrRefPopup.this.myFuture != null) {
                    GoToHashOrRefPopup.this.myFuture.cancel(true);
                }
                GoToHashOrRefPopup.this.myFuture = null;
                GoToHashOrRefPopup.this.myTextField.hideProgress();
            }
        });
    }

    private void cancelPopup() {
        ApplicationManager.getApplication().invokeLater(() -> this.myPopup.cancel());
    }

    private void okPopup() {
        ApplicationManager.getApplication().invokeLater(() -> this.myPopup.closeOk(null));
    }

    public void show(@NotNull JComponent anchor) {
        if (anchor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anchor", "com/intellij/vcs/log/ui/actions/GoToHashOrRefPopup", "show"));
        }
        this.myPopup.showInCenterOf((Component)anchor);
    }

    private class VcsRefDescriptor
    extends DefaultTextCompletionValueDescriptor<VcsRef> {
        @NotNull
        private final Project myProject;
        @NotNull
        private final VcsLogColorManager myColorManager;
        @NotNull
        private final Comparator<VcsRef> myReferenceComparator;
        @NotNull
        private final Map<VirtualFile, String> myCachedRootNames;

        private VcsRefDescriptor(@NotNull Project project2, @NotNull VcsLogColorManager manager, @NotNull Comparator<VcsRef> comparator2, Collection<VirtualFile> roots) {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/vcs/log/ui/actions/GoToHashOrRefPopup$VcsRefDescriptor", "<init>"));
            }
            if (manager == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/vcs/log/ui/actions/GoToHashOrRefPopup$VcsRefDescriptor", "<init>"));
            }
            if (comparator2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comparator", "com/intellij/vcs/log/ui/actions/GoToHashOrRefPopup$VcsRefDescriptor", "<init>"));
            }
            if (roots == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "com/intellij/vcs/log/ui/actions/GoToHashOrRefPopup$VcsRefDescriptor", "<init>"));
            }
            this.myCachedRootNames = ContainerUtil.newHashMap();
            this.myProject = project2;
            this.myColorManager = manager;
            this.myReferenceComparator = comparator2;
            for (VirtualFile root : roots) {
                String text2 = VcsImplUtil.getShortVcsRootName(this.myProject, root);
                this.myCachedRootNames.put(root, text2);
            }
        }

        @Override
        @NotNull
        public LookupElementBuilder createLookupBuilder(@NotNull VcsRef item) {
            if (item == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/intellij/vcs/log/ui/actions/GoToHashOrRefPopup$VcsRefDescriptor", "createLookupBuilder"));
            }
            LookupElementBuilder lookupBuilder = super.createLookupBuilder(item);
            if (this.myColorManager.isMultipleRoots()) {
                lookupBuilder = lookupBuilder.withTypeText(this.getTypeText(item), (Icon)JBUI.scale((JBUI.JBIcon)new ColorIcon(15, (Color)VcsLogGraphTable.getRootBackgroundColor(item.getRoot(), this.myColorManager))), true);
            }
            LookupElementBuilder lookupElementBuilder = lookupBuilder;
            if (lookupElementBuilder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/actions/GoToHashOrRefPopup$VcsRefDescriptor", "createLookupBuilder"));
            }
            return lookupElementBuilder;
        }

        @Override
        @NotNull
        public String getLookupString(@NotNull VcsRef item) {
            if (item == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/intellij/vcs/log/ui/actions/GoToHashOrRefPopup$VcsRefDescriptor", "getLookupString"));
            }
            String string2 = item.getName();
            if (string2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/actions/GoToHashOrRefPopup$VcsRefDescriptor", "getLookupString"));
            }
            return string2;
        }

        @Override
        @Nullable
        protected String getTailText(@NotNull VcsRef item) {
            if (item == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/intellij/vcs/log/ui/actions/GoToHashOrRefPopup$VcsRefDescriptor", "getTailText"));
            }
            if (!this.myColorManager.isMultipleRoots()) {
                return null;
            }
            return "";
        }

        @Override
        @Nullable
        protected String getTypeText(@NotNull VcsRef item) {
            if (item == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/intellij/vcs/log/ui/actions/GoToHashOrRefPopup$VcsRefDescriptor", "getTypeText"));
            }
            if (!this.myColorManager.isMultipleRoots()) {
                return null;
            }
            String text2 = this.myCachedRootNames.get(item.getRoot());
            if (text2 == null) {
                return VcsImplUtil.getShortVcsRootName(this.myProject, item.getRoot());
            }
            return text2;
        }

        @Override
        public int compare(VcsRef item1, VcsRef item2) {
            return this.myReferenceComparator.compare(item1, item2);
        }

        @Override
        @Nullable
        protected InsertHandler<LookupElement> createInsertHandler(@NotNull VcsRef item) {
            if (item == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/intellij/vcs/log/ui/actions/GoToHashOrRefPopup$VcsRefDescriptor", "createInsertHandler"));
            }
            return (context2, item1) -> {
                GoToHashOrRefPopup.this.mySelectedRef = (VcsRef)item1.getObject();
                ApplicationManager.getApplication().invokeLater(() -> GoToHashOrRefPopup.this.myTextField.onOk());
            };
        }
    }

    private class VcsRefCompletionProvider
    extends ValuesCompletionProvider<VcsRef> {
        private static final int TIMEOUT = 100;
        @NotNull
        private final VcsLogRefs myRefs;
        @NotNull
        private final Collection<VirtualFile> myRoots;

        public VcsRefCompletionProvider(@NotNull Project project2, @NotNull VcsLogRefs refs, @NotNull Collection<VirtualFile> roots, @NotNull VcsLogColorManager colorManager, Comparator<VcsRef> comparator2) {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/vcs/log/ui/actions/GoToHashOrRefPopup$VcsRefCompletionProvider", "<init>"));
            }
            if (refs == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refs", "com/intellij/vcs/log/ui/actions/GoToHashOrRefPopup$VcsRefCompletionProvider", "<init>"));
            }
            if (roots == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "com/intellij/vcs/log/ui/actions/GoToHashOrRefPopup$VcsRefCompletionProvider", "<init>"));
            }
            if (colorManager == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "colorManager", "com/intellij/vcs/log/ui/actions/GoToHashOrRefPopup$VcsRefCompletionProvider", "<init>"));
            }
            if (comparator2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comparator", "com/intellij/vcs/log/ui/actions/GoToHashOrRefPopup$VcsRefCompletionProvider", "<init>"));
            }
            super(new VcsRefDescriptor(project2, colorManager, comparator2, roots), ContainerUtil.emptyList());
            this.myRefs = refs;
            this.myRoots = roots;
        }

        @Override
        public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull String prefix, @NotNull CompletionResultSet result2) {
            if (parameters == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/vcs/log/ui/actions/GoToHashOrRefPopup$VcsRefCompletionProvider", "fillCompletionVariants"));
            }
            if (prefix == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "com/intellij/vcs/log/ui/actions/GoToHashOrRefPopup$VcsRefCompletionProvider", "fillCompletionVariants"));
            }
            if (result2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/vcs/log/ui/actions/GoToHashOrRefPopup$VcsRefCompletionProvider", "fillCompletionVariants"));
            }
            this.addValues(result2, this.filterAndSort(result2, this.myRefs.getBranches().stream()));
            Future future2 = ApplicationManager.getApplication().executeOnPooledThread(() -> {
                if (result2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/vcs/log/ui/actions/GoToHashOrRefPopup$VcsRefCompletionProvider", "lambda$fillCompletionVariants$1"));
                }
                return this.filterAndSort(result2, this.myRefs.stream().filter(ref -> !ref.getType().isBranch()));
            });
            while (true) {
                try {
                    List tags = (List)future2.get(100L, TimeUnit.MILLISECONDS);
                    if (tags != null) {
                        this.addValues(result2, tags);
                        break;
                    }
                }
                catch (InterruptedException | CancellationException e2) {
                    break;
                }
                catch (TimeoutException e2) {
                }
                catch (ExecutionException e3) {
                    LOG.error((Throwable)e3);
                    break;
                }
                ProgressManager.checkCanceled();
            }
            result2.stopHere();
        }

        public void addValues(@NotNull CompletionResultSet result2, @NotNull Collection<? extends VcsRef> values) {
            if (result2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/vcs/log/ui/actions/GoToHashOrRefPopup$VcsRefCompletionProvider", "addValues"));
            }
            if (values == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "values", "com/intellij/vcs/log/ui/actions/GoToHashOrRefPopup$VcsRefCompletionProvider", "addValues"));
            }
            for (VcsRef vcsRef : values) {
                result2.addElement(this.installInsertHandler(this.myDescriptor.createLookupBuilder(vcsRef)));
            }
        }

        @NotNull
        private List<VcsRef> filterAndSort(@NotNull CompletionResultSet result2, @NotNull Stream<VcsRef> stream) {
            if (result2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/vcs/log/ui/actions/GoToHashOrRefPopup$VcsRefCompletionProvider", "filterAndSort"));
            }
            if (stream == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stream", "com/intellij/vcs/log/ui/actions/GoToHashOrRefPopup$VcsRefCompletionProvider", "filterAndSort"));
            }
            List list2 = ContainerUtil.sorted((Collection)stream.filter(ref -> {
                if (result2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/vcs/log/ui/actions/GoToHashOrRefPopup$VcsRefCompletionProvider", "lambda$filterAndSort$2"));
                }
                return this.myRoots.contains(ref.getRoot()) && result2.getPrefixMatcher().prefixMatches(ref.getName());
            }).collect(Collectors.toList()), (Comparator)this.myDescriptor);
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/actions/GoToHashOrRefPopup$VcsRefCompletionProvider", "filterAndSort"));
            }
            return list2;
        }
    }
}

