/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.actions;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.impl.MainVcsLogUiProperties;
import com.intellij.vcs.log.impl.VcsLogUiProperties;
import com.intellij.vcs.log.ui.VcsLogInternalDataKeys;
import com.intellij.vcs.log.ui.VcsLogUiImpl;
import com.intellij.vcs.log.ui.actions.BooleanPropertyToggleAction;
import com.intellij.vcs.log.ui.highlighters.VcsLogHighlighterFactory;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HighlightersActionGroup
extends ActionGroup {
    @NotNull
    public AnAction[] getChildren(@Nullable AnActionEvent e2) {
        ArrayList actions2 = ContainerUtil.newArrayList();
        if (e2 != null && e2.getData(VcsLogInternalDataKeys.LOG_UI_PROPERTIES) != null) {
            actions2.add(new Separator("Highlight"));
            for (VcsLogHighlighterFactory factory2 : (VcsLogHighlighterFactory[])Extensions.getExtensions((ExtensionPointName)VcsLogUiImpl.LOG_HIGHLIGHTER_FACTORY_EP, (AreaInstance)e2.getProject())) {
                if (!factory2.showMenuItem()) continue;
                actions2.add(new EnableHighlighterAction(factory2));
            }
        }
        AnAction[] anActionArray = actions2.toArray(new AnAction[actions2.size()]);
        if (anActionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/actions/HighlightersActionGroup", "getChildren"));
        }
        return anActionArray;
    }

    private static class EnableHighlighterAction
    extends BooleanPropertyToggleAction {
        @NotNull
        private final VcsLogHighlighterFactory myFactory;

        private EnableHighlighterAction(@NotNull VcsLogHighlighterFactory factory2) {
            if (factory2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "com/intellij/vcs/log/ui/actions/HighlightersActionGroup$EnableHighlighterAction", "<init>"));
            }
            super(factory2.getTitle());
            this.myFactory = factory2;
        }

        @Override
        protected VcsLogUiProperties.VcsLogUiProperty<Boolean> getProperty() {
            return MainVcsLogUiProperties.VcsLogHighlighterProperty.get(this.myFactory.getId());
        }
    }
}

