/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.actions;

import com.intellij.openapi.actionSystem.ActionButtonComponent;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.VcsLogDataKeys;
import com.intellij.vcs.log.VcsLogUi;
import com.intellij.vcs.log.graph.PermanentGraph;
import com.intellij.vcs.log.impl.MainVcsLogUiProperties;
import com.intellij.vcs.log.impl.VcsLogUiProperties;
import com.intellij.vcs.log.ui.VcsLogInternalDataKeys;
import icons.VcsLogIcons;
import java.awt.Component;
import org.jetbrains.annotations.NotNull;

public class IntelliSortChooserPopupAction
extends DumbAwareAction {
    public IntelliSortChooserPopupAction() {
        super("IntelliSort", "Change IntelliSort Type", VcsLogIcons.IntelliSort);
    }

    public void actionPerformed(AnActionEvent e2) {
        VcsLogUi logUI = (VcsLogUi)e2.getRequiredData(VcsLogDataKeys.VCS_LOG_UI);
        VcsLogUiProperties properties = (VcsLogUiProperties)e2.getRequiredData(VcsLogInternalDataKeys.LOG_UI_PROPERTIES);
        DefaultActionGroup settingsGroup = new DefaultActionGroup(ContainerUtil.map((Object[])PermanentGraph.SortType.values(), sortType -> new SelectIntelliSortTypeAction(logUI, properties, (PermanentGraph.SortType)sortType)));
        ListPopup popup2 = JBPopupFactory.getInstance().createActionGroupPopup(null, (ActionGroup)settingsGroup, e2.getDataContext(), JBPopupFactory.ActionSelectionAid.MNEMONICS, true, "ToolwindowPopup");
        Component component = e2.getInputEvent().getComponent();
        if (component instanceof ActionButtonComponent) {
            popup2.showUnderneathOf(component);
        } else {
            popup2.showInCenterOf(component);
        }
    }

    public void update(AnActionEvent e2) {
        super.update(e2);
        VcsLogUiProperties properties = (VcsLogUiProperties)e2.getData(VcsLogInternalDataKeys.LOG_UI_PROPERTIES);
        e2.getPresentation().setEnabled(properties != null);
        if (properties != null && properties.exists(MainVcsLogUiProperties.BEK_SORT_TYPE)) {
            String description = "IntelliSort: " + properties.get(MainVcsLogUiProperties.BEK_SORT_TYPE).getName();
            e2.getPresentation().setDescription(description);
            e2.getPresentation().setText(description);
        }
    }

    private static class SelectIntelliSortTypeAction
    extends ToggleAction
    implements DumbAware {
        private final PermanentGraph.SortType mySortType;
        private final VcsLogUi myUI;
        private final VcsLogUiProperties myProperties;

        public SelectIntelliSortTypeAction(@NotNull VcsLogUi ui, @NotNull VcsLogUiProperties properties, @NotNull PermanentGraph.SortType sortType) {
            if (ui == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ui", "com/intellij/vcs/log/ui/actions/IntelliSortChooserPopupAction$SelectIntelliSortTypeAction", "<init>"));
            }
            if (properties == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/intellij/vcs/log/ui/actions/IntelliSortChooserPopupAction$SelectIntelliSortTypeAction", "<init>"));
            }
            if (sortType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sortType", "com/intellij/vcs/log/ui/actions/IntelliSortChooserPopupAction$SelectIntelliSortTypeAction", "<init>"));
            }
            super(sortType.getName(), sortType.getDescription() + ".", null);
            this.myUI = ui;
            this.myProperties = properties;
            this.mySortType = sortType;
        }

        public void update(@NotNull AnActionEvent e2) {
            if (e2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/vcs/log/ui/actions/IntelliSortChooserPopupAction$SelectIntelliSortTypeAction", "update"));
            }
            super.update(e2);
            e2.getPresentation().setEnabled(this.myUI.areGraphActionsEnabled() && this.myProperties.exists(MainVcsLogUiProperties.BEK_SORT_TYPE));
        }

        public boolean isSelected(AnActionEvent e2) {
            return this.myProperties.exists(MainVcsLogUiProperties.BEK_SORT_TYPE) && this.myProperties.get(MainVcsLogUiProperties.BEK_SORT_TYPE).equals((Object)this.mySortType);
        }

        public void setSelected(AnActionEvent e2, boolean state) {
            if (state && this.myProperties.exists(MainVcsLogUiProperties.BEK_SORT_TYPE)) {
                this.myProperties.set(MainVcsLogUiProperties.BEK_SORT_TYPE, this.mySortType);
            }
        }
    }
}

