/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.actions;

import com.intellij.icons.AllIcons;
import com.intellij.ide.actions.RefreshAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.vcs.log.VcsLogDataKeys;
import com.intellij.vcs.log.VcsLogUi;
import com.intellij.vcs.log.impl.VcsLogManager;
import com.intellij.vcs.log.impl.VcsLogUtil;
import com.intellij.vcs.log.ui.VcsLogInternalDataKeys;
import com.intellij.vcs.log.ui.VcsLogUiImpl;
import com.intellij.vcs.log.visible.VisiblePackRefresher;

public class RefreshLogAction
extends RefreshAction {
    private static final Logger LOG = Logger.getInstance(RefreshLogAction.class);

    public RefreshLogAction() {
        super("Refresh", "Check for new commits and refresh Log if necessary", AllIcons.Actions.Refresh);
    }

    @Override
    public void actionPerformed(AnActionEvent e2) {
        VisiblePackRefresher refresher;
        VcsLogUtil.triggerUsage(e2);
        VcsLogManager logManager = (VcsLogManager)e2.getRequiredData(VcsLogInternalDataKeys.LOG_MANAGER);
        VcsLogUi ui = (VcsLogUi)e2.getRequiredData(VcsLogDataKeys.VCS_LOG_UI);
        if (ui instanceof VcsLogUiImpl && !(refresher = ((VcsLogUiImpl)ui).getRefresher()).isValid()) {
            String message2 = "Trying to refresh invalid log tab.";
            if (!logManager.getDataManager().getProgress().isRunning()) {
                LOG.error(message2);
            } else {
                LOG.warn(message2);
            }
            refresher.setValid(true);
        }
        logManager.getDataManager().refreshSoftly(VcsLogUtil.getVisibleRoots(ui));
    }

    @Override
    public void update(AnActionEvent e2) {
        VcsLogManager logManager = (VcsLogManager)e2.getData(VcsLogInternalDataKeys.LOG_MANAGER);
        e2.getPresentation().setEnabledAndVisible(logManager != null && e2.getData(VcsLogDataKeys.VCS_LOG_UI) != null);
    }
}

