/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.actions.history;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.actions.CreatePatchFromChangesAction;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.impl.VcsLogUtil;
import com.intellij.vcs.log.ui.VcsLogInternalDataKeys;
import com.intellij.vcs.log.ui.history.FileHistoryUi;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CreatePatchFromHistoryAction
extends AnAction
implements DumbAware {
    public void update(@NotNull AnActionEvent e2) {
        if (e2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/vcs/log/ui/actions/history/CreatePatchFromHistoryAction", "update"));
        }
        Project project2 = e2.getProject();
        FileHistoryUi ui = (FileHistoryUi)e2.getData(VcsLogInternalDataKeys.FILE_HISTORY_UI);
        if (project2 == null || ui == null) {
            e2.getPresentation().setEnabledAndVisible(false);
            return;
        }
        e2.getPresentation().setVisible(true);
        List selectedCommits = ui.getVcsLog().getSelectedCommits();
        String commitMessage = (String)e2.getData(VcsDataKeys.PRESET_COMMIT_MESSAGE);
        e2.getPresentation().setEnabled(!selectedCommits.isEmpty() && commitMessage != null);
    }

    public void actionPerformed(@NotNull AnActionEvent e2) {
        if (e2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/vcs/log/ui/actions/history/CreatePatchFromHistoryAction", "actionPerformed"));
        }
        VcsLogUtil.triggerUsage(e2);
        Project project2 = (Project)e2.getRequiredData(CommonDataKeys.PROJECT);
        FileHistoryUi ui = (FileHistoryUi)e2.getRequiredData(VcsLogInternalDataKeys.FILE_HISTORY_UI);
        String commitMessage = (String)e2.getRequiredData(VcsDataKeys.PRESET_COMMIT_MESSAGE);
        ui.getVcsLog().requestSelectedDetails(detailsList -> {
            List<Change> changes = ui.collectChanges((List<VcsFullCommitDetails>)detailsList, false);
            CreatePatchFromChangesAction.createPatch(project2, commitMessage, changes);
        }, null);
    }
}

