/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.actions.history;

import com.google.common.primitives.Ints;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.data.LoadingDetails;
import com.intellij.vcs.log.impl.VcsLogUtil;
import com.intellij.vcs.log.ui.VcsLogInternalDataKeys;
import com.intellij.vcs.log.ui.history.FileHistoryUi;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FileHistorySingleCommitAction
extends AnAction
implements DumbAware {
    public void update(@NotNull AnActionEvent e2) {
        if (e2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/vcs/log/ui/actions/history/FileHistorySingleCommitAction", "update"));
        }
        Project project2 = e2.getProject();
        FileHistoryUi ui = (FileHistoryUi)e2.getData(VcsLogInternalDataKeys.FILE_HISTORY_UI);
        if (project2 == null || ui == null) {
            e2.getPresentation().setEnabledAndVisible(false);
            return;
        }
        e2.getPresentation().setVisible(true);
        List details = ui.getVcsLog().getSelectedDetails();
        if (details.isEmpty()) {
            e2.getPresentation().setEnabled(false);
            return;
        }
        VcsFullCommitDetails detail = (VcsFullCommitDetails)ContainerUtil.getFirstItem((List)details);
        if (detail instanceof LoadingDetails) {
            detail = null;
        }
        e2.getPresentation().setEnabled(details.size() == 1 && this.isEnabled(ui, detail, e2));
    }

    protected boolean isEnabled(@NotNull FileHistoryUi ui, @Nullable VcsFullCommitDetails detail, @NotNull AnActionEvent e2) {
        if (ui == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ui", "com/intellij/vcs/log/ui/actions/history/FileHistorySingleCommitAction", "isEnabled"));
        }
        if (e2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/vcs/log/ui/actions/history/FileHistorySingleCommitAction", "isEnabled"));
        }
        return true;
    }

    public void actionPerformed(@NotNull AnActionEvent e2) {
        if (e2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/vcs/log/ui/actions/history/FileHistorySingleCommitAction", "actionPerformed"));
        }
        VcsLogUtil.triggerUsage(e2);
        Project project2 = (Project)e2.getRequiredData(CommonDataKeys.PROJECT);
        FileHistoryUi ui = (FileHistoryUi)e2.getRequiredData(VcsLogInternalDataKeys.FILE_HISTORY_UI);
        List commits = ui.getVcsLog().getSelectedCommits();
        if (commits.size() != 1) {
            return;
        }
        CommitId commit = (CommitId)ObjectUtils.notNull((Object)ContainerUtil.getFirstItem((List)commits));
        List commitIndex = Ints.asList((int[])new int[]{ui.getLogData().getCommitIndex(commit.getHash(), commit.getRoot())});
        ui.getLogData().getCommitDetailsGetter().loadCommitsData(commitIndex, details -> {
            if (e2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/vcs/log/ui/actions/history/FileHistorySingleCommitAction", "lambda$actionPerformed$0"));
            }
            if (!details.isEmpty()) {
                this.performAction(project2, ui, (VcsFullCommitDetails)ObjectUtils.notNull((Object)ContainerUtil.getFirstItem((List)details)), e2);
            }
        }, (ProgressIndicator)null);
    }

    protected abstract void performAction(@NotNull Project var1, @NotNull FileHistoryUi var2, @NotNull VcsFullCommitDetails var3, @NotNull AnActionEvent var4);
}

