/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.filter;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupAdapter;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.vcs.log.VcsLogFilter;
import com.intellij.vcs.log.impl.MainVcsLogUiProperties;
import com.intellij.vcs.log.ui.filter.FilterModel;
import com.intellij.vcs.log.ui.filter.FilterPopupComponent;
import com.intellij.vcs.log.ui.filter.MultilinePopupBuilder;
import java.awt.Component;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class MultipleValueFilterPopupComponent<Filter extends VcsLogFilter>
extends FilterPopupComponent<Filter> {
    private static final int MAX_FILTER_VALUE_LENGTH = 30;
    @NotNull
    protected final MainVcsLogUiProperties myUiProperties;

    MultipleValueFilterPopupComponent(@NotNull String filterName, @NotNull MainVcsLogUiProperties uiProperties, @NotNull FilterModel<Filter> filterModel) {
        if (filterName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filterName", "com/intellij/vcs/log/ui/filter/MultipleValueFilterPopupComponent", "<init>"));
        }
        if (uiProperties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "uiProperties", "com/intellij/vcs/log/ui/filter/MultipleValueFilterPopupComponent", "<init>"));
        }
        if (filterModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filterModel", "com/intellij/vcs/log/ui/filter/MultipleValueFilterPopupComponent", "<init>"));
        }
        super(filterName, filterModel);
        this.myUiProperties = uiProperties;
    }

    @NotNull
    protected abstract List<List<String>> getRecentValuesFromSettings();

    protected abstract void rememberValuesInSettings(@NotNull Collection<String> var1);

    @NotNull
    protected abstract List<String> getAllValues();

    @NotNull
    protected ActionGroup createRecentItemsActionGroup() {
        DefaultActionGroup group = new DefaultActionGroup();
        List<List<String>> recentlyFiltered = this.getRecentValuesFromSettings();
        if (!recentlyFiltered.isEmpty()) {
            group.addSeparator("Recent");
            for (List<String> recentGroup : recentlyFiltered) {
                if (recentGroup.isEmpty()) continue;
                group.add((AnAction)new PredefinedValueAction(this, recentGroup));
            }
            group.addSeparator();
        }
        DefaultActionGroup defaultActionGroup = group;
        if (defaultActionGroup == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/filter/MultipleValueFilterPopupComponent", "createRecentItemsActionGroup"));
        }
        return defaultActionGroup;
    }

    @NotNull
    static String displayableText(@NotNull Collection<String> values) {
        if (values == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "values", "com/intellij/vcs/log/ui/filter/MultipleValueFilterPopupComponent", "displayableText"));
        }
        if (values.size() == 1) {
            String string2 = values.iterator().next();
            if (string2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/filter/MultipleValueFilterPopupComponent", "displayableText"));
            }
            return string2;
        }
        String string3 = StringUtil.shortenTextWithEllipsis((String)StringUtil.join(values, (String)"|"), (int)30, (int)0, (boolean)true);
        if (string3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/filter/MultipleValueFilterPopupComponent", "displayableText"));
        }
        return string3;
    }

    @NotNull
    static String tooltip(@NotNull Collection<String> values) {
        if (values == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "values", "com/intellij/vcs/log/ui/filter/MultipleValueFilterPopupComponent", "tooltip"));
        }
        String string2 = StringUtil.join(values, (String)", ");
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/filter/MultipleValueFilterPopupComponent", "tooltip"));
        }
        return string2;
    }

    @NotNull
    protected AnAction createSelectMultipleValuesAction() {
        SelectMultipleValuesAction selectMultipleValuesAction = new SelectMultipleValuesAction();
        if (selectMultipleValuesAction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/filter/MultipleValueFilterPopupComponent", "createSelectMultipleValuesAction"));
        }
        return selectMultipleValuesAction;
    }

    protected boolean supportsNegativeValues() {
        return false;
    }

    private class SelectMultipleValuesAction
    extends DumbAwareAction {
        @NotNull
        private final Collection<String> myVariants;

        SelectMultipleValuesAction() {
            super("Select...");
            this.myVariants = MultipleValueFilterPopupComponent.this.getAllValues();
        }

        public void actionPerformed(@NotNull AnActionEvent e2) {
            if (e2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/vcs/log/ui/filter/MultipleValueFilterPopupComponent$SelectMultipleValuesAction", "actionPerformed"));
            }
            Project project2 = e2.getProject();
            if (project2 == null) {
                return;
            }
            Object filter2 = MultipleValueFilterPopupComponent.this.myFilterModel.getFilter();
            List<String> values = filter2 == null ? Collections.emptyList() : MultipleValueFilterPopupComponent.this.myFilterModel.getFilterValues(filter2);
            final MultilinePopupBuilder popupBuilder = new MultilinePopupBuilder(project2, this.myVariants, this.getPopupText(values), MultipleValueFilterPopupComponent.this.supportsNegativeValues());
            JBPopup popup2 = popupBuilder.createPopup();
            popup2.addListener((JBPopupListener)new JBPopupAdapter(){

                public void onClosed(LightweightWindowEvent event) {
                    if (event.isOk()) {
                        List<String> selectedValues = popupBuilder.getSelectedValues();
                        if (selectedValues.isEmpty()) {
                            MultipleValueFilterPopupComponent.this.myFilterModel.setFilter(null);
                        } else {
                            MultipleValueFilterPopupComponent.this.myFilterModel.setFilter(MultipleValueFilterPopupComponent.this.myFilterModel.createFilter(selectedValues));
                            MultipleValueFilterPopupComponent.this.rememberValuesInSettings(selectedValues);
                        }
                    }
                }
            });
            popup2.showUnderneathOf((Component)MultipleValueFilterPopupComponent.this);
        }

        @NotNull
        private String getPopupText(@Nullable Collection<String> selectedValues) {
            String string2 = selectedValues == null || selectedValues.isEmpty() ? "" : StringUtil.join(selectedValues, (String)"\n");
            if (string2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/filter/MultipleValueFilterPopupComponent$SelectMultipleValuesAction", "getPopupText"));
            }
            return string2;
        }
    }

    protected class PredefinedValueAction
    extends DumbAwareAction {
        @NotNull
        protected final List<String> myValues;
        final /* synthetic */ MultipleValueFilterPopupComponent this$0;

        public PredefinedValueAction(@NotNull MultipleValueFilterPopupComponent this$0, String value2) {
            if (value2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/vcs/log/ui/filter/MultipleValueFilterPopupComponent$PredefinedValueAction", "<init>"));
            }
            this(this$0, Collections.singletonList(value2));
        }

        public PredefinedValueAction(@NotNull MultipleValueFilterPopupComponent this$0, List<String> values) {
            if (values == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "values", "com/intellij/vcs/log/ui/filter/MultipleValueFilterPopupComponent$PredefinedValueAction", "<init>"));
            }
            this.this$0 = this$0;
            super(null, MultipleValueFilterPopupComponent.tooltip(values), null);
            this.getTemplatePresentation().setText(MultipleValueFilterPopupComponent.displayableText(values), false);
            this.myValues = values;
        }

        public void actionPerformed(@NotNull AnActionEvent e2) {
            if (e2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/vcs/log/ui/filter/MultipleValueFilterPopupComponent$PredefinedValueAction", "actionPerformed"));
            }
            this.this$0.myFilterModel.setFilter(this.this$0.myFilterModel.createFilter(this.myValues));
            this.this$0.rememberValuesInSettings(this.myValues);
        }
    }
}

