/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.filter;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.SizedIcon;
import com.intellij.ui.popup.KeepingPopupOpenAction;
import com.intellij.util.NotNullFunction;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.ColorIcon;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBUI;
import com.intellij.vcs.log.VcsLogDataPack;
import com.intellij.vcs.log.VcsLogRootFilter;
import com.intellij.vcs.log.VcsLogStructureFilter;
import com.intellij.vcs.log.data.VcsLogStructureFilterImpl;
import com.intellij.vcs.log.impl.VcsLogFileFilter;
import com.intellij.vcs.log.impl.VcsLogRootFilterImpl;
import com.intellij.vcs.log.impl.VcsLogUtil;
import com.intellij.vcs.log.ui.VcsLogColorManager;
import com.intellij.vcs.log.ui.filter.FilterModel;
import com.intellij.vcs.log.ui.filter.FilterPopupComponent;
import com.intellij.vcs.log.ui.filter.VcsStructureChooser;
import com.intellij.vcs.log.ui.table.VcsLogGraphTable;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class StructureFilterPopupComponent
extends FilterPopupComponent<VcsLogFileFilter> {
    private static final int FILTER_LABEL_LENGTH = 30;
    private static final int CHECKBOX_ICON_SIZE = 15;
    public static final FileByNameComparator FILE_BY_NAME_COMPARATOR = new FileByNameComparator();
    public static final FilePathByPathComparator FILE_PATH_BY_PATH_COMPARATOR = new FilePathByPathComparator();
    @NotNull
    private final VcsLogColorManager myColorManager;
    @NotNull
    private final FixedSizeQueue<VcsLogStructureFilter> myHistory;

    public StructureFilterPopupComponent(@NotNull FilterModel<VcsLogFileFilter> filterModel, @NotNull VcsLogColorManager colorManager) {
        if (filterModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filterModel", "com/intellij/vcs/log/ui/filter/StructureFilterPopupComponent", "<init>"));
        }
        if (colorManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "colorManager", "com/intellij/vcs/log/ui/filter/StructureFilterPopupComponent", "<init>"));
        }
        super("Paths", filterModel);
        this.myHistory = new FixedSizeQueue(5);
        this.myColorManager = colorManager;
    }

    @Override
    @NotNull
    protected String getText(@NotNull VcsLogFileFilter filter2) {
        if (filter2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/vcs/log/ui/filter/StructureFilterPopupComponent", "getText"));
        }
        Collection<Object> roots = filter2.getRootFilter() == null ? this.getAllRoots() : filter2.getRootFilter().getRoots();
        Set<FilePath> files2 = filter2.getStructureFilter() == null ? Collections.emptySet() : filter2.getStructureFilter().getFiles();
        Set<VirtualFile> visibleRoots = VcsLogUtil.getAllVisibleRoots(this.getAllRoots(), filter2.getRootFilter(), filter2.getStructureFilter());
        if (files2.isEmpty()) {
            String string2 = StructureFilterPopupComponent.getTextFromRoots(roots, visibleRoots.size() == this.getAllRoots().size());
            if (string2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/filter/StructureFilterPopupComponent", "getText"));
            }
            return string2;
        }
        String string3 = StructureFilterPopupComponent.getTextFromFilePaths(files2, "folders", files2.isEmpty());
        if (string3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/filter/StructureFilterPopupComponent", "getText"));
        }
        return string3;
    }

    @NotNull
    private static String getTextFromRoots(@NotNull Collection<VirtualFile> files2, boolean full) {
        if (files2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/vcs/log/ui/filter/StructureFilterPopupComponent", "getTextFromRoots"));
        }
        String string2 = StructureFilterPopupComponent.getText(files2, "roots", FILE_BY_NAME_COMPARATOR, VirtualFile::getName, full);
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/filter/StructureFilterPopupComponent", "getTextFromRoots"));
        }
        return string2;
    }

    @NotNull
    private static String getTextFromFilePaths(@NotNull Collection<FilePath> files2, @NotNull String category, boolean full) {
        if (files2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/vcs/log/ui/filter/StructureFilterPopupComponent", "getTextFromFilePaths"));
        }
        if (category == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "category", "com/intellij/vcs/log/ui/filter/StructureFilterPopupComponent", "getTextFromFilePaths"));
        }
        String string2 = StructureFilterPopupComponent.getText(files2, category, FILE_PATH_BY_PATH_COMPARATOR, file2 -> StringUtil.shortenPathWithEllipsis((String)file2.getPresentableUrl(), (int)30), full);
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/filter/StructureFilterPopupComponent", "getTextFromFilePaths"));
        }
        return string2;
    }

    @NotNull
    private static <F> String getText(@NotNull Collection<F> files2, @NotNull String category, @NotNull Comparator<F> comparator2, @NotNull NotNullFunction<F, String> getText, boolean full) {
        if (files2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/vcs/log/ui/filter/StructureFilterPopupComponent", "getText"));
        }
        if (category == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "category", "com/intellij/vcs/log/ui/filter/StructureFilterPopupComponent", "getText"));
        }
        if (comparator2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comparator", "com/intellij/vcs/log/ui/filter/StructureFilterPopupComponent", "getText"));
        }
        if (getText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "getText", "com/intellij/vcs/log/ui/filter/StructureFilterPopupComponent", "getText"));
        }
        if (full) {
            if ("All" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/filter/StructureFilterPopupComponent", "getText"));
            }
            return "All";
        }
        if (files2.isEmpty()) {
            String string2 = "No " + category;
            if (string2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/filter/StructureFilterPopupComponent", "getText"));
            }
            return string2;
        }
        F firstFile = Collections.min(files2, comparator2);
        String firstFileName = (String)getText.fun(firstFile);
        if (files2.size() == 1) {
            String string3 = firstFileName;
            if (string3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/filter/StructureFilterPopupComponent", "getText"));
            }
            return string3;
        }
        String string4 = firstFileName + " + " + (files2.size() - 1);
        if (string4 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/filter/StructureFilterPopupComponent", "getText"));
        }
        return string4;
    }

    @Override
    @Nullable
    protected String getToolTip(@NotNull VcsLogFileFilter filter2) {
        if (filter2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/vcs/log/ui/filter/StructureFilterPopupComponent", "getToolTip"));
        }
        return this.getToolTip(filter2.getRootFilter() == null ? this.getAllRoots() : filter2.getRootFilter().getRoots(), filter2.getStructureFilter() == null ? Collections.emptySet() : filter2.getStructureFilter().getFiles());
    }

    @NotNull
    private String getToolTip(@NotNull Collection<VirtualFile> roots, @NotNull Collection<FilePath> files2) {
        if (roots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "com/intellij/vcs/log/ui/filter/StructureFilterPopupComponent", "getToolTip"));
        }
        if (files2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/vcs/log/ui/filter/StructureFilterPopupComponent", "getToolTip"));
        }
        String tooltip = "";
        if (roots.isEmpty()) {
            tooltip = tooltip + "No Roots Selected";
        } else if (roots.size() != this.getAllRoots().size()) {
            tooltip = tooltip + "Roots:\n" + StructureFilterPopupComponent.getTooltipTextForRoots(roots);
        }
        if (!files2.isEmpty()) {
            if (!tooltip.isEmpty()) {
                tooltip = tooltip + "\n";
            }
            tooltip = tooltip + "Folders:\n" + StructureFilterPopupComponent.getTooltipTextForFilePaths(files2);
        }
        String string2 = tooltip;
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/filter/StructureFilterPopupComponent", "getToolTip"));
        }
        return string2;
    }

    @NotNull
    private static String getTooltipTextForRoots(@NotNull Collection<VirtualFile> files2) {
        if (files2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/vcs/log/ui/filter/StructureFilterPopupComponent", "getTooltipTextForRoots"));
        }
        String string2 = StructureFilterPopupComponent.getTooltipTextForFiles(files2, FILE_BY_NAME_COMPARATOR, VirtualFile::getName);
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/filter/StructureFilterPopupComponent", "getTooltipTextForRoots"));
        }
        return string2;
    }

    @NotNull
    private static String getTooltipTextForFilePaths(@NotNull Collection<FilePath> files2) {
        if (files2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/vcs/log/ui/filter/StructureFilterPopupComponent", "getTooltipTextForFilePaths"));
        }
        String string2 = StructureFilterPopupComponent.getTooltipTextForFiles(files2, FILE_PATH_BY_PATH_COMPARATOR, FilePath::getPresentableUrl);
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/filter/StructureFilterPopupComponent", "getTooltipTextForFilePaths"));
        }
        return string2;
    }

    @NotNull
    private static <F> String getTooltipTextForFiles(@NotNull Collection<F> files2, @NotNull Comparator<F> comparator2, @NotNull NotNullFunction<F, String> getText) {
        if (files2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/vcs/log/ui/filter/StructureFilterPopupComponent", "getTooltipTextForFiles"));
        }
        if (comparator2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comparator", "com/intellij/vcs/log/ui/filter/StructureFilterPopupComponent", "getTooltipTextForFiles"));
        }
        if (getText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "getText", "com/intellij/vcs/log/ui/filter/StructureFilterPopupComponent", "getTooltipTextForFiles"));
        }
        List filesToDisplay = ContainerUtil.sorted(files2, comparator2);
        if (files2.size() > 10) {
            filesToDisplay = filesToDisplay.subList(0, 10);
        }
        String tooltip = StringUtil.join((Collection)filesToDisplay, getText, (String)"\n");
        if (files2.size() > 10) {
            tooltip = tooltip + "\n...";
        }
        String string2 = tooltip;
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/filter/StructureFilterPopupComponent", "getTooltipTextForFiles"));
        }
        return string2;
    }

    @Override
    protected ActionGroup createActionGroup() {
        Set<VirtualFile> roots = this.getAllRoots();
        ArrayList<SelectVisibleRootAction> rootActions = new ArrayList<SelectVisibleRootAction>();
        if (this.myColorManager.isMultipleRoots()) {
            for (VirtualFile root : ContainerUtil.sorted(roots, (Comparator)FILE_BY_NAME_COMPARATOR)) {
                rootActions.add(new SelectVisibleRootAction(root));
            }
        }
        ArrayList<SelectFromHistoryAction> structureActions = new ArrayList<SelectFromHistoryAction>();
        for (VcsLogStructureFilter filter2 : this.myHistory) {
            structureActions.add(new SelectFromHistoryAction(filter2));
        }
        if (roots.size() > 15) {
            return new DefaultActionGroup(new AnAction[]{this.createAllAction(), new SelectFoldersAction(), new Separator("Recent"), new DefaultActionGroup(structureActions), new Separator("Roots"), new DefaultActionGroup(rootActions)});
        }
        return new DefaultActionGroup(new AnAction[]{this.createAllAction(), new SelectFoldersAction(), new Separator("Roots"), new DefaultActionGroup(rootActions), new Separator("Recent"), new DefaultActionGroup(structureActions)});
    }

    private Set<VirtualFile> getAllRoots() {
        return this.myFilterModel.getDataPack().getLogProviders().keySet();
    }

    private boolean isVisible(@NotNull VirtualFile root) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/vcs/log/ui/filter/StructureFilterPopupComponent", "isVisible"));
        }
        VcsLogFileFilter filter2 = (VcsLogFileFilter)this.myFilterModel.getFilter();
        if (filter2 != null && filter2.getRootFilter() != null) {
            return filter2.getRootFilter().getRoots().contains(root);
        }
        return true;
    }

    private void setVisible(@NotNull VirtualFile root, boolean visible) {
        VcsLogRootFilter rootFilter;
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/vcs/log/ui/filter/StructureFilterPopupComponent", "setVisible"));
        }
        Set<VirtualFile> roots = this.getAllRoots();
        VcsLogFileFilter previousFilter = (VcsLogFileFilter)this.myFilterModel.getFilter();
        VcsLogRootFilter vcsLogRootFilter = rootFilter = previousFilter != null ? previousFilter.getRootFilter() : null;
        Collection<Object> visibleRoots = rootFilter == null ? (visible ? roots : ContainerUtil.subtract(roots, Collections.singleton(root))) : (visible ? ContainerUtil.union(new HashSet(rootFilter.getRoots()), Collections.singleton(root)) : ContainerUtil.subtract((Collection)rootFilter.getRoots(), Collections.singleton(root)));
        this.myFilterModel.setFilter(new VcsLogFileFilter(null, new VcsLogRootFilterImpl(visibleRoots)));
    }

    private void setVisibleOnly(@NotNull VirtualFile root) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/vcs/log/ui/filter/StructureFilterPopupComponent", "setVisibleOnly"));
        }
        this.myFilterModel.setFilter(new VcsLogFileFilter(null, new VcsLogRootFilterImpl(Collections.singleton(root))));
    }

    @NotNull
    private static String getStructureActionText(@NotNull VcsLogStructureFilter filter2) {
        if (filter2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/vcs/log/ui/filter/StructureFilterPopupComponent", "getStructureActionText"));
        }
        String string2 = StructureFilterPopupComponent.getTextFromFilePaths(filter2.getFiles(), "items", filter2.getFiles().isEmpty());
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/filter/StructureFilterPopupComponent", "getStructureActionText"));
        }
        return string2;
    }

    private static class FixedSizeQueue<T>
    implements Iterable<T> {
        @NotNull
        private final LinkedList<T> myQueue = new LinkedList();
        private final int maxSize;

        public FixedSizeQueue(int maxSize) {
            this.maxSize = maxSize;
        }

        @Override
        @NotNull
        public Iterator<T> iterator() {
            Iterator iterator2 = ContainerUtil.reverse(this.myQueue).iterator();
            if (iterator2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/filter/StructureFilterPopupComponent$FixedSizeQueue", "iterator"));
            }
            return iterator2;
        }

        public void add(T t2) {
            this.myQueue.add(t2);
            if (this.myQueue.size() > this.maxSize) {
                this.myQueue.poll();
            }
        }
    }

    private class SelectFromHistoryAction
    extends ToggleAction {
        @NotNull
        private final VcsLogStructureFilter myFilter;
        @NotNull
        private final Icon myIcon;
        @NotNull
        private final Icon myEmptyIcon;

        private SelectFromHistoryAction(VcsLogStructureFilter filter2) {
            if (filter2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/vcs/log/ui/filter/StructureFilterPopupComponent$SelectFromHistoryAction", "<init>"));
            }
            super(StructureFilterPopupComponent.getStructureActionText(filter2), StructureFilterPopupComponent.getTooltipTextForFilePaths(filter2.getFiles()).replace("\n", " "), null);
            this.myFilter = filter2;
            this.myIcon = JBUI.scale((JBUI.JBIcon)new SizedIcon(PlatformIcons.CHECK_ICON_SMALL, 15, 15));
            this.myEmptyIcon = JBUI.scale((JBUI.JBIcon)EmptyIcon.create((int)15));
        }

        public boolean isSelected(AnActionEvent e2) {
            return StructureFilterPopupComponent.this.myFilterModel.getFilter() != null && ((VcsLogFileFilter)StructureFilterPopupComponent.this.myFilterModel.getFilter()).getStructureFilter() == this.myFilter;
        }

        public void setSelected(AnActionEvent e2, boolean state) {
            StructureFilterPopupComponent.this.myFilterModel.setFilter(new VcsLogFileFilter(this.myFilter, null));
        }

        public void update(@NotNull AnActionEvent e2) {
            if (e2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/vcs/log/ui/filter/StructureFilterPopupComponent$SelectFromHistoryAction", "update"));
            }
            super.update(e2);
            Presentation presentation = e2.getPresentation();
            if (this.isSelected(e2)) {
                presentation.setIcon(this.myIcon);
            } else {
                presentation.setIcon(this.myEmptyIcon);
            }
        }
    }

    private class SelectFoldersAction
    extends DumbAwareAction {
        public static final String STRUCTURE_FILTER_TEXT = "Select Folders...";

        SelectFoldersAction() {
            super(STRUCTURE_FILTER_TEXT);
        }

        public void actionPerformed(@NotNull AnActionEvent e2) {
            if (e2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/vcs/log/ui/filter/StructureFilterPopupComponent$SelectFoldersAction", "actionPerformed"));
            }
            Project project2 = (Project)e2.getRequiredData(CommonDataKeys.PROJECT);
            VcsLogDataPack dataPack = StructureFilterPopupComponent.this.myFilterModel.getDataPack();
            VcsLogFileFilter filter2 = (VcsLogFileFilter)StructureFilterPopupComponent.this.myFilterModel.getFilter();
            Collection<Object> files2 = filter2 == null || filter2.getStructureFilter() == null ? Collections.emptySet() : ContainerUtil.mapNotNull((Collection)filter2.getStructureFilter().getFiles(), FilePath::getVirtualFile);
            VcsStructureChooser chooser = new VcsStructureChooser(project2, "Select Files or Folders to Filter by", files2, new ArrayList<VirtualFile>(dataPack.getLogProviders().keySet()));
            if (chooser.showAndGet()) {
                VcsLogStructureFilterImpl structureFilter = new VcsLogStructureFilterImpl((Set<VirtualFile>)new HashSet<VirtualFile>(chooser.getSelectedFiles()));
                StructureFilterPopupComponent.this.myFilterModel.setFilter(new VcsLogFileFilter(structureFilter, null));
                StructureFilterPopupComponent.this.myHistory.add(structureFilter);
            }
        }

        public void update(AnActionEvent e2) {
            e2.getPresentation().setEnabledAndVisible(e2.getProject() != null);
        }
    }

    private static class CheckboxColorIcon
    extends ColorIcon {
        private final int mySize;
        private boolean mySelected;
        private SizedIcon mySizedIcon;

        public CheckboxColorIcon(int size, @NotNull Color color) {
            if (color == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "color", "com/intellij/vcs/log/ui/filter/StructureFilterPopupComponent$CheckboxColorIcon", "<init>"));
            }
            super(size, color);
            this.mySelected = false;
            this.mySize = size;
            this.mySizedIcon = new SizedIcon(PlatformIcons.CHECK_ICON_SMALL, this.mySize, this.mySize);
        }

        public void prepare(boolean selected) {
            this.mySelected = selected;
        }

        public CheckboxColorIcon withJBUIPreScaled(boolean preScaled) {
            this.mySizedIcon = (SizedIcon)this.mySizedIcon.withJBUIPreScaled(preScaled);
            return (CheckboxColorIcon)super.withJBUIPreScaled(preScaled);
        }

        public void paintIcon(Component component, Graphics g2, int i2, int j2) {
            super.paintIcon(component, g2, i2, j2);
            if (this.mySelected) {
                this.mySizedIcon.paintIcon(component, g2, i2, j2);
            }
        }
    }

    private class SelectVisibleRootAction
    extends ToggleAction
    implements DumbAware,
    KeepingPopupOpenAction {
        @NotNull
        private final CheckboxColorIcon myIcon;
        @NotNull
        private final VirtualFile myRoot;

        private SelectVisibleRootAction(VirtualFile root) {
            if (root == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/vcs/log/ui/filter/StructureFilterPopupComponent$SelectVisibleRootAction", "<init>"));
            }
            super(root.getName(), root.getPresentableUrl(), null);
            this.myRoot = root;
            this.myIcon = (CheckboxColorIcon)JBUI.scale((JBUI.JBIcon)new CheckboxColorIcon(15, (Color)VcsLogGraphTable.getRootBackgroundColor(this.myRoot, StructureFilterPopupComponent.this.myColorManager)));
            this.getTemplatePresentation().setIcon((Icon)JBUI.scale((JBUI.JBIcon)EmptyIcon.create((int)15)));
        }

        public boolean isSelected(AnActionEvent e2) {
            return StructureFilterPopupComponent.this.isVisible(this.myRoot);
        }

        public void setSelected(AnActionEvent e2, boolean state) {
            if (!this.isEnabled()) {
                StructureFilterPopupComponent.this.setVisibleOnly(this.myRoot);
            } else if ((e2.getModifiers() & this.getMask()) != 0) {
                StructureFilterPopupComponent.this.setVisibleOnly(this.myRoot);
            } else {
                StructureFilterPopupComponent.this.setVisible(this.myRoot, state);
            }
        }

        @JdkConstants.InputEventMask
        private int getMask() {
            return SystemInfo.isMac ? 4 : 2;
        }

        public void update(@NotNull AnActionEvent e2) {
            if (e2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/vcs/log/ui/filter/StructureFilterPopupComponent$SelectVisibleRootAction", "update"));
            }
            super.update(e2);
            this.updateIcon();
            e2.getPresentation().setIcon((Icon)((Object)this.myIcon));
            e2.getPresentation().putClientProperty("ToolTipText", (Object)(KeyEvent.getKeyModifiersText(this.getMask()) + "+Click to see only \"" + e2.getPresentation().getText() + "\""));
        }

        private void updateIcon() {
            this.myIcon.prepare(StructureFilterPopupComponent.this.isVisible(this.myRoot) && this.isEnabled());
        }

        private boolean isEnabled() {
            return StructureFilterPopupComponent.this.myFilterModel.getFilter() == null || ((VcsLogFileFilter)StructureFilterPopupComponent.this.myFilterModel.getFilter()).getStructureFilter() == null;
        }
    }

    private static class FilePathByPathComparator
    implements Comparator<FilePath> {
        private FilePathByPathComparator() {
        }

        @Override
        public int compare(FilePath o1, FilePath o2) {
            return o1.getPresentableUrl().compareTo(o2.getPresentableUrl());
        }
    }

    private static class FileByNameComparator
    implements Comparator<VirtualFile> {
        private FileByNameComparator() {
        }

        @Override
        public int compare(VirtualFile o1, VirtualFile o2) {
            return o1.getName().compareTo(o2.getName());
        }
    }
}

