/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.history;

import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesTreeBrowser;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsFileRevisionEx;
import com.intellij.openapi.vcs.vfs.VcsFileSystem;
import com.intellij.openapi.vcs.vfs.VcsVirtualFile;
import com.intellij.openapi.vcs.vfs.VcsVirtualFolder;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.VcsLogFilterUi;
import com.intellij.vcs.log.data.LoadingDetails;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.data.index.IndexDataGetter;
import com.intellij.vcs.log.impl.CommonUiProperties;
import com.intellij.vcs.log.impl.VcsLogUiProperties;
import com.intellij.vcs.log.ui.AbstractVcsLogUi;
import com.intellij.vcs.log.ui.VcsLogColorManager;
import com.intellij.vcs.log.ui.highlighters.VcsLogHighlighterFactory;
import com.intellij.vcs.log.ui.history.FileHistoryFilterUi;
import com.intellij.vcs.log.ui.history.FileHistoryPanel;
import com.intellij.vcs.log.ui.history.FileHistoryUiProperties;
import com.intellij.vcs.log.ui.history.FileHistoryVisiblePack;
import com.intellij.vcs.log.ui.history.VcsLogFileRevision;
import com.intellij.vcs.log.ui.table.VcsLogGraphTable;
import com.intellij.vcs.log.visible.VisiblePackRefresher;
import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileHistoryUi
extends AbstractVcsLogUi {
    @NotNull
    private static final List<String> HIGHLIGHTERS = Arrays.asList("MY_COMMITS", "CURRENT_BRANCH");
    @NotNull
    private final FileHistoryUiProperties myUiProperties;
    @NotNull
    private final FileHistoryFilterUi myFilterUi;
    @NotNull
    private final FilePath myPath;
    @NotNull
    private final FileHistoryPanel myFileHistoryPanel;
    @NotNull
    private final IndexDataGetter myIndexDataGetter;
    @NotNull
    private final MyPropertiesChangeListener myPropertiesChangeListener;

    public FileHistoryUi(@NotNull VcsLogData logData, @NotNull Project project2, @NotNull VcsLogColorManager manager, @NotNull FileHistoryUiProperties uiProperties, @NotNull VisiblePackRefresher refresher, @NotNull FilePath path) {
        if (logData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logData", "com/intellij/vcs/log/ui/history/FileHistoryUi", "<init>"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/vcs/log/ui/history/FileHistoryUi", "<init>"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/vcs/log/ui/history/FileHistoryUi", "<init>"));
        }
        if (uiProperties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "uiProperties", "com/intellij/vcs/log/ui/history/FileHistoryUi", "<init>"));
        }
        if (refresher == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refresher", "com/intellij/vcs/log/ui/history/FileHistoryUi", "<init>"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/vcs/log/ui/history/FileHistoryUi", "<init>"));
        }
        super(logData, project2, manager, refresher);
        this.myUiProperties = uiProperties;
        this.myIndexDataGetter = (IndexDataGetter)ObjectUtils.assertNotNull((Object)logData.getIndex().getDataGetter());
        this.myFilterUi = new FileHistoryFilterUi(path, uiProperties);
        this.myPath = path;
        this.myFileHistoryPanel = new FileHistoryPanel(this, logData, this.myVisiblePack, path);
        this.updateFilter();
        for (VcsLogHighlighterFactory factory2 : ContainerUtil.filter((Object[])Extensions.getExtensions((ExtensionPointName)LOG_HIGHLIGHTER_FACTORY_EP, (AreaInstance)this.myProject), f2 -> HIGHLIGHTERS.contains(f2.getId()))) {
            this.getTable().addHighlighter(factory2.createHighlighter(logData, this));
        }
        this.myPropertiesChangeListener = new MyPropertiesChangeListener();
        this.myUiProperties.addChangeListener(this.myPropertiesChangeListener);
    }

    @Nullable
    public VirtualFile createVcsVirtualFile(@NotNull VcsFullCommitDetails details) {
        if (details == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "details", "com/intellij/vcs/log/ui/history/FileHistoryUi", "createVcsVirtualFile"));
        }
        VcsFileRevision revision = this.createRevision(details);
        return this.createVcsVirtualFile(revision);
    }

    @Nullable
    public VirtualFile createVcsVirtualFile(@Nullable VcsFileRevision revision) {
        if (revision != null && !VcsFileRevision.NULL.equals(revision) && revision instanceof VcsFileRevisionEx) {
            FilePath path = ((VcsFileRevisionEx)revision).getPath();
            return path.isDirectory() ? new VcsVirtualFolder(path.getPath(), null, (VirtualFileSystem)VcsFileSystem.getInstance()) : new VcsVirtualFile(path.getPath(), revision, (VirtualFileSystem)VcsFileSystem.getInstance());
        }
        return null;
    }

    @Nullable
    public VcsFileRevision createRevision(@Nullable VcsFullCommitDetails details) {
        if (details != null && !(details instanceof LoadingDetails)) {
            List<Change> changes = this.collectRelevantChanges(details);
            for (Change change : changes) {
                ContentRevision revision = change.getAfterRevision();
                if (revision == null) continue;
                return new VcsLogFileRevision(details, change.getAfterRevision(), revision.getFile());
            }
            if (!changes.isEmpty()) {
                return VcsFileRevision.NULL;
            }
        }
        return null;
    }

    @Nullable
    public FilePath getPath(@NotNull VcsFullCommitDetails details) {
        if (details == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "details", "com/intellij/vcs/log/ui/history/FileHistoryUi", "getPath"));
        }
        if (this.myPath.isDirectory()) {
            return this.myPath;
        }
        List<Change> changes = this.collectRelevantChanges(details);
        for (Change change : changes) {
            ContentRevision revision = change.getAfterRevision();
            if (revision == null) continue;
            return revision.getFile();
        }
        return null;
    }

    @NotNull
    public List<Change> collectRelevantChanges(@NotNull VcsFullCommitDetails details) {
        if (details == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "details", "com/intellij/vcs/log/ui/history/FileHistoryUi", "collectRelevantChanges"));
        }
        Set<FilePath> fileNames = this.getFileNames(details);
        if (this.myPath.isDirectory()) {
            List list2 = ContainerUtil.filter((Collection)details.getChanges(), change -> FileHistoryUi.affectsDirectories(change, fileNames));
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/history/FileHistoryUi", "collectRelevantChanges"));
            }
            return list2;
        }
        List list3 = ContainerUtil.filter((Collection)details.getChanges(), change -> FileHistoryUi.affectsFiles(change, fileNames));
        if (list3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/history/FileHistoryUi", "collectRelevantChanges"));
        }
        return list3;
    }

    @NotNull
    private Set<FilePath> getFileNames(@NotNull VcsFullCommitDetails details) {
        Set<FilePath> names;
        if (details == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "details", "com/intellij/vcs/log/ui/history/FileHistoryUi", "getFileNames"));
        }
        int commitIndex = this.myLogData.getStorage().getCommitIndex((Hash)details.getId(), details.getRoot());
        if (this.myVisiblePack instanceof FileHistoryVisiblePack) {
            IndexDataGetter.FileNamesData namesData = ((FileHistoryVisiblePack)this.myVisiblePack).getNamesData();
            names = namesData.getAffectedPaths(commitIndex);
        } else {
            names = this.myIndexDataGetter.getFileNames(this.myPath, commitIndex);
        }
        if (names.isEmpty()) {
            Set<FilePath> set2 = Collections.singleton(this.myPath);
            if (set2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/history/FileHistoryUi", "getFileNames"));
            }
            return set2;
        }
        Set<FilePath> set3 = names;
        if (set3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/history/FileHistoryUi", "getFileNames"));
        }
        return set3;
    }

    private static boolean affectsFiles(@NotNull Change change, @NotNull Set<FilePath> files2) {
        if (change == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "change", "com/intellij/vcs/log/ui/history/FileHistoryUi", "affectsFiles"));
        }
        if (files2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/vcs/log/ui/history/FileHistoryUi", "affectsFiles"));
        }
        ContentRevision revision = (ContentRevision)ObjectUtils.notNull((Object)ObjectUtils.chooseNotNull((Object)change.getAfterRevision(), (Object)change.getBeforeRevision()));
        return files2.contains(revision.getFile());
    }

    private static boolean affectsDirectories(@NotNull Change change, @NotNull Set<FilePath> directories) {
        if (change == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "change", "com/intellij/vcs/log/ui/history/FileHistoryUi", "affectsDirectories"));
        }
        if (directories == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directories", "com/intellij/vcs/log/ui/history/FileHistoryUi", "affectsDirectories"));
        }
        FilePath file2 = ((ContentRevision)ObjectUtils.notNull((Object)ObjectUtils.chooseNotNull((Object)change.getAfterRevision(), (Object)change.getBeforeRevision()))).getFile();
        return ContainerUtil.find(directories, dir -> VfsUtilCore.isAncestor((File)dir.getIOFile(), (File)file2.getIOFile(), (boolean)false)) != null;
    }

    @NotNull
    public List<Change> collectChanges(@NotNull List<VcsFullCommitDetails> detailsList, boolean onlyRelevant) {
        if (detailsList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "detailsList", "com/intellij/vcs/log/ui/history/FileHistoryUi", "collectChanges"));
        }
        ArrayList changes = ContainerUtil.newArrayList();
        List detailsListReversed = ContainerUtil.reverse(detailsList);
        for (VcsFullCommitDetails details : detailsListReversed) {
            changes.addAll(onlyRelevant ? this.collectRelevantChanges(details) : details.getChanges());
        }
        List<Change> list2 = CommittedChangesTreeBrowser.zipChanges(changes);
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/history/FileHistoryUi", "collectChanges"));
        }
        return list2;
    }

    @NotNull
    public FilePath getPath() {
        FilePath filePath = this.myPath;
        if (filePath == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/history/FileHistoryUi", "getPath"));
        }
        return filePath;
    }

    @NotNull
    public VcsLogFilterUi getFilterUi() {
        FileHistoryFilterUi fileHistoryFilterUi = this.myFilterUi;
        if (fileHistoryFilterUi == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/history/FileHistoryUi", "getFilterUi"));
        }
        return fileHistoryFilterUi;
    }

    @Override
    public boolean areGraphActionsEnabled() {
        return false;
    }

    public boolean isMultipleRoots() {
        return false;
    }

    @Override
    public boolean isShowRootNames() {
        return false;
    }

    public boolean isHighlighterEnabled(@NotNull String id) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/vcs/log/ui/history/FileHistoryUi", "isHighlighterEnabled"));
        }
        return HIGHLIGHTERS.contains(id);
    }

    @Override
    protected void onVisiblePackUpdated(boolean permGraphChanged) {
        this.myFileHistoryPanel.updateDataPack(this.myVisiblePack, permGraphChanged);
    }

    @Override
    @NotNull
    public VcsLogGraphTable getTable() {
        VcsLogGraphTable vcsLogGraphTable = this.myFileHistoryPanel.getGraphTable();
        if (vcsLogGraphTable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/history/FileHistoryUi", "getTable"));
        }
        return vcsLogGraphTable;
    }

    @Override
    @NotNull
    public Component getMainComponent() {
        FileHistoryPanel fileHistoryPanel = this.myFileHistoryPanel;
        if (fileHistoryPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/history/FileHistoryUi", "getMainComponent"));
        }
        return fileHistoryPanel;
    }

    @Override
    protected VcsLogFilterCollection getFilters() {
        return this.myFilterUi.getFilters();
    }

    private void updateFilter() {
        this.myRefresher.onFiltersChange(this.myFilterUi.getFilters());
    }

    @Override
    @NotNull
    public FileHistoryUiProperties getProperties() {
        FileHistoryUiProperties fileHistoryUiProperties = this.myUiProperties;
        if (fileHistoryUiProperties == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/history/FileHistoryUi", "getProperties"));
        }
        return fileHistoryUiProperties;
    }

    @Override
    public void dispose() {
        this.myUiProperties.removeChangeListener(this.myPropertiesChangeListener);
        super.dispose();
    }

    private class MyPropertiesChangeListener
    implements VcsLogUiProperties.PropertiesChangeListener {
        private MyPropertiesChangeListener() {
        }

        @Override
        public <T> void onPropertyChanged(@NotNull VcsLogUiProperties.VcsLogUiProperty<T> property) {
            if (property == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/intellij/vcs/log/ui/history/FileHistoryUi$MyPropertiesChangeListener", "onPropertyChanged"));
            }
            if (CommonUiProperties.SHOW_DETAILS.equals(property)) {
                FileHistoryUi.this.myFileHistoryPanel.showDetails(FileHistoryUi.this.myUiProperties.get(CommonUiProperties.SHOW_DETAILS));
            } else if (FileHistoryUiProperties.SHOW_ALL_BRANCHES.equals(property)) {
                FileHistoryUi.this.updateFilter();
            } else if (CommonUiProperties.COLUMN_ORDER.equals(property)) {
                FileHistoryUi.this.getTable().onColumnOrderSettingChanged();
            } else if (property instanceof CommonUiProperties.TableColumnProperty) {
                FileHistoryUi.this.getTable().forceReLayout(((CommonUiProperties.TableColumnProperty)property).getColumn());
            }
        }
    }
}

