/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.render;

import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Path2D;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class LabelIcon
implements Icon {
    private final int mySize;
    @NotNull
    private final Color[] myColors;
    @NotNull
    private final Color myBgColor;
    @NotNull
    private final BufferedImage myImage;

    public LabelIcon(int size, @NotNull Color bgColor, Color ... colors) {
        if (bgColor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bgColor", "com/intellij/vcs/log/ui/render/LabelIcon", "<init>"));
        }
        if (colors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "colors", "com/intellij/vcs/log/ui/render/LabelIcon", "<init>"));
        }
        this.mySize = size;
        this.myBgColor = bgColor;
        this.myColors = colors;
        this.myImage = UIUtil.createImage((int)this.getIconWidth(), (int)this.getIconHeight(), (int)2);
        this.paintIcon(this.myImage.createGraphics());
    }

    @Override
    public void paintIcon(Component c2, Graphics g2, int x2, int y2) {
        UIUtil.drawImage((Graphics)g2, (Image)this.myImage, (int)x2, (int)y2, null);
    }

    private void paintIcon(@NotNull Graphics2D g2) {
        if (g2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g2", "com/intellij/vcs/log/ui/render/LabelIcon", "paintIcon"));
        }
        GraphicsConfig config = GraphicsUtil.setupAAPainting((Graphics)g2);
        float scale = (float)this.mySize / 8.0f;
        for (int i2 = this.myColors.length - 1; i2 >= 0; --i2) {
            if (i2 != this.myColors.length - 1) {
                g2.setColor(this.myBgColor);
                this.paintTag(g2, scale, scale * 2.0f * (float)i2 + 1.0f, 0.0f);
            }
            g2.setColor(this.myColors[i2]);
            this.paintTag(g2, scale, scale * 2.0f * (float)i2, 0.0f);
        }
        config.restore();
    }

    public void paintTag(Graphics2D g2, float scale, float x2, float y2) {
        Path2D.Float path = new Path2D.Float();
        path.moveTo(x2 + 1.0f * scale, y2 + 2.0f * scale);
        path.lineTo(x2 + 3.0f * scale, y2 + 2.0f * scale);
        path.lineTo(x2 + 6.0f * scale, y2 + 5.0f * scale);
        path.lineTo(x2 + 4.0f * scale, y2 + 7.0f * scale);
        path.lineTo(x2 + 1.0f * scale, y2 + 4.0f * scale);
        path.lineTo(x2 + 1.0f * scale, y2 + 2.0f * scale);
        path.closePath();
        Ellipse2D.Float hole = new Ellipse2D.Float(x2 + 2.0f * scale, y2 + 3.0f * scale, scale, scale);
        Area area = new Area(path);
        area.subtract(new Area(hole));
        g2.fill(area);
    }

    @Override
    public int getIconWidth() {
        return this.getWidth(this.myColors.length);
    }

    protected int getWidth(int labelsCount) {
        return LabelIcon.getWidth(this.mySize, labelsCount);
    }

    public static int getWidth(int height, int labelsCount) {
        float scale = (float)height / 8.0f;
        return Math.round((float)(7 + 2 * (labelsCount - 1)) * scale);
    }

    @Override
    public int getIconHeight() {
        return this.mySize;
    }
}

