/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.render;

import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcs.log.RefGroup;
import com.intellij.vcs.log.VcsLogRefManager;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.ui.render.LabelIcon;
import com.intellij.vcs.log.ui.render.RectanglePainter;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.RoundRectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LabelPainter {
    public static final int TOP_TEXT_PADDING = JBUI.scale((int)1);
    public static final int BOTTOM_TEXT_PADDING = JBUI.scale((int)2);
    public static final int RIGHT_PADDING = JBUI.scale((int)4);
    public static final int LEFT_PADDING = JBUI.scale((int)2);
    public static final int COMPACT_MIDDLE_PADDING = JBUI.scale((int)2);
    public static final int MIDDLE_PADDING = JBUI.scale((int)12);
    private static final int MAX_LENGTH = 22;
    private static final String THREE_DOTS = "...";
    private static final String TWO_DOTS = "..";
    private static final String SEPARATOR = "/";
    private static final JBColor BACKGROUND = new JBColor(Color.BLACK, Color.WHITE);
    private static final float BALANCE = 0.08f;
    private static final JBColor TEXT_COLOR = new JBColor(new Color(0x7A7A7A), new Color(0x909090));
    @NotNull
    private final VcsLogData myLogData;
    @NotNull
    private List<Pair<String, LabelIcon>> myLabels;
    private int myHeight;
    private int myWidth;
    @NotNull
    private Color myBackground;
    @Nullable
    private Color myGreyBackground;
    @NotNull
    private Color myForeground;
    private boolean myCompact;
    private boolean myShowTagNames;

    public LabelPainter(@NotNull VcsLogData data, boolean compact, boolean showTagNames) {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/vcs/log/ui/render/LabelPainter", "<init>"));
        }
        this.myLabels = ContainerUtil.newArrayList();
        this.myHeight = JBUI.scale((int)22);
        this.myWidth = 0;
        this.myBackground = UIUtil.getTableBackground();
        this.myGreyBackground = null;
        this.myForeground = UIUtil.getTableForeground();
        this.myLogData = data;
        this.myCompact = compact;
        this.myShowTagNames = showTagNames;
    }

    @Nullable
    public static VcsLogRefManager getRefManager(@NotNull VcsLogData logData, @NotNull Collection<VcsRef> references) {
        if (logData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logData", "com/intellij/vcs/log/ui/render/LabelPainter", "getRefManager"));
        }
        if (references == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "references", "com/intellij/vcs/log/ui/render/LabelPainter", "getRefManager"));
        }
        if (!references.isEmpty()) {
            VirtualFile root = ((VcsRef)ObjectUtils.assertNotNull((Object)ContainerUtil.getFirstItem(references))).getRoot();
            return logData.getLogProvider(root).getReferenceManager();
        }
        return null;
    }

    public void customizePainter(@NotNull JComponent component, @NotNull Collection<VcsRef> references, @NotNull Color background, @NotNull Color foreground, boolean isSelected, int availableWidth) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/vcs/log/ui/render/LabelPainter", "customizePainter"));
        }
        if (references == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "references", "com/intellij/vcs/log/ui/render/LabelPainter", "customizePainter"));
        }
        if (background == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "background", "com/intellij/vcs/log/ui/render/LabelPainter", "customizePainter"));
        }
        if (foreground == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "foreground", "com/intellij/vcs/log/ui/render/LabelPainter", "customizePainter"));
        }
        this.myBackground = background;
        this.myForeground = isSelected ? foreground : TEXT_COLOR;
        FontMetrics metrics = component.getFontMetrics(this.getReferenceFont());
        this.myHeight = metrics.getHeight() + TOP_TEXT_PADDING + BOTTOM_TEXT_PADDING;
        VcsLogRefManager manager = LabelPainter.getRefManager(this.myLogData, references);
        List refGroups = manager == null ? ContainerUtil.emptyList() : manager.groupForTable(references, this.myCompact, this.myShowTagNames);
        this.myGreyBackground = LabelPainter.calculateGreyBackground(refGroups, background, isSelected, this.myCompact);
        Pair<List<Pair<String, LabelIcon>>, Integer> presentation = LabelPainter.calculatePresentation(refGroups, metrics, this.myHeight, this.myGreyBackground != null ? this.myGreyBackground : this.myBackground, availableWidth, this.myCompact);
        this.myLabels = (List)presentation.first;
        this.myWidth = (Integer)presentation.second;
    }

    @NotNull
    private static Pair<List<Pair<String, LabelIcon>>, Integer> calculatePresentation(@NotNull List<RefGroup> refGroups, @NotNull FontMetrics fontMetrics, int height, @NotNull Color background, int availableWidth, boolean compact) {
        if (refGroups == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refGroups", "com/intellij/vcs/log/ui/render/LabelPainter", "calculatePresentation"));
        }
        if (fontMetrics == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fontMetrics", "com/intellij/vcs/log/ui/render/LabelPainter", "calculatePresentation"));
        }
        if (background == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "background", "com/intellij/vcs/log/ui/render/LabelPainter", "calculatePresentation"));
        }
        int width = LEFT_PADDING + RIGHT_PADDING;
        ArrayList labels = ContainerUtil.newArrayList();
        if (refGroups.isEmpty()) {
            Pair pair = Pair.create((Object)labels, (Object)width);
            if (pair == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/render/LabelPainter", "calculatePresentation"));
            }
            return pair;
        }
        if (compact) {
            Pair<List<Pair<String, LabelIcon>>, Integer> pair = LabelPainter.calculateCompactPresentation(refGroups, fontMetrics, height, background, availableWidth);
            if (pair == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/render/LabelPainter", "calculatePresentation"));
            }
            return pair;
        }
        Pair<List<Pair<String, LabelIcon>>, Integer> pair = LabelPainter.calculateLongPresentation(refGroups, fontMetrics, height, background, availableWidth);
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/render/LabelPainter", "calculatePresentation"));
        }
        return pair;
    }

    @NotNull
    private static Pair<List<Pair<String, LabelIcon>>, Integer> calculateCompactPresentation(@NotNull List<RefGroup> refGroups, @NotNull FontMetrics fontMetrics, int height, @NotNull Color background, int availableWidth) {
        if (refGroups == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refGroups", "com/intellij/vcs/log/ui/render/LabelPainter", "calculateCompactPresentation"));
        }
        if (fontMetrics == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fontMetrics", "com/intellij/vcs/log/ui/render/LabelPainter", "calculateCompactPresentation"));
        }
        if (background == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "background", "com/intellij/vcs/log/ui/render/LabelPainter", "calculateCompactPresentation"));
        }
        int width = LEFT_PADDING + RIGHT_PADDING;
        ArrayList labels = ContainerUtil.newArrayList();
        if (refGroups.isEmpty()) {
            Pair pair = Pair.create((Object)labels, (Object)width);
            if (pair == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/render/LabelPainter", "calculateCompactPresentation"));
            }
            return pair;
        }
        for (RefGroup group : refGroups) {
            List colors = group.getColors();
            LabelIcon labelIcon = new LabelIcon(height, background, colors.toArray(new Color[colors.size()]));
            int newWidth = width + labelIcon.getIconWidth() + (group != ContainerUtil.getLastItem(refGroups) ? COMPACT_MIDDLE_PADDING : 0);
            String text2 = LabelPainter.shortenRefName(group.getName(), fontMetrics, availableWidth - newWidth);
            labels.add(Pair.create((Object)text2, (Object)labelIcon));
            width = newWidth += fontMetrics.stringWidth(text2);
        }
        Pair pair = Pair.create((Object)labels, (Object)width);
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/render/LabelPainter", "calculateCompactPresentation"));
        }
        return pair;
    }

    @NotNull
    private static Pair<List<Pair<String, LabelIcon>>, Integer> calculateLongPresentation(@NotNull List<RefGroup> refGroups, @NotNull FontMetrics fontMetrics, int height, @NotNull Color background, int availableWidth) {
        if (refGroups == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refGroups", "com/intellij/vcs/log/ui/render/LabelPainter", "calculateLongPresentation"));
        }
        if (fontMetrics == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fontMetrics", "com/intellij/vcs/log/ui/render/LabelPainter", "calculateLongPresentation"));
        }
        if (background == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "background", "com/intellij/vcs/log/ui/render/LabelPainter", "calculateLongPresentation"));
        }
        int width = LEFT_PADDING + RIGHT_PADDING;
        ArrayList labels = ContainerUtil.newArrayList();
        if (refGroups.isEmpty()) {
            Pair pair = Pair.create((Object)labels, (Object)width);
            if (pair == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/render/LabelPainter", "calculateLongPresentation"));
            }
            return pair;
        }
        for (int i2 = 0; i2 < refGroups.size(); ++i2) {
            String text2;
            RefGroup group = refGroups.get(i2);
            int doNotFitWidth = 0;
            if (i2 < refGroups.size() - 1) {
                LabelIcon lastIcon = new LabelIcon(height, background, LabelPainter.getColors(refGroups.subList(i2 + 1, refGroups.size())));
                doNotFitWidth = lastIcon.getIconWidth();
            }
            List colors = group.getColors();
            LabelIcon labelIcon = new LabelIcon(height, background, colors.toArray(new Color[colors.size()]));
            int newWidth = width + labelIcon.getIconWidth() + (i2 != refGroups.size() - 1 ? MIDDLE_PADDING : 0);
            if (availableWidth - (newWidth += fontMetrics.stringWidth(text2 = LabelPainter.getGroupText(group, fontMetrics, availableWidth - newWidth - doNotFitWidth))) - doNotFitWidth < 0) {
                LabelIcon lastIcon = new LabelIcon(height, background, LabelPainter.getColors(refGroups.subList(i2, refGroups.size())));
                String name = labels.isEmpty() ? text2 : "";
                labels.add(Pair.create((Object)name, (Object)lastIcon));
                width += fontMetrics.stringWidth(name) + lastIcon.getIconWidth();
                break;
            }
            labels.add(Pair.create((Object)text2, (Object)labelIcon));
            width = newWidth;
        }
        Pair pair = Pair.create((Object)labels, (Object)width);
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/render/LabelPainter", "calculateLongPresentation"));
        }
        return pair;
    }

    @NotNull
    private static Color[] getColors(@NotNull Collection<RefGroup> groups2) {
        if (groups2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groups", "com/intellij/vcs/log/ui/render/LabelPainter", "getColors"));
        }
        LinkedHashMap usedColors = ContainerUtil.newLinkedHashMap();
        for (RefGroup group : groups2) {
            List colors = group.getColors();
            for (Color color : colors) {
                Integer count = (Integer)usedColors.get(color);
                if (count == null) {
                    count = 0;
                }
                usedColors.put(color, count + 1);
            }
        }
        ArrayList result2 = ContainerUtil.newArrayList();
        for (Map.Entry entry : usedColors.entrySet()) {
            result2.add(entry.getKey());
            if ((Integer)entry.getValue() <= 1) continue;
            result2.add(entry.getKey());
        }
        Color[] colorArray = result2.toArray(new Color[result2.size()]);
        if (colorArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/render/LabelPainter", "getColors"));
        }
        return colorArray;
    }

    @NotNull
    private static String getGroupText(@NotNull RefGroup group, @NotNull FontMetrics fontMetrics, int availableWidth) {
        if (group == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "group", "com/intellij/vcs/log/ui/render/LabelPainter", "getGroupText"));
        }
        if (fontMetrics == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fontMetrics", "com/intellij/vcs/log/ui/render/LabelPainter", "getGroupText"));
        }
        if (!group.isExpanded()) {
            String string2 = LabelPainter.shortenRefName(group.getName(), fontMetrics, availableWidth);
            if (string2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/render/LabelPainter", "getGroupText"));
            }
            return string2;
        }
        String text2 = "";
        String remainder = ", ...";
        String separator = ", ";
        int remainderWidth = fontMetrics.stringWidth(remainder);
        int separatorWidth = fontMetrics.stringWidth(separator);
        for (int i2 = 0; i2 < group.getRefs().size(); ++i2) {
            String refName;
            int refNameWidth;
            boolean firstRef;
            boolean lastRef = i2 == group.getRefs().size() - 1;
            int width = availableWidth - (lastRef ? 0 : remainderWidth) - ((firstRef = i2 == 0) ? 0 : separatorWidth);
            if (width - (refNameWidth = fontMetrics.stringWidth(refName = LabelPainter.shortenRefName(((VcsRef)group.getRefs().get(i2)).getName(), fontMetrics, width))) < 0 && !firstRef) {
                text2 = text2 + remainder;
                break;
            }
            text2 = text2 + (firstRef ? "" : separator) + refName;
            availableWidth -= (firstRef ? 0 : separatorWidth) + refNameWidth;
        }
        String string3 = text2;
        if (string3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/render/LabelPainter", "getGroupText"));
        }
        return string3;
    }

    @Nullable
    private static Color calculateGreyBackground(@NotNull List<RefGroup> refGroups, @NotNull Color background, boolean isSelected, boolean isCompact) {
        if (refGroups == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refGroups", "com/intellij/vcs/log/ui/render/LabelPainter", "calculateGreyBackground"));
        }
        if (background == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "background", "com/intellij/vcs/log/ui/render/LabelPainter", "calculateGreyBackground"));
        }
        if (isSelected) {
            return null;
        }
        if (!isCompact) {
            return ColorUtil.mix((Color)background, (Color)BACKGROUND, (double)0.08f);
        }
        for (RefGroup group : refGroups) {
            boolean paintGreyBackground;
            if (group.isExpanded()) {
                paintGreyBackground = ContainerUtil.find((Iterable)group.getRefs(), ref -> !ref.getName().isEmpty()) != null;
            } else {
                boolean bl = paintGreyBackground = !group.getName().isEmpty();
            }
            if (!paintGreyBackground) continue;
            return ColorUtil.mix((Color)background, (Color)BACKGROUND, (double)0.08f);
        }
        return null;
    }

    @NotNull
    private static String shortenRefName(@NotNull String refName, @NotNull FontMetrics fontMetrics, int availableWidth) {
        if (refName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refName", "com/intellij/vcs/log/ui/render/LabelPainter", "shortenRefName"));
        }
        if (fontMetrics == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fontMetrics", "com/intellij/vcs/log/ui/render/LabelPainter", "shortenRefName"));
        }
        if (fontMetrics.stringWidth(refName) > availableWidth && refName.length() > 22) {
            int separatorIndex = refName.indexOf(SEPARATOR);
            if (separatorIndex > TWO_DOTS.length()) {
                refName = TWO_DOTS + refName.substring(separatorIndex);
            }
            if (fontMetrics.stringWidth(refName) <= availableWidth) {
                String string2 = refName;
                if (string2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/render/LabelPainter", "shortenRefName"));
                }
                return string2;
            }
            if (availableWidth > 0) {
                for (int i2 = refName.length(); i2 > 22; --i2) {
                    String result2 = StringUtil.shortenTextWithEllipsis((String)refName, (int)i2, (int)0, (String)THREE_DOTS);
                    if (fontMetrics.stringWidth(result2) > availableWidth) continue;
                    String string3 = result2;
                    if (string3 == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/render/LabelPainter", "shortenRefName"));
                    }
                    return string3;
                }
            }
            String string4 = StringUtil.shortenTextWithEllipsis((String)refName, (int)22, (int)0, (String)THREE_DOTS);
            if (string4 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/render/LabelPainter", "shortenRefName"));
            }
            return string4;
        }
        String string5 = refName;
        if (string5 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/render/LabelPainter", "shortenRefName"));
        }
        return string5;
    }

    public void paint(@NotNull Graphics2D g2, int x2, int y2, int height) {
        if (g2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g2", "com/intellij/vcs/log/ui/render/LabelPainter", "paint"));
        }
        if (this.myLabels.isEmpty()) {
            return;
        }
        GraphicsConfig config = GraphicsUtil.setupAAPainting((Graphics)g2);
        g2.setFont(this.getReferenceFont());
        g2.setStroke(new BasicStroke(1.5f));
        FontMetrics fontMetrics = g2.getFontMetrics();
        int baseLine = SimpleColoredComponent.getTextBaseLine((FontMetrics)fontMetrics, (int)height);
        g2.setColor(this.myBackground);
        g2.fillRect(x2, y2, this.myWidth, height);
        if (this.myGreyBackground != null && this.myCompact) {
            g2.setColor(this.myGreyBackground);
            g2.fillRect(x2, y2 + baseLine - fontMetrics.getAscent() - TOP_TEXT_PADDING, this.myWidth, fontMetrics.getHeight() + TOP_TEXT_PADDING + BOTTOM_TEXT_PADDING);
        }
        x2 += LEFT_PADDING;
        for (Pair<String, LabelIcon> label : this.myLabels) {
            LabelIcon icon = (LabelIcon)label.second;
            String text2 = (String)label.first;
            if (this.myGreyBackground != null && !this.myCompact) {
                g2.setColor(this.myGreyBackground);
                g2.fill(new RoundRectangle2D.Double(x2 - LEFT_PADDING, y2 + baseLine - fontMetrics.getAscent() - TOP_TEXT_PADDING, icon.getIconWidth() + fontMetrics.stringWidth(text2) + 3 * LEFT_PADDING, fontMetrics.getHeight() + TOP_TEXT_PADDING + BOTTOM_TEXT_PADDING, RectanglePainter.LABEL_ARC, RectanglePainter.LABEL_ARC));
            }
            icon.paintIcon(null, g2, x2, y2 + (height - icon.getIconHeight()) / 2);
            g2.setColor(this.myForeground);
            g2.drawString(text2, x2 += icon.getIconWidth(), y2 + baseLine);
            x2 += fontMetrics.stringWidth(text2) + (this.myCompact ? COMPACT_MIDDLE_PADDING : MIDDLE_PADDING);
        }
        config.restore();
    }

    public Dimension getSize() {
        if (this.myLabels.isEmpty()) {
            return new Dimension();
        }
        return new Dimension(this.myWidth, this.myHeight);
    }

    public boolean isLeftAligned() {
        return Registry.is((String)"vcs.log.labels.left.aligned");
    }

    public Font getReferenceFont() {
        Font font = RectanglePainter.getFont();
        return font.deriveFont((float)font.getSize() - 1.0f);
    }

    public boolean isCompact() {
        return this.myCompact;
    }

    public void setShowTagNames(boolean showTagNames) {
        this.myShowTagNames = showTagNames;
    }

    public void setCompact(boolean compact) {
        this.myCompact = compact;
    }
}

