/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.table;

import com.google.common.primitives.Ints;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.ui.table.VcsLogGraphTable;
import java.util.List;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CommitSelectionListener
implements ListSelectionListener {
    private static final Logger LOG = Logger.getInstance(CommitSelectionListener.class);
    @NotNull
    private final VcsLogData myLogData;
    @NotNull
    protected final VcsLogGraphTable myGraphTable;
    @Nullable
    private ListSelectionEvent myLastEvent;
    @Nullable
    private ProgressIndicator myLastRequest;

    protected CommitSelectionListener(@NotNull VcsLogData data, @NotNull VcsLogGraphTable table2) {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/vcs/log/ui/table/CommitSelectionListener", "<init>"));
        }
        if (table2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/vcs/log/ui/table/CommitSelectionListener", "<init>"));
        }
        this.myLogData = data;
        this.myGraphTable = table2;
    }

    @Override
    public void valueChanged(@Nullable ListSelectionEvent event) {
        if (event != null && event.getValueIsAdjusting()) {
            return;
        }
        this.myLastEvent = event;
        if (this.myLastRequest != null) {
            this.myLastRequest.cancel();
        }
        this.myLastRequest = null;
        ApplicationManager.getApplication().invokeLater(this::processEvent, o2 -> this.myLastEvent != event);
    }

    public void processEvent() {
        int rows = this.myGraphTable.getSelectedRowCount();
        if (rows < 1) {
            this.stopLoading();
            this.onEmptySelection();
        } else {
            this.onSelection(this.myGraphTable.getSelectedRows());
            this.startLoading();
            EmptyProgressIndicator indicator = new EmptyProgressIndicator();
            this.myLastRequest = indicator;
            List<Integer> selectionToLoad = this.getSelectionToLoad();
            this.myLogData.getCommitDetailsGetter().loadCommitsData((List)this.myGraphTable.getModel().convertToCommitIds(selectionToLoad), detailsList -> {
                if (this.myLastRequest == indicator && !indicator.isCanceled()) {
                    LOG.assertTrue(selectionToLoad.size() == detailsList.size(), (Object)("Loaded incorrect number of details " + detailsList + " for selection " + selectionToLoad));
                    this.myLastRequest = null;
                    this.onDetailsLoaded((List<VcsFullCommitDetails>)detailsList);
                    this.stopLoading();
                }
            }, (ProgressIndicator)indicator);
        }
    }

    @NotNull
    protected List<Integer> getSelectionToLoad() {
        List list2 = Ints.asList((int[])this.myGraphTable.getSelectedRows());
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/table/CommitSelectionListener", "getSelectionToLoad"));
        }
        return list2;
    }

    protected abstract void startLoading();

    protected abstract void stopLoading();

    protected abstract void onDetailsLoaded(@NotNull List<VcsFullCommitDetails> var1);

    protected abstract void onSelection(@NotNull int[] var1);

    protected abstract void onEmptySelection();
}

