/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.table;

import com.intellij.ide.IdeTooltip;
import com.intellij.ide.IdeTooltipManager;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.changes.issueLinks.TableLinkMouseListener;
import com.intellij.ui.HintHint;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.util.ui.JBUI;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.VcsShortCommitDetails;
import com.intellij.vcs.log.data.LoadingDetails;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.graph.EdgePrintElement;
import com.intellij.vcs.log.graph.NodePrintElement;
import com.intellij.vcs.log.graph.PrintElement;
import com.intellij.vcs.log.graph.actions.GraphAction;
import com.intellij.vcs.log.graph.actions.GraphAnswer;
import com.intellij.vcs.log.impl.MainVcsLogUiProperties;
import com.intellij.vcs.log.impl.VcsLogUiProperties;
import com.intellij.vcs.log.impl.VcsLogUtil;
import com.intellij.vcs.log.paint.GraphCellPainter;
import com.intellij.vcs.log.paint.PositionUtil;
import com.intellij.vcs.log.ui.AbstractVcsLogUi;
import com.intellij.vcs.log.ui.frame.CommitPanel;
import com.intellij.vcs.log.ui.render.GraphCommitCellRenderer;
import com.intellij.vcs.log.ui.render.SimpleColoredComponentLinkMouseListener;
import com.intellij.vcs.log.ui.table.VcsLogGraphTable;
import com.intellij.vcs.log.util.VcsUserUtil;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.Collections;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.table.TableColumn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GraphTableController {
    @NotNull
    private final VcsLogGraphTable myTable;
    @NotNull
    private final AbstractVcsLogUi myUi;
    @NotNull
    private final VcsLogData myLogData;
    @NotNull
    private final GraphCellPainter myGraphCellPainter;
    @NotNull
    private final GraphCommitCellRenderer myCommitRenderer;

    public GraphTableController(@NotNull VcsLogGraphTable table2, @NotNull AbstractVcsLogUi ui, @NotNull VcsLogData logData, @NotNull GraphCellPainter graphCellPainter, @NotNull GraphCommitCellRenderer commitRenderer) {
        if (table2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/vcs/log/ui/table/GraphTableController", "<init>"));
        }
        if (ui == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ui", "com/intellij/vcs/log/ui/table/GraphTableController", "<init>"));
        }
        if (logData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logData", "com/intellij/vcs/log/ui/table/GraphTableController", "<init>"));
        }
        if (graphCellPainter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "graphCellPainter", "com/intellij/vcs/log/ui/table/GraphTableController", "<init>"));
        }
        if (commitRenderer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commitRenderer", "com/intellij/vcs/log/ui/table/GraphTableController", "<init>"));
        }
        this.myTable = table2;
        this.myUi = ui;
        this.myLogData = logData;
        this.myGraphCellPainter = graphCellPainter;
        this.myCommitRenderer = commitRenderer;
        MyMouseAdapter mouseAdapter = new MyMouseAdapter();
        table2.addMouseMotionListener(mouseAdapter);
        table2.addMouseListener(mouseAdapter);
    }

    @Nullable
    PrintElement findPrintElement(@NotNull MouseEvent e2) {
        if (e2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/vcs/log/ui/table/GraphTableController", "findPrintElement"));
        }
        int row = this.myTable.rowAtPoint(e2.getPoint());
        if (row >= 0 && row < this.myTable.getRowCount()) {
            return this.findPrintElement(row, e2);
        }
        return null;
    }

    @Nullable
    private PrintElement findPrintElement(int row, @NotNull MouseEvent e2) {
        if (e2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/vcs/log/ui/table/GraphTableController", "findPrintElement"));
        }
        Point point = this.calcPoint4Graph(e2.getPoint());
        Collection printElements = this.myTable.getVisibleGraph().getRowInfo(row).getPrintElements();
        return this.myGraphCellPainter.getElementUnderCursor(printElements, point.x, point.y);
    }

    private void performGraphAction(@Nullable PrintElement printElement, @NotNull MouseEvent e2, @NotNull GraphAction.Type actionType) {
        boolean isClickOnGraphElement;
        if (e2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/vcs/log/ui/table/GraphTableController", "performGraphAction"));
        }
        if (actionType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionType", "com/intellij/vcs/log/ui/table/GraphTableController", "performGraphAction"));
        }
        boolean bl = isClickOnGraphElement = actionType == GraphAction.Type.MOUSE_CLICK && printElement != null;
        if (isClickOnGraphElement) {
            GraphTableController.triggerElementClick(printElement);
        }
        VcsLogGraphTable.Selection previousSelection = this.myTable.getSelection();
        GraphAnswer answer = this.myTable.getVisibleGraph().getActionController().performAction((GraphAction)new GraphAction.GraphActionImpl(printElement, actionType));
        this.handleGraphAnswer((GraphAnswer<Integer>)answer, isClickOnGraphElement, previousSelection, e2);
    }

    public void handleGraphAnswer(@Nullable GraphAnswer<Integer> answer, boolean dataCouldChange, @Nullable VcsLogGraphTable.Selection previousSelection, @Nullable MouseEvent e2) {
        if (dataCouldChange) {
            this.myTable.getModel().fireTableDataChanged();
            if (previousSelection != null) {
                previousSelection.restore(this.myTable.getVisibleGraph(), answer == null || answer.getCommitToJump() != null && answer.doJump(), false);
            }
        }
        this.myTable.repaint();
        if (answer == null) {
            return;
        }
        if (answer.getCursorToSet() != null) {
            this.myTable.setCursor(answer.getCursorToSet());
        }
        if (answer.getCommitToJump() != null) {
            Integer row = this.myTable.getModel().getVisiblePack().getVisibleGraph().getVisibleRowIndex(answer.getCommitToJump());
            if (row != null && row >= 0 && answer.doJump()) {
                this.myTable.jumpToRow(row);
                return;
            }
            if (e2 != null) {
                this.showToolTip(this.getArrowTooltipText((Integer)answer.getCommitToJump(), row), e2);
            }
        }
    }

    @NotNull
    private Point calcPoint4Graph(@NotNull Point clickPoint) {
        TableColumn column;
        if (clickPoint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clickPoint", "com/intellij/vcs/log/ui/table/GraphTableController", "calcPoint4Graph"));
        }
        int width = 0;
        for (int i2 = 0; i2 < this.myTable.getColumnModel().getColumnCount() && (column = this.myTable.getColumnModel().getColumn(i2)).getModelIndex() != 1; ++i2) {
            width += column.getWidth();
        }
        Point point = new Point(clickPoint.x - width, PositionUtil.getYInsideRow(clickPoint, this.myTable.getRowHeight()));
        if (point == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/table/GraphTableController", "calcPoint4Graph"));
        }
        return point;
    }

    @NotNull
    private String getArrowTooltipText(int commit, @Nullable Integer row) {
        VcsShortCommitDetails details = row != null && row >= 0 ? this.myTable.getModel().getShortDetails(row) : this.myLogData.getMiniDetailsGetter().getCommitData((Integer)commit, Collections.singleton(commit));
        String balloonText = "";
        if (details instanceof LoadingDetails) {
            CommitId commitId = this.myLogData.getCommitId(commit);
            if (commitId != null) {
                balloonText = "Jump to commit " + commitId.getHash().toShortString();
                if (this.myUi.isMultipleRoots()) {
                    balloonText = balloonText + " in " + commitId.getRoot().getName();
                }
            }
        } else {
            balloonText = "Jump to <b>\"" + StringUtil.shortenTextWithEllipsis((String)details.getSubject(), (int)50, (int)0, (String)"...") + "\"</b> by " + VcsUserUtil.getShortPresentation(details.getAuthor()) + CommitPanel.formatDateTime(details.getAuthorTime());
        }
        String string2 = balloonText;
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/table/GraphTableController", "getArrowTooltipText"));
        }
        return string2;
    }

    private void showToolTip(@NotNull String text2, @NotNull MouseEvent e2) {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/vcs/log/ui/table/GraphTableController", "showToolTip"));
        }
        if (e2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/vcs/log/ui/table/GraphTableController", "showToolTip"));
        }
        Point point = new Point(e2.getX() + 5, e2.getY());
        JEditorPane tipComponent = IdeTooltipManager.initPane(text2, new HintHint((Component)((Object)this.myTable), point).setAwtTooltip(true), null);
        IdeTooltip tooltip = new IdeTooltip((Component)((Object)this.myTable), point, (JComponent)new Wrapper((JComponent)tipComponent), new Object[0]).setPreferredPosition(Balloon.Position.atRight);
        IdeTooltipManager.getInstance().show(tooltip, false);
    }

    private void showOrHideCommitTooltip(int row, int column, @NotNull MouseEvent e2) {
        if (e2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/vcs/log/ui/table/GraphTableController", "showOrHideCommitTooltip"));
        }
        if (!this.showTooltip(row, column, e2.getPoint(), false) && IdeTooltipManager.getInstance().hasCurrent()) {
            IdeTooltipManager.getInstance().hideCurrent(e2);
        }
    }

    private boolean showTooltip(int row, int column, @NotNull Point point, boolean now) {
        if (point == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "point", "com/intellij/vcs/log/ui/table/GraphTableController", "showTooltip"));
        }
        JComponent tipComponent = this.myCommitRenderer.getTooltip(this.myTable.getValueAt(row, this.myTable.convertColumnIndexToView(column)), this.calcPoint4Graph(point), row);
        if (tipComponent != null) {
            this.myTable.getExpandableItemsHandler().setEnabled(false);
            IdeTooltip tooltip = new IdeTooltip((Component)((Object)this.myTable), point, (JComponent)new Wrapper(tipComponent), new Object[0]).setPreferredPosition(Balloon.Position.below);
            IdeTooltipManager.getInstance().show(tooltip, now);
            return true;
        }
        return false;
    }

    public void showTooltip(int row) {
        Point point = new Point(this.getColumnLeftXCoordinate(this.myTable.convertColumnIndexToView(1)) + this.myCommitRenderer.getTooltipXCoordinate(row), row * this.myTable.getRowHeight() + this.myTable.getRowHeight() / 2);
        this.showTooltip(row, 1, point, true);
    }

    private void performRootColumnAction() {
        VcsLogUiProperties properties = this.myUi.getProperties();
        if (this.myUi.isMultipleRoots() && properties.exists(MainVcsLogUiProperties.SHOW_ROOT_NAMES)) {
            VcsLogUtil.triggerUsage("RootColumnClick");
            properties.set(MainVcsLogUiProperties.SHOW_ROOT_NAMES, properties.get(MainVcsLogUiProperties.SHOW_ROOT_NAMES) == false);
        }
    }

    private static void triggerElementClick(@NotNull PrintElement printElement) {
        if (printElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "printElement", "com/intellij/vcs/log/ui/table/GraphTableController", "triggerElementClick"));
        }
        if (printElement instanceof NodePrintElement) {
            VcsLogUtil.triggerUsage("GraphNodeClick");
        } else if (printElement instanceof EdgePrintElement && ((EdgePrintElement)printElement).hasArrow()) {
            VcsLogUtil.triggerUsage("GraphArrowClick");
        }
    }

    protected int getColumnLeftXCoordinate(int viewColumnIndex) {
        int x2 = 0;
        for (int i2 = 0; i2 < viewColumnIndex; ++i2) {
            x2 += this.myTable.getColumnModel().getColumn(i2).getWidth();
        }
        return x2;
    }

    private class MyMouseAdapter
    extends MouseAdapter {
        private static final int BORDER_THICKNESS = 3;
        @NotNull
        private final TableLinkMouseListener myLinkListener = new SimpleColoredComponentLinkMouseListener();

        private MyMouseAdapter() {
        }

        @Override
        public void mouseClicked(MouseEvent e2) {
            int row;
            if (this.myLinkListener.onClick(e2, e2.getClickCount())) {
                return;
            }
            int c2 = GraphTableController.this.myTable.columnAtPoint(e2.getPoint());
            int column = GraphTableController.this.myTable.convertColumnIndexToModel(c2);
            if (e2.getClickCount() == 2) {
                boolean useLeftBorder;
                int commitColumnIndex = GraphTableController.this.myTable.convertColumnIndexToView(1);
                boolean bl = useLeftBorder = c2 > commitColumnIndex;
                if ((useLeftBorder ? this.isOnLeftBorder(e2, c2) : this.isOnRightBorder(e2, c2)) && (column == 2 || column == 3)) {
                    GraphTableController.this.myTable.resetColumnWidth(column);
                } else {
                    int c22 = GraphTableController.this.myTable.columnAtPoint(new Point(e2.getPoint().x + (useLeftBorder ? 1 : -1) * JBUI.scale((int)3), e2.getPoint().y));
                    int column2 = GraphTableController.this.myTable.convertColumnIndexToModel(c22);
                    if ((useLeftBorder ? this.isOnLeftBorder(e2, c22) : this.isOnRightBorder(e2, c22)) && (column2 == 2 || column2 == 3)) {
                        GraphTableController.this.myTable.resetColumnWidth(column2);
                    }
                }
            }
            if ((row = GraphTableController.this.myTable.rowAtPoint(e2.getPoint())) >= 0 && row < GraphTableController.this.myTable.getRowCount() && e2.getClickCount() == 1) {
                PrintElement printElement;
                if (column == 0) {
                    GraphTableController.this.performRootColumnAction();
                } else if (column == 1 && (printElement = GraphTableController.this.findPrintElement(row, e2)) != null) {
                    GraphTableController.this.performGraphAction(printElement, e2, GraphAction.Type.MOUSE_CLICK);
                }
            }
        }

        public boolean isOnLeftBorder(@NotNull MouseEvent e2, int column) {
            if (e2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/vcs/log/ui/table/GraphTableController$MyMouseAdapter", "isOnLeftBorder"));
            }
            return Math.abs(GraphTableController.this.getColumnLeftXCoordinate(column) - e2.getPoint().x) <= JBUI.scale((int)3);
        }

        public boolean isOnRightBorder(@NotNull MouseEvent e2, int column) {
            if (e2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/vcs/log/ui/table/GraphTableController$MyMouseAdapter", "isOnRightBorder"));
            }
            return Math.abs(GraphTableController.this.getColumnLeftXCoordinate(column) + GraphTableController.this.myTable.getColumnModel().getColumn(column).getWidth() - e2.getPoint().x) <= JBUI.scale((int)3);
        }

        @Override
        public void mouseMoved(MouseEvent e2) {
            if (GraphTableController.this.myTable.isResizingColumns()) {
                return;
            }
            GraphTableController.this.myTable.getExpandableItemsHandler().setEnabled(true);
            if (this.myLinkListener.getTagAt(e2) != null) {
                GraphTableController.this.myTable.setCursor(Cursor.getPredefinedCursor(12));
                return;
            }
            int row = GraphTableController.this.myTable.rowAtPoint(e2.getPoint());
            if (row >= 0 && row < GraphTableController.this.myTable.getRowCount()) {
                int column = GraphTableController.this.myTable.convertColumnIndexToModel(GraphTableController.this.myTable.columnAtPoint(e2.getPoint()));
                if (column == 0) {
                    GraphTableController.this.myTable.setCursor(Cursor.getPredefinedCursor(12));
                    return;
                }
                if (column == 1) {
                    PrintElement printElement = GraphTableController.this.findPrintElement(row, e2);
                    GraphTableController.this.performGraphAction(printElement, e2, GraphAction.Type.MOUSE_OVER);
                    if (printElement == null) {
                        GraphTableController.this.showOrHideCommitTooltip(row, column, e2);
                    }
                    return;
                }
            }
            GraphTableController.this.myTable.setCursor(Cursor.getPredefinedCursor(0));
        }

        @Override
        public void mouseEntered(MouseEvent e2) {
        }

        @Override
        public void mouseExited(MouseEvent e2) {
            GraphTableController.this.myTable.getExpandableItemsHandler().setEnabled(true);
        }
    }
}

