/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.table;

import com.intellij.ui.table.JBTable;
import com.intellij.util.ui.AsyncProcessIcon;
import icons.VcsLogIcons;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;

public class TableWithProgress
extends JBTable {
    public TableWithProgress(@NotNull TableModel model2) {
        if (model2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/vcs/log/ui/table/TableWithProgress", "<init>"));
        }
        super(model2);
    }

    @NotNull
    protected AsyncProcessIcon createBusyIcon() {
        LastRowLoadingIcon lastRowLoadingIcon = new LastRowLoadingIcon();
        if (lastRowLoadingIcon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/table/TableWithProgress", "createBusyIcon"));
        }
        return lastRowLoadingIcon;
    }

    public Dimension getPreferredSize() {
        Dimension size = super.getPreferredSize();
        if (this.isBusy()) {
            return new Dimension(size.width, size.height + this.myBusyIcon.getPreferredSize().height);
        }
        return size;
    }

    protected boolean isBusy() {
        return this.myBusyIcon != null && this.myBusyIcon.isRunning();
    }

    protected void paintComponent(@NotNull Graphics g2) {
        if (g2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/vcs/log/ui/table/TableWithProgress", "paintComponent"));
        }
        super.paintComponent(g2);
        if (this.isBusy()) {
            int preferredHeight = super.getPreferredSize().height;
            this.paintFooter(g2, 0, preferredHeight, this.getWidth(), this.getHeight() - preferredHeight);
        }
    }

    protected void paintFooter(@NotNull Graphics g2, int x2, int y2, int width, int height) {
        if (g2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/vcs/log/ui/table/TableWithProgress", "paintFooter"));
        }
        g2.setColor(this.getBackground());
        g2.fillRect(x2, y2, width, height);
    }

    private class LastRowLoadingIcon
    extends AsyncProcessIcon {
        public LastRowLoadingIcon() {
            super(TableWithProgress.this.toString(), new Icon[]{VcsLogIcons.Process.Dots_2, VcsLogIcons.Process.Dots_3, VcsLogIcons.Process.Dots_4, VcsLogIcons.Process.Dots_5}, VcsLogIcons.Process.Dots_1);
            this.setUseMask(false);
        }

        @NotNull
        protected Rectangle calculateBounds(@NotNull JComponent container) {
            if (container == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "container", "com/intellij/vcs/log/ui/table/TableWithProgress$LastRowLoadingIcon", "calculateBounds"));
            }
            Dimension iconSize = this.getPreferredSize();
            Rectangle rectangle = new Rectangle((container.getWidth() - iconSize.width) / 2, container.getPreferredSize().height - iconSize.height, iconSize.width, iconSize.height);
            if (rectangle == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/table/TableWithProgress$LastRowLoadingIcon", "calculateBounds"));
            }
            return rectangle;
        }
    }
}

