/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.util;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.Consumer;
import com.intellij.util.ThrowableConsumer;
import com.intellij.util.concurrency.QueueProcessor;
import org.jetbrains.annotations.NotNull;

public class SequentialLimitedLifoExecutor<Task>
implements Disposable {
    private final int myMaxTasks;
    @NotNull
    private final ThrowableConsumer<Task, ? extends Throwable> myLoadProcess;
    @NotNull
    private final QueueProcessor<Task> myLoader;

    public SequentialLimitedLifoExecutor(Disposable parentDisposable, int maxTasks, @NotNull ThrowableConsumer<Task, ? extends Throwable> loadProcess) {
        if (loadProcess == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "loadProcess", "com/intellij/vcs/log/util/SequentialLimitedLifoExecutor", "<init>"));
        }
        this.myMaxTasks = maxTasks;
        this.myLoadProcess = loadProcess;
        this.myLoader = new QueueProcessor((Consumer)new DetailsLoadingTask());
        Disposer.register((Disposable)parentDisposable, (Disposable)this);
    }

    public void queue(Task task2) {
        this.myLoader.addFirst(task2);
    }

    public void clear() {
        this.myLoader.clear();
    }

    public void dispose() {
        this.clear();
    }

    private class DetailsLoadingTask
    implements Consumer<Task> {
        private DetailsLoadingTask() {
        }

        public void consume(Task task2) {
            try {
                SequentialLimitedLifoExecutor.this.myLoader.dismissLastTasks(SequentialLimitedLifoExecutor.this.myMaxTasks);
                SequentialLimitedLifoExecutor.this.myLoadProcess.consume(task2);
            }
            catch (Throwable e2) {
                throw new RuntimeException(e2);
            }
        }
    }
}

