/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.util;

import com.intellij.openapi.util.Couple;
import com.intellij.vcs.log.VcsUser;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsUserUtil {
    @NotNull
    private static final Pattern NAME_PATTERN = Pattern.compile("(\\w+)[\\W_](\\w+)");
    @NotNull
    private static final Pattern PRINTABLE_ASCII_PATTERN = Pattern.compile("[ -~]*");

    @NotNull
    public static String toExactString(@NotNull VcsUser user) {
        if (user == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "user", "com/intellij/vcs/log/util/VcsUserUtil", "toExactString"));
        }
        String string2 = VcsUserUtil.getString(user.getName(), user.getEmail());
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/util/VcsUserUtil", "toExactString"));
        }
        return string2;
    }

    @NotNull
    private static String getString(@NotNull String name, @NotNull String email) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/vcs/log/util/VcsUserUtil", "getString"));
        }
        if (email == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "email", "com/intellij/vcs/log/util/VcsUserUtil", "getString"));
        }
        if (name.isEmpty()) {
            String string2 = email;
            if (string2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/util/VcsUserUtil", "getString"));
            }
            return string2;
        }
        if (email.isEmpty()) {
            String string3 = name;
            if (string3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/util/VcsUserUtil", "getString"));
            }
            return string3;
        }
        String string4 = name + " <" + email + ">";
        if (string4 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/util/VcsUserUtil", "getString"));
        }
        return string4;
    }

    public static boolean isSamePerson(@NotNull VcsUser user1, @NotNull VcsUser user2) {
        if (user1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "user1", "com/intellij/vcs/log/util/VcsUserUtil", "isSamePerson"));
        }
        if (user2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "user2", "com/intellij/vcs/log/util/VcsUserUtil", "isSamePerson"));
        }
        return VcsUserUtil.getNameInStandardForm(VcsUserUtil.getName(user1)).equals(VcsUserUtil.getNameInStandardForm(VcsUserUtil.getName(user2)));
    }

    @NotNull
    public static String getShortPresentation(@NotNull VcsUser user) {
        if (user == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "user", "com/intellij/vcs/log/util/VcsUserUtil", "getShortPresentation"));
        }
        String string2 = VcsUserUtil.getName(user);
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/util/VcsUserUtil", "getShortPresentation"));
        }
        return string2;
    }

    @NotNull
    private static String getName(@NotNull VcsUser user) {
        if (user == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "user", "com/intellij/vcs/log/util/VcsUserUtil", "getName"));
        }
        String string2 = VcsUserUtil.getUserName(user.getName(), user.getEmail());
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/util/VcsUserUtil", "getName"));
        }
        return string2;
    }

    @NotNull
    public static String getUserName(@NotNull String name, @NotNull String email) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/vcs/log/util/VcsUserUtil", "getUserName"));
        }
        if (email == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "email", "com/intellij/vcs/log/util/VcsUserUtil", "getUserName"));
        }
        if (!name.isEmpty()) {
            String string2 = name;
            if (string2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/util/VcsUserUtil", "getUserName"));
            }
            return string2;
        }
        String emailNamePart = VcsUserUtil.getNameFromEmail(email);
        if (emailNamePart != null) {
            String string3 = emailNamePart;
            if (string3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/util/VcsUserUtil", "getUserName"));
            }
            return string3;
        }
        String string4 = email;
        if (string4 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/util/VcsUserUtil", "getUserName"));
        }
        return string4;
    }

    @Nullable
    public static String getNameFromEmail(@NotNull String email) {
        if (email == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "email", "com/intellij/vcs/log/util/VcsUserUtil", "getNameFromEmail"));
        }
        int at = email.indexOf(64);
        String emailNamePart = null;
        if (at > 0) {
            emailNamePart = email.substring(0, at);
        }
        return emailNamePart;
    }

    @NotNull
    public static String getNameInStandardForm(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/vcs/log/util/VcsUserUtil", "getNameInStandardForm"));
        }
        Couple<String> firstAndLastName = VcsUserUtil.getFirstAndLastName(name);
        if (firstAndLastName != null) {
            String string2 = ((String)firstAndLastName.first).toLowerCase(Locale.ENGLISH) + " " + ((String)firstAndLastName.second).toLowerCase(Locale.ENGLISH);
            if (string2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/util/VcsUserUtil", "getNameInStandardForm"));
            }
            return string2;
        }
        String string3 = VcsUserUtil.nameToLowerCase(name);
        if (string3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/util/VcsUserUtil", "getNameInStandardForm"));
        }
        return string3;
    }

    @Nullable
    public static Couple<String> getFirstAndLastName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/vcs/log/util/VcsUserUtil", "getFirstAndLastName"));
        }
        Matcher matcher = NAME_PATTERN.matcher(name);
        if (matcher.matches()) {
            return Couple.of((Object)matcher.group(1), (Object)matcher.group(2));
        }
        return null;
    }

    @NotNull
    public static String nameToLowerCase(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/vcs/log/util/VcsUserUtil", "nameToLowerCase"));
        }
        if (!PRINTABLE_ASCII_PATTERN.matcher(name).matches()) {
            String string2 = name;
            if (string2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/util/VcsUserUtil", "nameToLowerCase"));
            }
            return string2;
        }
        String string3 = name.toLowerCase(Locale.ENGLISH);
        if (string3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/util/VcsUserUtil", "nameToLowerCase"));
        }
        return string3;
    }

    @NotNull
    public static String capitalizeName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/vcs/log/util/VcsUserUtil", "capitalizeName"));
        }
        if (name.isEmpty()) {
            String string2 = name;
            if (string2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/util/VcsUserUtil", "capitalizeName"));
            }
            return string2;
        }
        if (!PRINTABLE_ASCII_PATTERN.matcher(name).matches()) {
            String string3 = name;
            if (string3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/util/VcsUserUtil", "capitalizeName"));
            }
            return string3;
        }
        String string4 = name.substring(0, 1).toUpperCase(Locale.ENGLISH) + name.substring(1);
        if (string4 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/util/VcsUserUtil", "capitalizeName"));
        }
        return string4;
    }

    @NotNull
    public static String emailToLowerCase(@NotNull String email) {
        if (email == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "email", "com/intellij/vcs/log/util/VcsUserUtil", "emailToLowerCase"));
        }
        String string2 = email.toLowerCase(Locale.ENGLISH);
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/util/VcsUserUtil", "emailToLowerCase"));
        }
        return string2;
    }
}

