/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.visible;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.data.CompressedRefs;
import com.intellij.vcs.log.data.DataPack;
import com.intellij.vcs.log.data.DataPackBase;
import com.intellij.vcs.log.data.RefsModel;
import com.intellij.vcs.log.data.VcsLogStorage;
import com.intellij.vcs.log.data.VcsLogStorageImpl;
import com.intellij.vcs.log.graph.GraphColorManagerImpl;
import com.intellij.vcs.log.graph.VisibleGraph;
import com.intellij.vcs.log.graph.collapsing.CollapsedController;
import com.intellij.vcs.log.graph.impl.facade.BaseController;
import com.intellij.vcs.log.graph.impl.facade.SimpleGraphInfo;
import com.intellij.vcs.log.graph.impl.facade.VisibleGraphImpl;
import com.intellij.vcs.log.impl.VcsLogUtil;
import com.intellij.vcs.log.visible.EmptyVisibleGraph;
import com.intellij.vcs.log.visible.VisiblePack;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class SnapshotVisiblePackBuilder {
    @NotNull
    private final VcsLogStorage myStorage;

    public SnapshotVisiblePackBuilder(@NotNull VcsLogStorage storage2) {
        if (storage2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "storage", "com/intellij/vcs/log/visible/SnapshotVisiblePackBuilder", "<init>"));
        }
        this.myStorage = storage2;
    }

    @NotNull
    public VisiblePack build(@NotNull VisiblePack visiblePack) {
        if (visiblePack == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visiblePack", "com/intellij/vcs/log/visible/SnapshotVisiblePackBuilder", "build"));
        }
        if (visiblePack.getVisibleGraph() instanceof VisibleGraphImpl && visiblePack.getVisibleGraph().getVisibleCommitCount() > 0) {
            VisiblePack visiblePack2 = this.build(visiblePack.getDataPack(), (VisibleGraphImpl)visiblePack.getVisibleGraph(), visiblePack.getFilters());
            if (visiblePack2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/visible/SnapshotVisiblePackBuilder", "build"));
            }
            return visiblePack2;
        }
        VisibleGraph<Integer> newGraph = EmptyVisibleGraph.getInstance();
        DataPackBase newPack = new DataPackBase(visiblePack.getDataPack().getLogProviders(), this.createEmptyRefsModel(), false);
        VisiblePack visiblePack3 = new VisiblePack(newPack, newGraph, true, visiblePack.getFilters());
        if (visiblePack3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/visible/SnapshotVisiblePackBuilder", "build"));
        }
        return visiblePack3;
    }

    @NotNull
    private VisiblePack build(@NotNull DataPackBase oldPack, @NotNull VisibleGraphImpl<Integer> oldGraph, @NotNull VcsLogFilterCollection filters2) {
        if (oldPack == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldPack", "com/intellij/vcs/log/visible/SnapshotVisiblePackBuilder", "build"));
        }
        if (oldGraph == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldGraph", "com/intellij/vcs/log/visible/SnapshotVisiblePackBuilder", "build"));
        }
        if (filters2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filters", "com/intellij/vcs/log/visible/SnapshotVisiblePackBuilder", "build"));
        }
        SimpleGraphInfo<Integer> info = oldGraph.buildSimpleGraphInfo();
        Set heads = ContainerUtil.map2Set(info.getPermanentGraphLayout().getHeadNodeIndex(), integer -> (Integer)info.getPermanentCommitsInfo().getCommitId((int)integer));
        RefsModel newRefsModel = this.createRefsModel(oldPack.getRefsModel(), heads, oldGraph, oldPack.getLogProviders());
        DataPackBase newPack = new DataPackBase(oldPack.getLogProviders(), newRefsModel, false);
        GraphColorManagerImpl colorManager = new GraphColorManagerImpl(newRefsModel, VcsLogStorageImpl.createHashGetter(this.myStorage), DataPack.getRefManagerMap(oldPack.getLogProviders()));
        VisibleGraphImpl<Integer> newGraph = new VisibleGraphImpl<Integer>(new CollapsedController(new BaseController(info), info, null), info, colorManager);
        VisiblePack visiblePack = new VisiblePack(newPack, newGraph, true, filters2);
        if (visiblePack == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/visible/SnapshotVisiblePackBuilder", "build"));
        }
        return visiblePack;
    }

    @NotNull
    private RefsModel createEmptyRefsModel() {
        RefsModel refsModel = new RefsModel(ContainerUtil.newHashMap(), ContainerUtil.newHashSet(), this.myStorage, ContainerUtil.newHashMap());
        if (refsModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/visible/SnapshotVisiblePackBuilder", "createEmptyRefsModel"));
        }
        return refsModel;
    }

    private RefsModel createRefsModel(@NotNull RefsModel refsModel, @NotNull Set<Integer> heads, @NotNull VisibleGraph<Integer> visibleGraph, @NotNull Map<VirtualFile, VcsLogProvider> providers) {
        if (refsModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refsModel", "com/intellij/vcs/log/visible/SnapshotVisiblePackBuilder", "createRefsModel"));
        }
        if (heads == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "heads", "com/intellij/vcs/log/visible/SnapshotVisiblePackBuilder", "createRefsModel"));
        }
        if (visibleGraph == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visibleGraph", "com/intellij/vcs/log/visible/SnapshotVisiblePackBuilder", "createRefsModel"));
        }
        if (providers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "providers", "com/intellij/vcs/log/visible/SnapshotVisiblePackBuilder", "createRefsModel"));
        }
        HashSet branchesAndHeads = ContainerUtil.newHashSet();
        refsModel.getBranches().stream().filter(ref -> {
            if (visibleGraph == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visibleGraph", "com/intellij/vcs/log/visible/SnapshotVisiblePackBuilder", "lambda$createRefsModel$1"));
            }
            int index = this.myStorage.getCommitIndex(ref.getCommitHash(), ref.getRoot());
            Integer row = visibleGraph.getVisibleRowIndex((Object)index);
            return row != null && row >= 0;
        }).forEach(branchesAndHeads::add);
        heads.stream().flatMap(head -> {
            if (refsModel == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refsModel", "com/intellij/vcs/log/visible/SnapshotVisiblePackBuilder", "lambda$createRefsModel$2"));
            }
            return refsModel.refsToCommit((int)head).stream();
        }).forEach(branchesAndHeads::add);
        Map<VirtualFile, Set<VcsRef>> map2 = VcsLogUtil.groupRefsByRoot(branchesAndHeads);
        HashMap refs = ContainerUtil.newHashMap();
        Iterator<VirtualFile> iterator2 = providers.keySet().iterator();
        while (iterator2.hasNext()) {
            VirtualFile root;
            Set<VcsRef> refsForRoot = map2.get(root = iterator2.next());
            refs.put(root, new CompressedRefs((Set<VcsRef>)(refsForRoot == null ? ContainerUtil.newHashSet() : refsForRoot), this.myStorage));
        }
        return new RefsModel(refs, heads, this.myStorage, providers);
    }
}

