/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.visible;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.log.VcsLogDataPack;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.VcsLogRefs;
import com.intellij.vcs.log.data.DataPack;
import com.intellij.vcs.log.data.DataPackBase;
import com.intellij.vcs.log.data.RefsModel;
import com.intellij.vcs.log.graph.VisibleGraph;
import com.intellij.vcs.log.impl.VcsLogFilterCollectionImpl;
import com.intellij.vcs.log.visible.EmptyVisibleGraph;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class VisiblePack
implements VcsLogDataPack {
    @NotNull
    public static final VisiblePack EMPTY = new VisiblePack(DataPack.EMPTY, EmptyVisibleGraph.getInstance(), false, VcsLogFilterCollectionImpl.EMPTY);
    @NotNull
    private final DataPackBase myDataPack;
    @NotNull
    private final VisibleGraph<Integer> myVisibleGraph;
    private final boolean myCanRequestMore;
    @NotNull
    private final VcsLogFilterCollection myFilters;

    public VisiblePack(@NotNull DataPackBase dataPack, @NotNull VisibleGraph<Integer> graph, boolean canRequestMore, @NotNull VcsLogFilterCollection filters2) {
        if (dataPack == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataPack", "com/intellij/vcs/log/visible/VisiblePack", "<init>"));
        }
        if (graph == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "graph", "com/intellij/vcs/log/visible/VisiblePack", "<init>"));
        }
        if (filters2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filters", "com/intellij/vcs/log/visible/VisiblePack", "<init>"));
        }
        this.myDataPack = dataPack;
        this.myVisibleGraph = graph;
        this.myCanRequestMore = canRequestMore;
        this.myFilters = filters2;
    }

    @NotNull
    public VisibleGraph<Integer> getVisibleGraph() {
        VisibleGraph<Integer> visibleGraph = this.myVisibleGraph;
        if (visibleGraph == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/visible/VisiblePack", "getVisibleGraph"));
        }
        return visibleGraph;
    }

    @NotNull
    public DataPackBase getDataPack() {
        DataPackBase dataPackBase = this.myDataPack;
        if (dataPackBase == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/visible/VisiblePack", "getDataPack"));
        }
        return dataPackBase;
    }

    public boolean canRequestMore() {
        return this.myCanRequestMore;
    }

    @NotNull
    public Map<VirtualFile, VcsLogProvider> getLogProviders() {
        Map<VirtualFile, VcsLogProvider> map2 = this.myDataPack.getLogProviders();
        if (map2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/visible/VisiblePack", "getLogProviders"));
        }
        return map2;
    }

    @NotNull
    public VcsLogRefs getRefs() {
        RefsModel refsModel = this.myDataPack.getRefsModel();
        if (refsModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/visible/VisiblePack", "getRefs"));
        }
        return refsModel;
    }

    public boolean isFull() {
        return this.myDataPack.isFull();
    }

    @NotNull
    public VcsLogFilterCollection getFilters() {
        VcsLogFilterCollection vcsLogFilterCollection = this.myFilters;
        if (vcsLogFilterCollection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/visible/VisiblePack", "getFilters"));
        }
        return vcsLogFilterCollection;
    }

    public VirtualFile getRoot(int row) {
        int head = (Integer)this.myVisibleGraph.getRowInfo(row).getOneOfHeads();
        return this.myDataPack.getRefsModel().rootAtHead(head);
    }
}

