/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcsUtil;

import com.intellij.ide.passwordSafe.PasswordSafe;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.net.AuthenticationPanel;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AuthDialog
extends DialogWrapper {
    private final AuthenticationPanel authPanel;

    public AuthDialog(@NotNull Project project2, @NotNull String title, @Nullable String description, @Nullable String login, @Nullable String password, boolean rememberByDefault) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/vcsUtil/AuthDialog", "<init>"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/vcsUtil/AuthDialog", "<init>"));
        }
        super(project2, false);
        this.setTitle(title);
        Boolean rememberPassword = AuthDialog.decideOnShowRememberPasswordOption(password, rememberByDefault);
        this.authPanel = new AuthenticationPanel(description, login, password, rememberPassword);
        this.init();
    }

    @Nullable
    private static Boolean decideOnShowRememberPasswordOption(@Nullable String password, boolean rememberByDefault) {
        if (PasswordSafe.getInstance().isMemoryOnly()) {
            return null;
        }
        if (!StringUtil.isEmptyOrSpaces((String)password)) {
            return true;
        }
        return rememberByDefault;
    }

    protected JComponent createCenterPanel() {
        return this.authPanel;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.authPanel.getPreferredFocusedComponent();
    }

    @NotNull
    public String getUsername() {
        String string2 = this.authPanel.getLogin();
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcsUtil/AuthDialog", "getUsername"));
        }
        return string2;
    }

    @NotNull
    public String getPassword() {
        String string2 = String.valueOf(this.authPanel.getPassword());
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcsUtil/AuthDialog", "getPassword"));
        }
        return string2;
    }

    public boolean isRememberPassword() {
        return this.authPanel.isRememberPassword();
    }
}

