/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcsUtil;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.WaitForProgressToShow;
import java.io.File;
import org.jetbrains.annotations.NotNull;

public class VcsImplUtil {
    public static void showErrorMessage(final Project project2, final String message2, final String title) {
        Runnable task2 = new Runnable(){

            @Override
            public void run() {
                Messages.showErrorDialog((Project)project2, (String)message2, (String)title);
            }
        };
        WaitForProgressToShow.runOrInvokeLaterAboveProgress((Runnable)task2, null, (Project)project2);
    }

    @NotNull
    public static String getShortVcsRootName(@NotNull Project project2, @NotNull VirtualFile root) {
        String relativePath;
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/vcsUtil/VcsImplUtil", "getShortVcsRootName"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/vcsUtil/VcsImplUtil", "getShortVcsRootName"));
        }
        VirtualFile projectDir = project2.getBaseDir();
        String repositoryPath = root.getPresentableUrl();
        if (projectDir != null && (relativePath = VfsUtilCore.getRelativePath((VirtualFile)root, (VirtualFile)projectDir, (char)File.separatorChar)) != null) {
            repositoryPath = relativePath;
        }
        String string2 = repositoryPath.isEmpty() ? root.getName() : repositoryPath;
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcsUtil/VcsImplUtil", "getShortVcsRootName"));
        }
        return string2;
    }
}

