/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcsUtil;

import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.actions.VcsContext;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.vcsUtil.VcsSelection;
import com.intellij.vcsUtil.VcsSelectionProvider;

public class XmlVcsSelectionProvider
implements VcsSelectionProvider {
    public VcsSelection getSelection(VcsContext context2) {
        String actionName;
        Editor editor = context2.getEditor();
        if (editor == null) {
            return null;
        }
        PsiElement psiElement = TargetElementUtil.findTargetElement(editor, 2);
        if (psiElement == null || !psiElement.isValid()) {
            return null;
        }
        if (psiElement instanceof XmlTag) {
            actionName = VcsBundle.message((String)"action.name.show.history.for.tag", (Object[])new Object[0]);
        } else if (psiElement instanceof XmlText) {
            actionName = VcsBundle.message((String)"action.name.show.history.for.text", (Object[])new Object[0]);
        } else {
            return null;
        }
        TextRange textRange = psiElement.getTextRange();
        if (textRange == null) {
            return null;
        }
        VirtualFile virtualFile = psiElement.getContainingFile().getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        if (!virtualFile.isValid()) {
            return null;
        }
        Document document = FileDocumentManager.getInstance().getDocument(virtualFile);
        return new VcsSelection(document, textRange, actionName);
    }
}

