/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webcore.formatter;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.ChildAttributes;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.Wrap;
import com.intellij.openapi.util.TextRange;
import com.intellij.webcore.formatter.SpacingStrategy;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompositeBlock
implements Block {
    private final List<Block> myChildBlocks;
    private Indent myIndent;
    private final SpacingStrategy mySpacingStrategy;
    private TextRange myTextRange;

    public CompositeBlock(@NotNull List<Block> childBlocks, @NotNull SpacingStrategy spacingStrategy, @Nullable Indent indent) {
        if (childBlocks == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "childBlocks", "com/intellij/webcore/formatter/CompositeBlock", "<init>"));
        }
        if (spacingStrategy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "spacingStrategy", "com/intellij/webcore/formatter/CompositeBlock", "<init>"));
        }
        this.myChildBlocks = childBlocks;
        this.myIndent = indent;
        assert (childBlocks.size() > 0) : "Attempt to create a composite block with no children";
        this.mySpacingStrategy = spacingStrategy;
        this.myTextRange = this.calcTextRange();
    }

    @NotNull
    private TextRange calcTextRange() {
        int startOffset = Integer.MAX_VALUE;
        int endOffset = -1;
        for (Block block : this.myChildBlocks) {
            startOffset = Math.min(startOffset, block.getTextRange().getStartOffset());
            endOffset = Math.max(endOffset, block.getTextRange().getEndOffset());
        }
        TextRange textRange = new TextRange(startOffset, endOffset);
        if (textRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/webcore/formatter/CompositeBlock", "calcTextRange"));
        }
        return textRange;
    }

    @NotNull
    public TextRange getTextRange() {
        TextRange textRange = this.myTextRange;
        if (textRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/webcore/formatter/CompositeBlock", "getTextRange"));
        }
        return textRange;
    }

    @NotNull
    public List<Block> getSubBlocks() {
        List<Block> list2 = this.myChildBlocks;
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/webcore/formatter/CompositeBlock", "getSubBlocks"));
        }
        return list2;
    }

    @Nullable
    public Wrap getWrap() {
        return null;
    }

    @Nullable
    public Indent getIndent() {
        return this.myIndent;
    }

    @Nullable
    public Alignment getAlignment() {
        return null;
    }

    @Nullable
    public Spacing getSpacing(@Nullable Block child1, @NotNull Block child2) {
        if (child2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child2", "com/intellij/webcore/formatter/CompositeBlock", "getSpacing"));
        }
        return this.mySpacingStrategy.getSpacing(child1, child2);
    }

    @NotNull
    public ChildAttributes getChildAttributes(int newChildIndex) {
        ChildAttributes childAttributes = new ChildAttributes(null, null);
        if (childAttributes == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/webcore/formatter/CompositeBlock", "getChildAttributes"));
        }
        return childAttributes;
    }

    public boolean isIncomplete() {
        return false;
    }

    public boolean isLeaf() {
        return false;
    }
}

