/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webcore.formatter.chainedMethods;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Wrap;
import com.intellij.formatting.WrapType;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.formatter.FormatterUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.webcore.formatter.CompositeBlock;
import com.intellij.webcore.formatter.SpacingStrategy;
import com.intellij.webcore.formatter.chainedMethods.CallChainBlock;
import com.intellij.webcore.formatter.chainedMethods.CompositeParamListBlock;
import com.intellij.webcore.formatter.chainedMethods.ParameterBlock;
import com.intellij.webcore.formatter.chainedMethods.ParameterListBlock;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CallChainBlockBuilder {
    @NotNull
    private final ASTNode myRootNode;
    private SpacingStrategy mySpacingStrategy;
    private Indent.Type myCallChainIndentType;
    private int myCallChainWrapType;
    private int myParameterWrapType;
    private boolean myPreferParameterWrap;
    private boolean myAlignParameters;
    private boolean myChainedCallDotOnNewLine;
    private boolean myUseGroupIndents;
    private Alignment myChainedCallsAlignment;
    private Wrap mySharedCallChainWrap;
    private boolean myIsFirsBlockInChain;
    private boolean myIsFirstBlockToWrap;

    public CallChainBlockBuilder(@NotNull ASTNode rootNode, @NotNull SpacingStrategy spacingStrategy, Indent.Type callChainIndentType, int callChainWrapType, int parameterWrapType, boolean preferParameterWrap, boolean alignChainedCalls, boolean alignParameters, boolean chainedCallDotOnNewLine, boolean useGroupIndents) {
        if (rootNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootNode", "com/intellij/webcore/formatter/chainedMethods/CallChainBlockBuilder", "<init>"));
        }
        if (spacingStrategy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "spacingStrategy", "com/intellij/webcore/formatter/chainedMethods/CallChainBlockBuilder", "<init>"));
        }
        this.myIsFirsBlockInChain = true;
        this.myIsFirstBlockToWrap = false;
        this.myRootNode = rootNode;
        this.mySpacingStrategy = spacingStrategy;
        this.myCallChainIndentType = callChainIndentType;
        this.myCallChainWrapType = callChainWrapType;
        this.myParameterWrapType = parameterWrapType;
        this.myPreferParameterWrap = preferParameterWrap;
        this.myAlignParameters = alignParameters;
        this.myChainedCallDotOnNewLine = chainedCallDotOnNewLine;
        this.myUseGroupIndents = useGroupIndents;
        this.myChainedCallsAlignment = alignChainedCalls ? Alignment.createAlignment() : null;
    }

    private void flatten(@NotNull ASTNode rootNode, List<ASTNode> result2) {
        if (rootNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootNode", "com/intellij/webcore/formatter/chainedMethods/CallChainBlockBuilder", "flatten"));
        }
        for (ASTNode child = rootNode.getFirstChildNode(); child != null; child = child.getTreeNext()) {
            if (this.shouldFlatten(child.getElementType())) {
                this.flatten(child, result2);
                continue;
            }
            result2.add(child);
        }
    }

    public List<Block> buildBlocks() {
        this.myIsFirsBlockInChain = true;
        ArrayList<ASTNode> flattenedList = new ArrayList<ASTNode>();
        this.flatten(this.myRootNode, flattenedList);
        ArrayList<Block> result2 = new ArrayList<Block>();
        ArrayList<Object> currChainBlocks = new ArrayList<Block>();
        ListIterator<ASTNode> listIterator = flattenedList.listIterator();
        Wrap currCallChainWrap = this.getCallChainWrap();
        Wrap currSharedParameterWrap = this.createSharedParameterWrap(currCallChainWrap);
        while (listIterator.hasNext()) {
            Block subBlock;
            ASTNode node = (ASTNode)listIterator.next();
            if (FormatterUtil.containsWhiteSpacesOnly(node)) continue;
            if (this.isDot(node.getElementType())) {
                if (!this.myChainedCallDotOnNewLine && !this.isPrecededByLineComment(node)) {
                    currChainBlocks.add(this.createSubBlock(node, Indent.getNoneIndent()));
                }
                if (currChainBlocks.size() > 0) {
                    result2.add(this.createCallChainBlock(currChainBlocks, currCallChainWrap));
                }
                currSharedParameterWrap = this.createSharedParameterWrap(currCallChainWrap);
                currCallChainWrap = this.getCallChainWrap();
                currChainBlocks = new ArrayList();
                ReferenceBlock referenceBlock = this.buildReferenceBlock(node, listIterator, currCallChainWrap);
                if (referenceBlock == null) continue;
                currChainBlocks.add(referenceBlock);
                continue;
            }
            if (this.isLeftParen(node.getElementType())) {
                listIterator.previous();
                subBlock = this.buildParamListBlock(listIterator);
                currChainBlocks.add(subBlock);
            } else {
                subBlock = this.createSubBlock(node, Indent.getNoneIndent());
            }
            if (subBlock instanceof ParameterListBlock) {
                Alignment parameterAlignment = this.myAlignParameters ? Alignment.createAlignment() : null;
                for (ParameterBlock parameterBlock : ((ParameterListBlock)subBlock).getParameterBlocks()) {
                    parameterBlock.setParameterWrap(currSharedParameterWrap);
                    parameterBlock.setAlignment(parameterAlignment);
                }
            }
            currChainBlocks.add(subBlock);
        }
        if (currChainBlocks.size() > 0) {
            result2.add(this.createCallChainBlock(currChainBlocks, currCallChainWrap));
        }
        return result2;
    }

    private boolean isPrecededByLineComment(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/webcore/formatter/chainedMethods/CallChainBlockBuilder", "isPrecededByLineComment"));
        }
        ASTNode prevNode = node.getTreePrev();
        if (prevNode != null && prevNode.getPsi() instanceof PsiWhiteSpace) {
            prevNode = prevNode.getTreePrev();
        }
        return prevNode != null && this.isEndOfLineComment(prevNode.getElementType());
    }

    @Nullable
    private Wrap createSharedParameterWrap(@Nullable Wrap parentWrap) {
        if (this.myParameterWrapType == 0) {
            return null;
        }
        return this.myPreferParameterWrap || parentWrap == null ? Wrap.createWrap((WrapType)WrapType.byLegacyRepresentation((int)this.myParameterWrapType), (boolean)false) : Wrap.createChildWrap((Wrap)parentWrap, (WrapType)WrapType.byLegacyRepresentation((int)this.myParameterWrapType), (boolean)false);
    }

    @Nullable
    private Wrap getCallChainWrap() {
        if (this.myIsFirstBlockToWrap) {
            switch (this.myCallChainWrapType) {
                case 1: {
                    return Wrap.createWrap((WrapType)WrapType.NORMAL, (boolean)true);
                }
                case 2: {
                    return Wrap.createWrap((WrapType)WrapType.ALWAYS, (boolean)true);
                }
                case 5: {
                    if (this.mySharedCallChainWrap == null) {
                        this.mySharedCallChainWrap = Wrap.createWrap((WrapType)WrapType.CHOP_DOWN_IF_LONG, (boolean)true);
                    }
                    return this.mySharedCallChainWrap;
                }
            }
        }
        return null;
    }

    private CallChainBlock createCallChainBlock(@NotNull List<Block> childBlocks, @Nullable Wrap callChainWrap) {
        if (childBlocks == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "childBlocks", "com/intellij/webcore/formatter/chainedMethods/CallChainBlockBuilder", "createCallChainBlock"));
        }
        CallChainBlock block = new CallChainBlock(childBlocks, this.mySpacingStrategy, this.getCallChainIndent(), this.myPreferParameterWrap ? null : callChainWrap, this.myIsFirsBlockInChain ? null : this.myChainedCallsAlignment);
        this.myIsFirsBlockInChain = false;
        if (CallChainBlockBuilder.containsParamList(childBlocks)) {
            this.myIsFirstBlockToWrap = true;
        }
        return block;
    }

    private Indent getCallChainIndent() {
        if (this.myIsFirsBlockInChain) {
            return Indent.getNoneIndent();
        }
        return this.myUseGroupIndents ? Indent.getSmartIndent((Indent.Type)this.myCallChainIndentType) : Indent.getIndent((Indent.Type)this.myCallChainIndentType, (boolean)false, (boolean)false);
    }

    private static boolean containsParamList(@NotNull List<Block> childBlocks) {
        if (childBlocks == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "childBlocks", "com/intellij/webcore/formatter/chainedMethods/CallChainBlockBuilder", "containsParamList"));
        }
        for (Block block : childBlocks) {
            if (!(block instanceof ParameterListBlock)) continue;
            return true;
        }
        return false;
    }

    private CompositeParamListBlock buildParamListBlock(@NotNull ListIterator<ASTNode> listIterator) {
        if (listIterator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listIterator", "com/intellij/webcore/formatter/chainedMethods/CallChainBlockBuilder", "buildParamListBlock"));
        }
        ArrayList<Block> childBlocks = new ArrayList<Block>();
        while (listIterator.hasNext()) {
            ASTNode node = listIterator.next();
            if (FormatterUtil.containsWhiteSpacesOnly(node)) continue;
            childBlocks.add(this.createSubBlock(node, Indent.getContinuationIndent()));
            if (!this.isRightParen(node.getElementType())) continue;
            break;
        }
        return new CompositeParamListBlock(childBlocks, this.mySpacingStrategy);
    }

    protected abstract boolean shouldFlatten(@NotNull IElementType var1);

    protected abstract boolean isLeftParen(@NotNull IElementType var1);

    protected abstract boolean isRightParen(@NotNull IElementType var1);

    protected abstract boolean isDot(@NotNull IElementType var1);

    protected abstract boolean isIdentifier(@NotNull IElementType var1);

    protected abstract boolean isEndOfLineComment(@NotNull IElementType var1);

    protected abstract Block createSubBlock(@NotNull ASTNode var1, @NotNull Indent var2);

    @Nullable
    private ReferenceBlock buildReferenceBlock(@NotNull ASTNode dotNode, @NotNull ListIterator<ASTNode> listIterator, @Nullable Wrap callChainWrap) {
        if (dotNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dotNode", "com/intellij/webcore/formatter/chainedMethods/CallChainBlockBuilder", "buildReferenceBlock"));
        }
        if (listIterator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listIterator", "com/intellij/webcore/formatter/chainedMethods/CallChainBlockBuilder", "buildReferenceBlock"));
        }
        ArrayList<Block> childBlocks = new ArrayList<Block>(2);
        if (this.myChainedCallDotOnNewLine || this.isPrecededByLineComment(dotNode)) {
            childBlocks.add(this.createSubBlock(dotNode, Indent.getNoneIndent()));
        }
        if (listIterator.hasNext()) {
            ASTNode next = listIterator.next();
            if (FormatterUtil.containsWhiteSpacesOnly(next) && listIterator.hasNext()) {
                next = listIterator.next();
            }
            if (this.isIdentifier(next.getElementType()) || next instanceof PsiComment) {
                childBlocks.add(this.createSubBlock(next, Indent.getNoneIndent()));
            } else {
                listIterator.previous();
            }
        }
        return childBlocks.size() > 0 ? new ReferenceBlock(childBlocks, this.mySpacingStrategy, Indent.getNoneIndent(), (Wrap)(this.myPreferParameterWrap ? callChainWrap : null)) : null;
    }

    private static class ReferenceBlock
    extends CompositeBlock {
        @Nullable
        private Wrap myWrap;

        public ReferenceBlock(@NotNull List<Block> childBlocks, @NotNull SpacingStrategy spacingStrategy, @Nullable Indent indent, @Nullable Wrap wrap) {
            if (childBlocks == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "childBlocks", "com/intellij/webcore/formatter/chainedMethods/CallChainBlockBuilder$ReferenceBlock", "<init>"));
            }
            if (spacingStrategy == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "spacingStrategy", "com/intellij/webcore/formatter/chainedMethods/CallChainBlockBuilder$ReferenceBlock", "<init>"));
            }
            super(childBlocks, spacingStrategy, indent);
            this.myWrap = wrap;
        }

        @Override
        @Nullable
        public Wrap getWrap() {
            return this.myWrap;
        }
    }
}

