/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webcore.formatter.chainedMethods;

import com.intellij.formatting.Block;
import com.intellij.formatting.Spacing;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.webcore.formatter.SpacingStrategy;
import com.intellij.webcore.formatter.chainedMethods.CallChainBlock;
import com.intellij.webcore.formatter.chainedMethods.CallChainDotBlock;
import com.intellij.webcore.formatter.chainedMethods.ParameterListBlock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChainedBlocksSpacingStrategy
implements SpacingStrategy {
    private CommonCodeStyleSettings myLangSettings;

    public ChainedBlocksSpacingStrategy(@NotNull CommonCodeStyleSettings langSettings) {
        if (langSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "langSettings", "com/intellij/webcore/formatter/chainedMethods/ChainedBlocksSpacingStrategy", "<init>"));
        }
        this.myLangSettings = langSettings;
    }

    @Override
    @Nullable
    public Spacing getSpacing(@Nullable Block child1, @NotNull Block child2) {
        if (child2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child2", "com/intellij/webcore/formatter/chainedMethods/ChainedBlocksSpacingStrategy", "getSpacing"));
        }
        if (child1 instanceof CallChainBlock && child2 instanceof CallChainBlock) {
            return Spacing.createSpacing((int)0, (int)0, (int)0, (boolean)true, (int)this.myLangSettings.KEEP_BLANK_LINES_IN_CODE);
        }
        if (child2 instanceof ParameterListBlock) {
            int spaces = this.myLangSettings.SPACE_BEFORE_METHOD_CALL_PARENTHESES ? 1 : 0;
            return Spacing.createSpacing((int)spaces, (int)spaces, (int)0, (boolean)this.myLangSettings.KEEP_LINE_BREAKS, (int)this.myLangSettings.KEEP_BLANK_LINES_IN_CODE);
        }
        if (child1 instanceof CallChainDotBlock) {
            return this.createDotSpacing(this.isDotOnNewLine());
        }
        if (child2 instanceof CallChainDotBlock) {
            return this.createDotSpacing(!this.isDotOnNewLine());
        }
        return null;
    }

    private Spacing createDotSpacing(boolean removeLineBreaks) {
        return Spacing.createSpacing((int)0, (int)0, (int)0, (!removeLineBreaks && this.myLangSettings.KEEP_LINE_BREAKS ? 1 : 0) != 0, (int)(removeLineBreaks ? 0 : this.myLangSettings.KEEP_BLANK_LINES_IN_CODE));
    }

    protected boolean isDotOnNewLine() {
        return true;
    }
}

