/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webcore.formatter.comments;

import com.intellij.openapi.util.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CommentLineData {
    protected String line;
    int commentOffset;
    int textStartOffset;
    boolean startsWithLetter;

    public CommentLineData(@NotNull String line) {
        if (line == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "com/intellij/webcore/formatter/comments/CommentLineData", "<init>"));
        }
        this.commentOffset = -1;
        this.textStartOffset = -1;
        this.startsWithLetter = false;
        this.line = line;
    }

    protected int calcWrapPos(int rightMargin) {
        if (!this.hasText()) {
            return -1;
        }
        int indexBeforeRightMargin = this.getLastIndexBeforeRightMargin(rightMargin);
        String cutLine = this.line.substring(0, indexBeforeRightMargin);
        int wrapPos = cutLine.lastIndexOf(32);
        if (wrapPos < this.textStartOffset) {
            wrapPos = this.line.indexOf(32, this.textStartOffset);
        }
        return wrapPos;
    }

    public boolean hasText() {
        return this.textStartOffset > this.commentOffset;
    }

    public boolean canBeMergedWithPrevious() {
        return this.hasText() && this.startsWithLetter;
    }

    @NotNull
    public String getText() {
        if (this.hasText()) {
            String string2 = this.line.substring(this.textStartOffset);
            if (string2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/webcore/formatter/comments/CommentLineData", "getText"));
            }
            return string2;
        }
        if ("" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/webcore/formatter/comments/CommentLineData", "getText"));
        }
        return "";
    }

    public void merge(@NotNull CommentLineData lineData) {
        if (lineData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lineData", "com/intellij/webcore/formatter/comments/CommentLineData", "merge"));
        }
        this.line = this.line + " " + lineData.getText();
    }

    public int getLineLength() {
        int len = 0;
        for (int i2 = 0; i2 < this.line.length(); ++i2) {
            char c2 = this.line.charAt(i2);
            len = this.getNextCol(len, c2);
        }
        return len;
    }

    @Nullable
    public Pair<String, String> splitLine(int rightMargin) {
        int wrapPos = this.calcWrapPos(rightMargin);
        if (wrapPos >= 0) {
            return new Pair((Object)this.line.substring(0, wrapPos), (Object)this.line.substring(wrapPos));
        }
        return null;
    }

    @NotNull
    public String getLine() {
        String string2 = this.line;
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/webcore/formatter/comments/CommentLineData", "getLine"));
        }
        return string2;
    }

    public boolean isTagLine() {
        return false;
    }

    public void setTagLine(boolean isTagLine) {
    }

    @NotNull
    public String getLinePrefix() {
        if ("" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/webcore/formatter/comments/CommentLineData", "getLinePrefix"));
        }
        return "";
    }

    protected abstract int getTabSize();

    private int getLastIndexBeforeRightMargin(int rightMargin) {
        int col = 0;
        int i2 = 0;
        while (col < rightMargin) {
            if (i2 < this.line.length()) {
                char c2 = this.line.charAt(i2);
                if ((col = this.getNextCol(col, c2)) > rightMargin) break;
                ++i2;
                continue;
            }
            --i2;
            break;
        }
        return i2;
    }

    private int getNextCol(int currCol, char c2) {
        return currCol + (c2 == '\t' ? this.getTabSize() : 1);
    }
}

