/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webcore.formatter.comments;

import com.intellij.formatting.FormatterTagHandler;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.webcore.formatter.comments.CommentLineData;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CommentLineDataBuilder
extends FormatterTagHandler {
    private static final char[] DOC_WHITESPACE = new char[]{' ', '\t'};

    public CommentLineDataBuilder(CodeStyleSettings settings) {
        super(settings);
    }

    @Nullable
    public abstract List<CommentLineData> getLines();

    @NotNull
    public abstract CommentLineData parseLine(@NotNull String var1);

    protected static int skipChars(String str, int from, boolean except, char ... chars) {
        for (int i2 = from; i2 < str.length(); ++i2) {
            char ch = str.charAt(i2);
            boolean stopHere = !except;
            for (char skipCh : chars) {
                if (skipCh != ch) continue;
                if (except) {
                    return i2;
                }
                stopHere = false;
                break;
            }
            if (!stopHere) continue;
            return i2;
        }
        return -1;
    }

    protected static int nextNonWhitespace(String str, int from) {
        return CommentLineDataBuilder.skipChars(str, from, false, DOC_WHITESPACE);
    }

    protected static int nextWhitespace(String str, int from) {
        return CommentLineDataBuilder.skipChars(str, from, true, DOC_WHITESPACE);
    }

    protected static int skipNextWord(String str, int from) {
        int next = CommentLineDataBuilder.nextNonWhitespace(str, from);
        if (next >= 0) {
            next = CommentLineDataBuilder.nextWhitespace(str, next);
        }
        return next;
    }
}

