/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webcore.formatter.comments;

import com.intellij.openapi.util.Pair;
import com.intellij.webcore.formatter.comments.CommentLineData;
import com.intellij.webcore.formatter.comments.CommentLineDataBuilder;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommentWrapper {
    private static final int MAX_SPLIT_ITERATIONS = 10;

    @Nullable
    public static String wrapCommentLines(@NotNull CommentLineDataBuilder commentLineDataBuilder, int rightMargin) {
        if (commentLineDataBuilder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commentLineDataBuilder", "com/intellij/webcore/formatter/comments/CommentWrapper", "wrapCommentLines"));
        }
        List<CommentLineData> lines = commentLineDataBuilder.getLines();
        if (!CommentWrapper.isWrappingNeeded(lines, rightMargin)) {
            return null;
        }
        List<CommentLineData> mergedLines = CommentWrapper.mergeLines(lines, rightMargin);
        StringBuilder docBuilder = new StringBuilder();
        boolean atStart = true;
        for (CommentLineData lineData : mergedLines) {
            if (atStart) {
                atStart = false;
            } else {
                docBuilder.append('\n');
            }
            CommentWrapper.splitLine(lineData, commentLineDataBuilder, docBuilder, rightMargin, 0);
        }
        return docBuilder.toString();
    }

    private static boolean isWrappingNeeded(List<CommentLineData> lines, int rightMargin) {
        for (CommentLineData lineData : lines) {
            if (lineData.getLineLength() <= rightMargin) continue;
            return true;
        }
        return false;
    }

    private static List<CommentLineData> mergeLines(List<CommentLineData> originalLines, int rightMargin) {
        ArrayList<CommentLineData> result2 = new ArrayList<CommentLineData>(originalLines.size());
        CommentLineData lastLine = null;
        for (CommentLineData line : originalLines) {
            if (lastLine != null && lastLine.hasText() && lastLine.getLineLength() > rightMargin && line.canBeMergedWithPrevious()) {
                lastLine.merge(line);
                continue;
            }
            result2.add(line);
            lastLine = line;
        }
        return result2;
    }

    private static void splitLine(CommentLineData lineData, CommentLineDataBuilder lineDataBuilder, StringBuilder docBuilder, int rightMargin, int depth) {
        String linePrefix;
        Pair<String, String> chunks;
        if (lineData.getLineLength() >= rightMargin && depth < 10 && (chunks = lineData.splitLine(rightMargin)) != null && !(linePrefix = lineData.getLinePrefix()).isEmpty() && linePrefix.length() + ((String)chunks.second).length() < lineData.getLineLength()) {
            docBuilder.append((String)chunks.first).append('\n');
            String newLine = linePrefix + (String)chunks.second;
            CommentLineData newLineData = lineDataBuilder.parseLine(newLine);
            newLineData.setTagLine(lineData.isTagLine());
            CommentWrapper.splitLine(newLineData, lineDataBuilder, docBuilder, rightMargin, depth + 1);
            return;
        }
        docBuilder.append(lineData.getLine());
    }
}

