/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webcore.formatter.comments;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.webcore.formatter.comments.CommentLineData;
import com.intellij.webcore.formatter.comments.CommentLineDataBuilder;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class DocCommentLineDataBuilder
extends CommentLineDataBuilder {
    private boolean myAlignDocComments;
    private PsiElement myDocComment;
    private final CommonCodeStyleSettings mySettings;
    private final CommonCodeStyleSettings.IndentOptions myIndentOptions;

    public DocCommentLineDataBuilder(@NotNull PsiElement docComment, boolean alignDocComments, @NotNull CommonCodeStyleSettings settings) {
        if (docComment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "docComment", "com/intellij/webcore/formatter/comments/DocCommentLineDataBuilder", "<init>"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/webcore/formatter/comments/DocCommentLineDataBuilder", "<init>"));
        }
        super(settings.getRootSettings());
        this.myDocComment = docComment;
        this.myAlignDocComments = alignDocComments;
        this.mySettings = settings;
        this.myIndentOptions = settings.getIndentOptions() != null ? settings.getIndentOptions() : new CommonCodeStyleSettings.IndentOptions();
    }

    @Override
    public List<CommentLineData> getLines() {
        CharSequence docChars = this.myDocComment.getNode().getChars();
        ArrayList<CommentLineData> lines = new ArrayList<CommentLineData>();
        int lineStart = 0;
        boolean isTagLine = false;
        block3: for (int i2 = 0; i2 < docChars.length(); ++i2) {
            char c2 = docChars.charAt(i2);
            switch (c2) {
                case '\n': {
                    if (lineStart < i2) {
                        CommentLineData lineData = this.createLineDataFromSequence(docChars, lineStart, i2, isTagLine);
                        isTagLine = lineData.isTagLine();
                        lines.add(lineData);
                    }
                    lineStart = i2 + 1;
                    continue block3;
                }
            }
        }
        if (lineStart < docChars.length()) {
            lines.add(this.createLineDataFromSequence(docChars, lineStart, docChars.length(), isTagLine));
        }
        return lines;
    }

    private CommentLineData createLineDataFromSequence(CharSequence charSequence, int start2, int end, boolean isTagLine) {
        String line = new String(CharArrayUtil.fromSequence((CharSequence)charSequence, (int)start2, (int)end));
        CommentLineData lineData = this.parseLine(line);
        lineData.setTagLine(isTagLine);
        return lineData;
    }

    @Override
    @NotNull
    public CommentLineData parseLine(@NotNull String line) {
        if (line == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "com/intellij/webcore/formatter/comments/DocCommentLineDataBuilder", "parseLine"));
        }
        DocCommentLineData lineData = new DocCommentLineData(line);
        lineData.commentOffset = DocCommentLineDataBuilder.nextNonWhitespace(line, 0);
        if (lineData.commentOffset >= 0) {
            int next;
            if (line.charAt(lineData.commentOffset) == '*') {
                ++lineData.commentOffset;
            }
            if ((next = DocCommentLineDataBuilder.nextNonWhitespace(line, lineData.commentOffset)) >= 0) {
                char firstChar = line.charAt(next);
                if (firstChar == '@') {
                    lineData.tagStartOffset = next;
                    int n2 = lineData.tagEndOffset = (next = DocCommentLineDataBuilder.nextWhitespace(line, next + 1)) >= 0 ? next : line.length();
                    if (lineData.tagEndOffset > lineData.tagStartOffset) {
                        lineData.tagName = line.substring(lineData.tagStartOffset, lineData.tagEndOffset);
                    }
                    if (next >= 0) {
                        if ("@param".equals(lineData.tagName)) {
                            if ((next = DocCommentLineDataBuilder.nextNonWhitespace(line, next + 1)) >= 0) {
                                boolean isAtParamName = line.charAt(next) == '$';
                                next = DocCommentLineDataBuilder.nextWhitespace(line, next);
                                if (!isAtParamName && next >= 0) {
                                    next = DocCommentLineDataBuilder.skipNextWord(line, next);
                                }
                            }
                        } else if ("@return".equals(lineData.tagName) || "@throws".equals(lineData.tagName)) {
                            next = DocCommentLineDataBuilder.skipNextWord(line, next);
                        }
                    }
                } else if (Character.isLetter(firstChar)) {
                    lineData.startsWithLetter = true;
                }
                if (next >= 0) {
                    lineData.textStartOffset = (next = DocCommentLineDataBuilder.nextNonWhitespace(line, next)) >= 0 ? next : -1;
                }
            }
        }
        DocCommentLineData docCommentLineData = lineData;
        if (docCommentLineData == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/webcore/formatter/comments/DocCommentLineDataBuilder", "parseLine"));
        }
        return docCommentLineData;
    }

    private class DocCommentLineData
    extends CommentLineData {
        int tagStartOffset;
        int tagEndOffset;
        String tagName;
        private boolean isTagLine;

        public DocCommentLineData(String line) {
            if (line == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "com/intellij/webcore/formatter/comments/DocCommentLineDataBuilder$DocCommentLineData", "<init>"));
            }
            super(line);
            this.tagStartOffset = -1;
            this.tagEndOffset = -1;
            this.tagName = "";
            this.isTagLine = false;
        }

        @Override
        public boolean isTagLine() {
            return this.tagStartOffset >= 0 || this.isTagLine;
        }

        @Override
        public void setTagLine(boolean tagLine) {
            this.isTagLine = tagLine;
        }

        @Override
        @NotNull
        public String getLinePrefix() {
            StringBuilder prefixBuilder = new StringBuilder();
            if (this.commentOffset >= 0) {
                prefixBuilder.append(this.line.substring(0, this.commentOffset));
                if (this.textStartOffset > this.commentOffset) {
                    if (DocCommentLineDataBuilder.this.myAlignDocComments) {
                        StringUtil.repeatSymbol((Appendable)prefixBuilder, (char)' ', (int)(this.textStartOffset - this.commentOffset - 1));
                    } else if (this.isTagLine()) {
                        StringUtil.repeatSymbol((Appendable)prefixBuilder, (char)' ', (int)((DocCommentLineDataBuilder)DocCommentLineDataBuilder.this).myIndentOptions.CONTINUATION_INDENT_SIZE);
                    }
                }
            }
            String string2 = prefixBuilder.toString();
            if (string2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/webcore/formatter/comments/DocCommentLineDataBuilder$DocCommentLineData", "getLinePrefix"));
            }
            return string2;
        }

        @Override
        protected int getTabSize() {
            return ((DocCommentLineDataBuilder)DocCommentLineDataBuilder.this).myIndentOptions.TAB_SIZE;
        }
    }
}

