/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webcore.formatter.comments;

import com.intellij.formatting.FormatterTagHandler;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.webcore.formatter.comments.CommentLineData;
import com.intellij.webcore.formatter.comments.CommentLineDataBuilder;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LineCommentLineDataBuilder
extends CommentLineDataBuilder {
    private PsiComment myComment;
    private IElementType myLineCommentType;
    private static final String LINE_COMMENT_PREFIX = "//";
    private TextRange myCommentBlockRange;
    private CommonCodeStyleSettings.IndentOptions myIndentOptions;
    @Nullable
    private TextRange myEnabledRange;
    private int myLeadingTabs;

    public LineCommentLineDataBuilder(@NotNull PsiComment comment, IElementType lineCommentType, @NotNull CommonCodeStyleSettings settings, @Nullable TextRange enabledRange) {
        if (comment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comment", "com/intellij/webcore/formatter/comments/LineCommentLineDataBuilder", "<init>"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/webcore/formatter/comments/LineCommentLineDataBuilder", "<init>"));
        }
        super(settings.getRootSettings());
        this.myComment = comment;
        this.myLineCommentType = lineCommentType;
        this.myIndentOptions = settings.getIndentOptions() != null ? settings.getIndentOptions() : new CommonCodeStyleSettings.IndentOptions();
        this.myEnabledRange = enabledRange;
    }

    public boolean isMergedWithPrevious(@NotNull PsiComment comment) {
        if (comment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comment", "com/intellij/webcore/formatter/comments/LineCommentLineDataBuilder", "isMergedWithPrevious"));
        }
        if (this.isAfterNonEmptyLine(comment.getNode()) || this.getFormatterTag(comment) != FormatterTagHandler.FormatterTag.NONE) {
            return false;
        }
        PsiElement prev = comment.getPrevSibling();
        if (prev instanceof PsiWhiteSpace) {
            PsiElement whitespaceBefore = prev;
            if ((prev = prev.getPrevSibling()) != null && prev.getNode().getElementType() == this.myLineCommentType && LineCommentLineDataBuilder.countLineBreaks(whitespaceBefore.getNode()) == 1) {
                int prevIndent;
                if (this.myEnabledRange != null && prev.getTextRange().getEndOffset() < this.myEnabledRange.getStartOffset() || prev instanceof PsiComment && this.getFormatterTag((PsiComment)prev) != FormatterTagHandler.FormatterTag.NONE) {
                    return false;
                }
                int currIndent = this.calcBlockLineIndent(comment.getNode());
                return currIndent == (prevIndent = this.calcBlockLineIndent(prev.getNode()));
            }
        }
        return false;
    }

    @Override
    public List<CommentLineData> getLines() {
        ArrayList<CommentLineData> lines = new ArrayList<CommentLineData>();
        int startOffset = this.myComment.getTextRange().getStartOffset();
        int endOffset = this.myComment.getTextRange().getEndOffset();
        int blockIndent = this.calcBlockLineIndent(this.myComment.getNode());
        this.addLineDataFromComment(lines, (PsiElement)this.myComment, blockIndent, true);
        for (PsiElement next = this.myComment.getNextSibling(); next != null && (this.myEnabledRange == null || next.getTextRange().getStartOffset() <= this.myEnabledRange.getEndOffset()); next = next.getNextSibling()) {
            if (next.getNode().getElementType() == this.myLineCommentType) {
                int nextIndent;
                if (next instanceof PsiComment && this.getFormatterTag((PsiComment)next) != FormatterTagHandler.FormatterTag.NONE || (nextIndent = this.calcBlockLineIndent(next.getNode())) != blockIndent) break;
                endOffset = next.getTextRange().getEndOffset();
                this.addLineDataFromComment(lines, next, blockIndent, false);
                continue;
            }
            if (!(next instanceof PsiWhiteSpace) || LineCommentLineDataBuilder.countLineBreaks(next.getNode()) > 1) break;
        }
        this.myCommentBlockRange = new TextRange(startOffset, endOffset);
        return lines;
    }

    public TextRange getCommentBlockRange() {
        return this.myCommentBlockRange;
    }

    private void addLineDataFromComment(List<CommentLineData> lines, @NotNull PsiElement comment, int indent, boolean isEndOfLineComment) {
        if (comment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comment", "com/intellij/webcore/formatter/comments/LineCommentLineDataBuilder", "addLineDataFromComment"));
        }
        String line = new String(CharArrayUtil.fromSequence((CharSequence)comment.getNode().getChars()));
        LineCommentLineData lineData = (LineCommentLineData)this.parseLine(line);
        lineData.indent = indent;
        lineData.isFirst = isEndOfLineComment;
        lines.add(lineData);
    }

    @Override
    @NotNull
    public CommentLineData parseLine(@NotNull String line) {
        int next;
        if (line == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "com/intellij/webcore/formatter/comments/LineCommentLineDataBuilder", "parseLine"));
        }
        LineCommentLineData lineData = new LineCommentLineData(line);
        lineData.commentOffset = LineCommentLineDataBuilder.nextNonWhitespace(line, 0);
        if (lineData.commentOffset >= 0 && (next = lineData.commentOffset + LINE_COMMENT_PREFIX.length()) < line.length()) {
            lineData.textStartOffset = LineCommentLineDataBuilder.nextNonWhitespace(line, next);
        }
        LineCommentLineData lineCommentLineData = lineData;
        if (lineCommentLineData == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/webcore/formatter/comments/LineCommentLineDataBuilder", "parseLine"));
        }
        return lineCommentLineData;
    }

    public boolean isAfterNonEmptyLine(@NotNull ASTNode node) {
        ASTNode prev;
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/webcore/formatter/comments/LineCommentLineDataBuilder", "isAfterNonEmptyLine"));
        }
        if (node.getElementType() == this.myLineCommentType && (prev = node.getTreePrev()) != null) {
            return !(prev.getPsi() instanceof PsiWhiteSpace) || !prev.textContains('\n');
        }
        return false;
    }

    public static int countLineBreaks(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/webcore/formatter/comments/LineCommentLineDataBuilder", "countLineBreaks"));
        }
        CharSequence sequence = node.getChars();
        int count = 0;
        for (int i2 = 0; i2 < sequence.length(); ++i2) {
            if (sequence.charAt(i2) != '\n') continue;
            ++count;
        }
        return count;
    }

    public int calcBlockLineIndent(@NotNull ASTNode node) {
        ASTNode prev;
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/webcore/formatter/comments/LineCommentLineDataBuilder", "calcBlockLineIndent"));
        }
        int indent = 0;
        for (prev = node.getTreePrev(); prev != null && !prev.textContains('\n'); prev = prev.getTreePrev()) {
            indent += prev.getTextLength();
        }
        if (prev != null) {
            int offset = 0;
            CharSequence prevSequence = prev.getChars();
            int lastEolOffset = CharArrayUtil.shiftBackwardUntil((CharSequence)prevSequence, (int)(prev.getTextLength() - 1), (String)"\r\n");
            if (lastEolOffset >= 0) {
                offset += prev.getTextLength() - lastEolOffset - 1;
            }
            char[] indentChars = CharArrayUtil.fromSequence((CharSequence)prevSequence, (int)(prev.getTextLength() - offset), (int)prev.getTextLength());
            this.myLeadingTabs = 0;
            boolean isTabIndent = indentChars.length > 0 && indentChars[0] == '\t';
            for (char c2 : indentChars) {
                if (c2 == '\t' && isTabIndent) {
                    indent += this.myIndentOptions.TAB_SIZE;
                    ++this.myLeadingTabs;
                    continue;
                }
                isTabIndent = false;
                ++indent;
            }
        }
        return indent;
    }

    private class LineCommentLineData
    extends CommentLineData {
        private int indent;
        private boolean isFirst;

        public LineCommentLineData(String line) {
            if (line == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "com/intellij/webcore/formatter/comments/LineCommentLineDataBuilder$LineCommentLineData", "<init>"));
            }
            super(line);
        }

        @Override
        public int getLineLength() {
            return this.indent + super.getLineLength();
        }

        @Override
        protected int calcWrapPos(int rightMargin) {
            if (this.indent < rightMargin) {
                return super.calcWrapPos(rightMargin - this.indent);
            }
            return -1;
        }

        public String getIndentString() {
            if (!((LineCommentLineDataBuilder)LineCommentLineDataBuilder.this).myIndentOptions.USE_TAB_CHARACTER) {
                return StringUtil.repeatSymbol((char)' ', (int)this.indent);
            }
            int tabs = ((LineCommentLineDataBuilder)LineCommentLineDataBuilder.this).myIndentOptions.SMART_TABS ? LineCommentLineDataBuilder.this.myLeadingTabs : (((LineCommentLineDataBuilder)LineCommentLineDataBuilder.this).myIndentOptions.TAB_SIZE > 0 ? this.indent / ((LineCommentLineDataBuilder)LineCommentLineDataBuilder.this).myIndentOptions.TAB_SIZE : 0);
            int spaces = this.indent - tabs * ((LineCommentLineDataBuilder)LineCommentLineDataBuilder.this).myIndentOptions.TAB_SIZE;
            return StringUtil.repeatSymbol((char)'\t', (int)tabs) + StringUtil.repeatSymbol((char)' ', (int)spaces);
        }

        @Override
        @Nullable
        public Pair<String, String> splitLine(int rightMargin) {
            Pair<String, String> newLines = super.splitLine(rightMargin);
            if (newLines != null && !this.isFirst && this.indent > 0) {
                return Pair.create((Object)(this.getIndentString() + (String)newLines.first), (Object)newLines.second);
            }
            return newLines;
        }

        @Override
        @NotNull
        public String getLinePrefix() {
            String string2 = (this.indent > 0 ? this.getIndentString() : this.line.substring(0, this.commentOffset)) + LineCommentLineDataBuilder.LINE_COMMENT_PREFIX;
            if (string2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/webcore/formatter/comments/LineCommentLineDataBuilder$LineCommentLineData", "getLinePrefix"));
            }
            return string2;
        }

        @Override
        protected int getTabSize() {
            return ((LineCommentLineDataBuilder)LineCommentLineDataBuilder.this).myIndentOptions.TAB_SIZE;
        }

        @Override
        @NotNull
        public String getLine() {
            String string2 = this.indent > 0 && !this.isFirst ? this.getIndentString() + this.line : this.line;
            if (string2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/webcore/formatter/comments/LineCommentLineDataBuilder$LineCommentLineData", "getLine"));
            }
            return string2;
        }

        @Override
        public boolean canBeMergedWithPrevious() {
            return true;
        }
    }
}

