/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webcore.libraries.ui;

import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.ui.Util;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.TableSpeedSearch;
import com.intellij.ui.TableUtil;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBComboBoxLabel;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.editors.JBComboBoxTableCellEditorComponent;
import com.intellij.ui.table.JBTable;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import com.intellij.util.containers.SortedList;
import com.intellij.util.ui.AbstractTableCellEditor;
import com.intellij.webcore.ScriptingFrameworkDescriptor;
import com.intellij.webcore.WebCoreBundle;
import com.intellij.webcore.libraries.LangScriptingContextProvider;
import com.intellij.webcore.libraries.ScriptingLibraryModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Queue;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.AbstractListModel;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditLibraryDialog
extends DialogWrapper {
    private static final int FILE_LOCATION_COL = 0;
    private static final int FILE_TYPE_COL = 1;
    private final String mySourceTypeName;
    private final String myCompactTypeName;
    private static final Comparator<VirtualFile> FILES_COMPARATOR = (file1, file2) -> file1.getName().compareToIgnoreCase(file2.getName());
    private JPanel contentPane;
    private JTextField myLibName;
    private final JBTable myFileTable;
    private JBList myDocUrlList;
    private JComboBox myFrameworkCombo;
    private JTextField myVersionField;
    private JRadioButton myProjectRadioButton;
    private JRadioButton myGlobalRadioButton;
    private JPanel myFilesPanel;
    private JPanel myUrlsPanel;
    private Project myProject;
    private FileTableModel myFileTableModel;
    private final LangScriptingContextProvider myProvider;
    private MyDocUrlListModel myDocUrlListModel;
    private ScriptingFrameworkDescriptor mySelectedFramework;
    private final Icon myFileIcon;
    private final Icon myDirectoryIcon;
    private AnActionButton myDownloadButton;
    private AnActionButton myEditDocUrlButton;
    private FileChooserDescriptor LIB_FILES_CHOOSER_DESCRIPTOR;

    public EditLibraryDialog(String title, LangScriptingContextProvider provider, Project project2) {
        super(true);
        this.$$$setupUI$$$();
        this.LIB_FILES_CHOOSER_DESCRIPTOR = new FileChooserDescriptor(true, true, false, true, false, true){
            {
                this.setTitle(WebCoreBundle.message((String)"edit.library.attach.files.dialog.title", (Object[])new Object[0]));
            }

            public boolean isFileSelectable(VirtualFile file2) {
                if (!file2.isDirectory() && !EditLibraryDialog.this.myProvider.acceptsExtension(file2.getExtension())) {
                    return false;
                }
                return super.isFileSelectable(file2);
            }

            public boolean isFileVisible(VirtualFile file2, boolean showHiddenFiles) {
                if (!file2.isDirectory() && !EditLibraryDialog.this.myProvider.acceptsExtension(file2.getExtension())) {
                    return false;
                }
                return super.isFileVisible(file2, showHiddenFiles);
            }
        };
        this.myFileIcon = provider.getFileIcon();
        this.myDirectoryIcon = AllIcons.Nodes.Folder;
        this.myProvider = provider;
        this.myProject = project2;
        this.myFileTable = new JBTable();
        this.myFileTable.setStriped(true);
        this.myFileTable.setUpdateSelectionOnSort(true);
        JPanel contentChildPanel = ToolbarDecorator.createDecorator((JTable)this.myFileTable).disableUpAction().disableDownAction().setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                List children2 = EditLibraryDialog.this.getAddFilesActions();
                if (children2.isEmpty()) {
                    return;
                }
                DefaultActionGroup actions2 = new DefaultActionGroup(children2.toArray(new AnAction[children2.size()]));
                JBPopupFactory.getInstance().createActionGroupPopup(null, (ActionGroup)actions2, DataManager.getInstance().getDataContext((Component)button.getContextComponent()), JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, true).show(button.getPreferredPopupPoint());
            }
        }).setRemoveAction(new AnActionButtonRunnable(){

            public void run(AnActionButton anActionButton) {
                EditLibraryDialog.this.removeSelected();
            }
        }).createPanel();
        this.myFilesPanel.add((Component)contentChildPanel, "Center");
        this.setTitle(title);
        this.mySourceTypeName = provider.getLibraryTypeName(OrderRootType.SOURCES);
        this.myCompactTypeName = provider.getLibraryTypeName(OrderRootType.CLASSES);
        this.myFileTableModel = new FileTableModel();
        this.myFileTable.setRowHeight(this.myFileTable.getRowHeight() + 5);
        this.myFileTable.setModel((TableModel)this.myFileTableModel);
        new TableSpeedSearch((JTable)this.myFileTable);
        this.myDocUrlListModel = new MyDocUrlListModel();
        this.myDocUrlList = new JBList((ListModel)this.myDocUrlListModel);
        this.myDocUrlListModel.addListDataListener(new ListDataListener(){

            @Override
            public void intervalAdded(ListDataEvent e2) {
                EditLibraryDialog.this.checkDownloadOfflineDocEnabled();
            }

            @Override
            public void intervalRemoved(ListDataEvent e2) {
                Object source = e2.getSource();
                if (source instanceof MyDocUrlListModel && ((MyDocUrlListModel)source).getDocUrls().length == 0) {
                    EditLibraryDialog.this.checkDownloadOfflineDocEnabled();
                }
            }

            @Override
            public void contentsChanged(ListDataEvent e2) {
            }
        });
        this.myDocUrlList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e2) {
                EditLibraryDialog.this.myEditDocUrlButton.setEnabled(EditLibraryDialog.this.myDocUrlList.getSelectedIndex() >= 0);
            }
        });
        this.myDownloadButton = new AnActionButton("Download", AllIcons.Actions.Download){

            public void actionPerformed(@NotNull AnActionEvent e2) {
                if (e2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/webcore/libraries/ui/EditLibraryDialog$5", "actionPerformed"));
                }
                EditLibraryDialog.this.downloadDocumentation();
            }
        };
        this.myEditDocUrlButton = new AnActionButton("Edit", AllIcons.ToolbarDecorator.Edit){

            public void actionPerformed(@NotNull AnActionEvent e2) {
                if (e2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/webcore/libraries/ui/EditLibraryDialog$6", "actionPerformed"));
                }
                EditLibraryDialog.this.editDocUrl();
            }
        };
        this.myUrlsPanel.add((Component)ToolbarDecorator.createDecorator((JList)this.myDocUrlList).disableUpDownActions().setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                EditLibraryDialog.this.specifyDocUrl();
            }
        }).setRemoveAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                EditLibraryDialog.this.removeDocUrl();
            }
        }).addExtraAction(this.myEditDocUrlButton).addExtraAction(this.myDownloadButton).createPanel(), "Center");
        this.myDownloadButton.setEnabled(false);
        this.myEditDocUrlButton.setEnabled(false);
        this.initFrameworkCombo();
        this.myVersionField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e2) {
                EditLibraryDialog.this.updateVersion();
            }
        });
        this.init();
        TableColumn typeCol = this.myFileTable.getColumnModel().getColumn(1);
        typeCol.setMaxWidth(80);
        typeCol.setCellEditor((TableCellEditor)((Object)new TypeCellEditor()));
        typeCol.setCellRenderer(new DefaultTableCellRenderer(){
            private JBComboBoxLabel myLabel = new JBComboBoxLabel();

            @Override
            public Component getTableCellRendererComponent(JTable table2, Object value2, boolean isSelected, boolean hasFocus, int row, int column) {
                VirtualFile file2 = EditLibraryDialog.this.myFileTableModel.getFileAt(row);
                if (file2 == null || file2.isDirectory()) {
                    this.myLabel.setText("");
                    this.myLabel.setIcon(null);
                } else {
                    this.myLabel.setText(String.valueOf(value2));
                    if (isSelected) {
                        this.myLabel.setSelectionIcon();
                    } else {
                        this.myLabel.setRegularIcon();
                    }
                }
                this.myLabel.setBackground(isSelected ? table2.getSelectionBackground() : table2.getBackground());
                this.myLabel.setForeground(isSelected ? table2.getSelectionForeground() : table2.getForeground());
                return this.myLabel;
            }
        });
        TableColumn fileCol = this.myFileTable.getColumnModel().getColumn(0);
        fileCol.setCellRenderer(new FileNameTableCellRenderer());
    }

    @NotNull
    private List<AnAction> getAddFilesActions() {
        ArrayList arrayList = ContainerUtil.newArrayList((Object[])new AnAction[]{new AnAction(WebCoreBundle.message((String)"edit.library.attach.files.popup.title", (Object[])new Object[0]), null, this.myFileIcon){

            public void actionPerformed(@NotNull AnActionEvent e2) {
                if (e2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/webcore/libraries/ui/EditLibraryDialog$11", "actionPerformed"));
                }
                EditLibraryDialog.this.addFiles();
            }
        }, new AnAction(WebCoreBundle.message((String)"edit.library.attach.directories.popup.title", (Object[])new Object[0]), null, this.myDirectoryIcon){

            public void actionPerformed(@NotNull AnActionEvent e2) {
                if (e2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/webcore/libraries/ui/EditLibraryDialog$12", "actionPerformed"));
                }
                EditLibraryDialog.this.addDirectory();
            }
        }});
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/webcore/libraries/ui/EditLibraryDialog", "getAddFilesActions"));
        }
        return arrayList;
    }

    public EditLibraryDialog(String title, LangScriptingContextProvider provider, Project project2, ScriptingLibraryModel lib) {
        this(title, provider, project2);
        this.myLibName.setText(lib.getName());
        this.myFileTableModel.setFiles(lib.getSourceFiles(), lib.getCompactFiles());
        Set docUrls = lib.getDocUrls();
        this.myDocUrlListModel.setDocUrls(docUrls);
        if (lib.getFrameworkDescriptor() != null) {
            this.setSelectedFramework(lib.getFrameworkDescriptor());
        }
        ButtonGroup buttonGroup2 = new ButtonGroup();
        buttonGroup2.add(this.myProjectRadioButton);
        buttonGroup2.add(this.myGlobalRadioButton);
        if (lib.getLibraryLevel() == ScriptingLibraryModel.LibraryLevel.GLOBAL) {
            this.myGlobalRadioButton.setSelected(true);
        } else {
            this.myProjectRadioButton.setSelected(true);
        }
        this.checkDownloadOfflineDocEnabled();
    }

    private void setSelectedFramework(ScriptingFrameworkDescriptor framework) {
        this.mySelectedFramework = framework;
        this.myVersionField.setText(framework.getFrameworkVersion());
        for (int i2 = 0; i2 < this.myFrameworkCombo.getItemCount(); ++i2) {
            Object item = this.myFrameworkCombo.getItemAt(i2);
            if (item == null || !(item instanceof ScriptingFrameworkDescriptor) || !framework.getFrameworkName().equals(((ScriptingFrameworkDescriptor)item).getFrameworkName())) continue;
            this.myFrameworkCombo.setSelectedItem(item);
        }
    }

    private void checkDownloadOfflineDocEnabled() {
        for (String url : this.getDocUrls()) {
            if (this.myProvider.getOfflineDocUrl(url) == null) continue;
            this.myDownloadButton.setEnabled(true);
            return;
        }
        this.myDownloadButton.setEnabled(false);
    }

    private void initFrameworkCombo() {
        ArrayList<String> items2 = new ArrayList<String>();
        ScriptingFrameworkDescriptor[] frameworks = this.myProvider.getSupportedFrameworks(this.myProject);
        items2.add(new String("<Custom>"));
        if (frameworks != null) {
            items2.addAll(Arrays.asList(frameworks));
        }
        DefaultComboBoxModel<Object> frameworkModel = new DefaultComboBoxModel<Object>(ArrayUtil.toObjectArray(items2));
        this.myFrameworkCombo.setModel(frameworkModel);
        this.myFrameworkCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                Object item = EditLibraryDialog.this.myFrameworkCombo.getSelectedItem();
                if (item instanceof ScriptingFrameworkDescriptor) {
                    String frameworkName = ((ScriptingFrameworkDescriptor)item).getFrameworkName();
                    if (EditLibraryDialog.this.mySelectedFramework == null || !frameworkName.equals(EditLibraryDialog.this.mySelectedFramework.getFrameworkName())) {
                        EditLibraryDialog.this.mySelectedFramework = new ScriptingFrameworkDescriptor(((ScriptingFrameworkDescriptor)item).getFrameworkName(), null);
                        EditLibraryDialog.this.myVersionField.setText("");
                    }
                } else {
                    EditLibraryDialog.this.mySelectedFramework = null;
                    EditLibraryDialog.this.myVersionField.setText("");
                }
            }
        });
    }

    private void downloadDocumentation() {
        LinkedHashSet urls = ContainerUtil.newLinkedHashSet();
        for (String url : this.getDocUrls()) {
            String offlineDocUrl = this.myProvider.getOfflineDocUrl(url);
            if (offlineDocUrl == null) continue;
            urls.add(offlineDocUrl);
        }
        this.processUrlQueue(ContainerUtil.newLinkedList((Iterable)urls), this.getRootPane());
    }

    private void processUrlQueue(@NotNull Queue<String> urls, @Nullable Component notificationAreaComponent) {
        if (urls == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "urls", "com/intellij/webcore/libraries/ui/EditLibraryDialog", "processUrlQueue"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        String url = urls.poll();
        if (url != null) {
            this.myProvider.downloadOfflineDoc(this.myProject, url, notificationAreaComponent, (Consumer<File>)((Consumer)ioFile -> {
                if (urls == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "urls", "com/intellij/webcore/libraries/ui/EditLibraryDialog", "lambda$processUrlQueue$2"));
                }
                AtomicBoolean processQueueFurther = new AtomicBoolean(true);
                if (ioFile != null) {
                    WriteAction.run(() -> {
                        VirtualFile file2 = VfsUtil.findFileByIoFile((File)ioFile, (boolean)true);
                        if (file2 != null) {
                            processQueueFurther.set(false);
                            this.myDocUrlListModel.addUrl(file2.getUrl());
                        }
                    });
                }
                if (processQueueFurther.get()) {
                    this.processUrlQueue(urls, notificationAreaComponent);
                }
            }));
        }
    }

    protected JComponent createCenterPanel() {
        return this.contentPane;
    }

    public String getLibName() {
        return this.myLibName.getText();
    }

    private void addFiles() {
        VirtualFile[] files2 = FileChooser.chooseFiles((FileChooserDescriptor)this.LIB_FILES_CHOOSER_DESCRIPTOR, (Project)this.myProject, null);
        if (files2.length == 0) {
            return;
        }
        VfsUtilCore.DistinctVFilesRootsCollection roots = new VfsUtilCore.DistinctVFilesRootsCollection(files2);
        ArrayList<VirtualFile> filesToAdd = new ArrayList<VirtualFile>();
        for (VirtualFile file2 : roots) {
            if (!file2.isValid()) continue;
            if (file2.isDirectory()) {
                this.addRecursively(file2, filesToAdd);
                continue;
            }
            filesToAdd.add(file2);
        }
        this.addVirtualFiles(filesToAdd);
    }

    private void addDirectory() {
        FileChooserDescriptor fileChooserDescriptor2 = FileChooserDescriptorFactory.createMultipleFoldersDescriptor();
        fileChooserDescriptor2.setTitle(WebCoreBundle.message((String)"edit.library.dialog.attach.directories.dialog.title", (Object[])new Object[0]));
        VirtualFile[] files2 = FileChooser.chooseFiles((FileChooserDescriptor)fileChooserDescriptor2, (Project)this.myProject, null);
        if (files2.length == 0) {
            return;
        }
        ArrayList<VirtualFile> filesToAdd = new ArrayList<VirtualFile>();
        for (VirtualFile file2 : files2) {
            if (!file2.isValid()) continue;
            filesToAdd.add(file2);
        }
        this.addVirtualFiles(filesToAdd);
    }

    private void addVirtualFiles(@NotNull List<VirtualFile> filesToAdd) {
        if (filesToAdd == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filesToAdd", "com/intellij/webcore/libraries/ui/EditLibraryDialog", "addVirtualFiles"));
        }
        Collections.sort(filesToAdd, FILES_COMPARATOR);
        int i2 = 0;
        for (VirtualFile file2 : filesToAdd) {
            this.addSingleFile(file2, i2++ == filesToAdd.size() - 1);
        }
        this.detectFramework();
        if (this.myLibName.getText().isEmpty() && !filesToAdd.isEmpty()) {
            this.myLibName.setText(filesToAdd.get(0).getName());
        }
    }

    private void addRecursively(VirtualFile dir, final Collection<VirtualFile> result2) {
        VfsUtilCore.visitChildrenRecursively((VirtualFile)dir, (VirtualFileVisitor)new VirtualFileVisitor(new VirtualFileVisitor.Option[0]){

            public boolean visitFile(@NotNull VirtualFile file2) {
                if (file2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/webcore/libraries/ui/EditLibraryDialog$14", "visitFile"));
                }
                if (file2.isValid() && !file2.isDirectory() && EditLibraryDialog.this.myProvider.acceptsExtension(file2.getExtension())) {
                    result2.add(file2);
                }
                return true;
            }
        });
    }

    private void addSingleFile(VirtualFile file2, boolean scrollToAdded) {
        int index = this.myFileTableModel.addFile(file2);
        this.myFileTable.setRowSelectionInterval(index, index);
        if (scrollToAdded) {
            TableUtil.scrollSelectionToVisible((JTable)this.myFileTable);
        }
    }

    private void removeSelected() {
        int[] rows = this.myFileTable.getSelectedRows();
        ArrayList<VirtualFile> filesToDelete = new ArrayList<VirtualFile>();
        for (int selectionRow : rows) {
            filesToDelete.add(this.myFileTableModel.getFileAt(selectionRow));
        }
        this.myFileTableModel.removeFiles(filesToDelete);
    }

    public VirtualFile[] getSourceFiles() {
        return this.myFileTableModel.getSourceFiles();
    }

    public VirtualFile[] getCompactFiles() {
        return this.myFileTableModel.getCompactFiles();
    }

    public String[] getDocUrls() {
        return this.myDocUrlListModel.getDocUrls();
    }

    protected void doOKAction() {
        if (!EditLibraryDialog.isLibNameValid(this.myLibName.getText())) {
            Messages.showErrorDialog((Project)this.myProject, (String)IdeBundle.message((String)"scripting.lib.invalid.name", (Object[])new Object[0]), (String)"Error");
            return;
        }
        super.doOKAction();
    }

    private static boolean isLibNameValid(String libName) {
        return libName != null && libName.matches("\\w[\\w\\d\\._\\-\\d ]*");
    }

    private void editDocUrl() {
        String oldUrl = (String)this.myDocUrlList.getSelectedValue();
        int index = this.myDocUrlList.getSelectedIndex();
        VirtualFile vf = Util.showSpecifyJavadocUrlDialog(this.contentPane, oldUrl);
        if (vf != null && vf.isValid()) {
            String url = vf.getUrl();
            this.myDocUrlListModel.replaceUrl(oldUrl, url);
            this.myDocUrlList.ensureIndexIsVisible(index);
            this.myDocUrlList.setSelectedIndex(index);
            this.checkDownloadOfflineDocEnabled();
        }
    }

    private void specifyDocUrl() {
        VirtualFile vf;
        String defaultUrl = null;
        if (this.mySelectedFramework == null) {
            this.detectFramework();
        }
        if (this.mySelectedFramework != null) {
            defaultUrl = this.findUnspecifiedMatchingDocUrl();
        }
        if ((vf = Util.showSpecifyJavadocUrlDialog(this.contentPane, defaultUrl != null ? defaultUrl : "")) != null && vf.isValid()) {
            String url = vf.getUrl();
            int index = this.myDocUrlListModel.addUrl(url);
            this.myDocUrlList.ensureIndexIsVisible(index);
            this.myDocUrlList.setSelectedIndex(index);
            this.checkDownloadOfflineDocEnabled();
        }
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myLibName;
    }

    @Nullable
    private String findUnspecifiedMatchingDocUrl() {
        String docUrl = this.myProvider.getDefaultDocUrl(this.mySelectedFramework);
        if (docUrl != null && !this.myDocUrlListModel.contains(docUrl)) {
            return docUrl;
        }
        return null;
    }

    private void removeDocUrl() {
        this.myDocUrlListModel.remove((String)this.myDocUrlList.getSelectedValue());
    }

    @Nullable
    public ScriptingFrameworkDescriptor getSelectedFramework() {
        return this.mySelectedFramework;
    }

    private void detectFramework() {
        ArrayList<VirtualFile> allFiles = new ArrayList<VirtualFile>();
        allFiles.addAll(Arrays.asList(this.myFileTableModel.getCompactFiles()));
        allFiles.addAll(Arrays.asList(this.myFileTableModel.getSourceFiles()));
        for (VirtualFile file2 : allFiles) {
            ScriptingFrameworkDescriptor framework = this.myProvider.detectFramework(file2);
            if (framework == null) continue;
            this.myVersionField.setText(framework.getFrameworkVersion());
            this.setSelectedFramework(framework);
            if (this.myLibName.getText().isEmpty()) {
                StringBuilder libName = new StringBuilder();
                libName.append(framework.getFrameworkName());
                if (framework.getFrameworkVersion() != null) {
                    libName.append(' ').append(framework.getFrameworkVersion());
                }
                this.myLibName.setText(libName.toString());
            }
            return;
        }
    }

    private void updateVersion() {
        if (this.mySelectedFramework != null) {
            this.mySelectedFramework.setFrameworkVersion(this.myVersionField.getText());
        }
    }

    @NotNull
    public ScriptingLibraryModel.LibraryLevel getLibraryLevel() {
        ScriptingLibraryModel.LibraryLevel libraryLevel = this.myGlobalRadioButton.isSelected() ? ScriptingLibraryModel.LibraryLevel.GLOBAL : ScriptingLibraryModel.LibraryLevel.PROJECT;
        if (libraryLevel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/webcore/libraries/ui/EditLibraryDialog", "getLibraryLevel"));
        }
        return libraryLevel;
    }

    static /* synthetic */ Comparator access$2400() {
        return FILES_COMPARATOR;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JPanel jPanel2;
        JRadioButton jRadioButton;
        JRadioButton jRadioButton2;
        JTextField jTextField;
        JComboBox jComboBox;
        JTextField jTextField2;
        JPanel jPanel3;
        this.contentPane = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(3, 5, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel4, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 0, null, null, null));
        this.myLibName = jTextField2 = new JTextField();
        jPanel4.add((Component)jTextField2, new GridConstraints(0, 1, 1, 4, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messages/IdeBundle").getString("scripting.lib.name"));
        jPanel4.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Framework type:");
        jLabel2.setDisplayedMnemonic('F');
        jLabel2.setDisplayedMnemonicIndex(0);
        jPanel4.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myFrameworkCombo = jComboBox = new JComboBox();
        jPanel4.add(jComboBox, new GridConstraints(1, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        JLabel jLabel3 = new JLabel();
        jLabel3.setText("Version:");
        jLabel3.setDisplayedMnemonic('V');
        jLabel3.setDisplayedMnemonicIndex(0);
        jPanel4.add((Component)jLabel3, new GridConstraints(1, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myVersionField = jTextField = new JTextField();
        jPanel4.add((Component)jTextField, new GridConstraints(1, 3, 1, 1, 8, 1, 6, 0, null, new Dimension(55, -1), new Dimension(55, -1)));
        JLabel jLabel4 = new JLabel();
        jLabel4.setText("Visibility:");
        jPanel4.add((Component)jLabel4, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel5, new GridConstraints(2, 1, 1, 4, 0, 3, 3, 3, null, null, null));
        this.myProjectRadioButton = jRadioButton2 = new JRadioButton();
        jRadioButton2.setSelected(true);
        jRadioButton2.setText("Project");
        jRadioButton2.setMnemonic('P');
        jRadioButton2.setDisplayedMnemonicIndex(0);
        jPanel5.add((Component)jRadioButton2, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myGlobalRadioButton = jRadioButton = new JRadioButton();
        jRadioButton.setText("Global");
        jRadioButton.setMnemonic('G');
        jRadioButton.setDisplayedMnemonicIndex(0);
        jPanel5.add((Component)jRadioButton, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel5.add((Component)spacer, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel4.add((Component)spacer2, new GridConstraints(1, 4, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myFilesPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel2.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel3.add((Component)jPanel2, new GridConstraints(1, 0, 1, 1, 0, 3, 2, 7, null, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel6.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel3.add((Component)jPanel6, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 2, null, null, null));
        jPanel6.setBorder(IdeBorderFactory.PlainSmallWithoutIndent.createTitledBorder(null, (String)ResourceBundle.getBundle("messages/IdeBundle").getString("scripting.lib.docUrl.title"), (int)0, (int)0, null, null));
        this.myUrlsPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel6.add((Component)jPanel, new GridConstraints(0, 0, 1, 1, 0, 3, 7, 3, null, null, null));
        jLabel.setLabelFor(jTextField2);
        jLabel2.setLabelFor(jComboBox);
        jLabel3.setLabelFor(jTextField);
        ButtonGroup buttonGroup2 = new ButtonGroup();
        buttonGroup2.add(jRadioButton2);
        buttonGroup2.add(jRadioButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.contentPane;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c2 = '\u0000';
        int n2 = -1;
        for (int i2 = 0; i2 < string2.length(); ++i2) {
            if (string2.charAt(i2) == '&') {
                if (++i2 == string2.length()) break;
                if (!bl && string2.charAt(i2) != '&') {
                    bl = true;
                    c2 = string2.charAt(i2);
                    n2 = stringBuffer.length();
                }
            }
            stringBuffer.append(string2.charAt(i2));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c2);
            jLabel.setDisplayedMnemonicIndex(n2);
        }
    }

    private static class MyDocUrlListModel
    extends AbstractListModel {
        private ArrayList<String> myDocUrls = new ArrayList();

        private MyDocUrlListModel() {
        }

        public void setDocUrls(Set<String> urls) {
            if (urls != null && urls.size() > 0) {
                this.myDocUrls.addAll(urls);
            }
        }

        @Override
        public int getSize() {
            return this.myDocUrls.size();
        }

        @Override
        public Object getElementAt(int index) {
            return this.myDocUrls.get(index);
        }

        public int addUrl(String url) {
            if (!this.myDocUrls.contains(url)) {
                this.myDocUrls.add(url);
                int newIndex = this.myDocUrls.indexOf(url);
                this.fireIntervalAdded(this, newIndex, newIndex);
                return newIndex;
            }
            return this.myDocUrls.indexOf(url);
        }

        public void replaceUrl(String oldUrl, String newUrl) {
            if (oldUrl == null || !this.myDocUrls.contains(oldUrl)) {
                return;
            }
            int index = this.myDocUrls.indexOf(oldUrl);
            this.myDocUrls.remove(oldUrl);
            this.myDocUrls.add(index, newUrl);
        }

        public int indexOf(String url) {
            return this.myDocUrls.indexOf(url);
        }

        public void remove(String url) {
            if (url == null || !this.myDocUrls.contains(url)) {
                return;
            }
            int index = this.myDocUrls.indexOf(url);
            this.myDocUrls.remove(url);
            this.fireIntervalRemoved(this, index, index);
        }

        public boolean contains(String url) {
            return this.myDocUrls.contains(url);
        }

        public String[] getDocUrls() {
            return ArrayUtil.toStringArray(this.myDocUrls);
        }
    }

    private class FileTableModel
    extends AbstractTableModel {
        private SortedList<VirtualFile> myFiles = new SortedList(EditLibraryDialog.access$2400());
        private HashSet<VirtualFile> myCompactFiles = new HashSet();

        private FileTableModel() {
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return IdeBundle.message((String)"scripting.lib.file.name", (Object[])new Object[0]);
                }
                case 1: {
                    return IdeBundle.message((String)"scripting.lib.file.type", (Object[])new Object[0]);
                }
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            VirtualFile file2;
            return columnIndex == 1 && (file2 = this.getFileAt(rowIndex)) != null && !file2.isDirectory();
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            VirtualFile file2;
            if (columnIndex == 1 && (file2 = EditLibraryDialog.this.myFileTableModel.getFileAt(rowIndex)) != null) {
                this.setFileType(file2, EditLibraryDialog.this.myCompactTypeName.equals(aValue));
            }
        }

        public int addFile(VirtualFile file2) {
            this.myFiles.add((Object)file2);
            if (!file2.isDirectory() && EditLibraryDialog.this.myProvider.isCompact(file2)) {
                this.myCompactFiles.add((Object)file2);
            }
            this.fireTableDataChanged();
            return this.myFiles.indexOf((Object)file2);
        }

        public void setFiles(Set<VirtualFile> sourceFiles, Set<VirtualFile> compactFiles) {
            this.myFiles.clear();
            this.myFiles.addAll(sourceFiles);
            this.myFiles.addAll(compactFiles);
            for (VirtualFile file2 : sourceFiles) {
                this.setFileType(file2, false, false);
            }
            for (VirtualFile file2 : compactFiles) {
                this.setFileType(file2, true, false);
            }
        }

        private void setFileType(VirtualFile file2, boolean isCompact) {
            this.setFileType(file2, isCompact, true);
        }

        private void setFileType(VirtualFile file2, boolean isCompact, boolean fireTableDataChangedEvent) {
            boolean changed = false;
            if (isCompact && !file2.isDirectory()) {
                if (!this.myCompactFiles.contains((Object)file2)) {
                    this.myCompactFiles.add((Object)file2);
                    changed = true;
                }
            } else if (this.myCompactFiles.contains((Object)file2)) {
                this.myCompactFiles.remove((Object)file2);
                changed = true;
            }
            if (changed && fireTableDataChangedEvent) {
                this.fireTableDataChanged();
            }
        }

        @Override
        public int getRowCount() {
            return this.myFiles.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            VirtualFile file2 = (VirtualFile)this.myFiles.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return file2.getPresentableName();
                }
                case 1: {
                    return this.myCompactFiles.contains((Object)file2) ? EditLibraryDialog.this.myCompactTypeName : EditLibraryDialog.this.mySourceTypeName;
                }
            }
            return "";
        }

        @Nullable
        public VirtualFile getFileAt(int row) {
            if (row < 0 || row >= this.myFiles.size()) {
                return null;
            }
            return (VirtualFile)this.myFiles.get(row);
        }

        public void removeFile(VirtualFile file2) {
            if (this.myFiles.remove((Object)file2)) {
                this.fireTableDataChanged();
            }
        }

        public void removeFiles(List<VirtualFile> files2) {
            if (this.myFiles.removeAll(files2)) {
                this.fireTableDataChanged();
            }
        }

        private VirtualFile[] getFiles(boolean isCompact) {
            ArrayList<VirtualFile> files2 = new ArrayList<VirtualFile>();
            for (VirtualFile file2 : this.myFiles) {
                if (this.myCompactFiles.contains((Object)file2) != isCompact) continue;
                files2.add(file2);
            }
            return files2.toArray(new VirtualFile[files2.size()]);
        }

        public VirtualFile[] getCompactFiles() {
            return this.getFiles(true);
        }

        private VirtualFile[] getSourceFiles() {
            return this.getFiles(false);
        }
    }

    private class TypeCellEditor
    extends AbstractTableCellEditor {
        private final JBComboBoxTableCellEditorComponent myEditorComponent = new JBComboBoxTableCellEditorComponent();

        public TypeCellEditor() {
            this.myEditorComponent.setOptions(new Object[]{EditLibraryDialog.this.mySourceTypeName, EditLibraryDialog.this.myCompactTypeName});
            this.myEditorComponent.setToString(o2 -> (String)o2);
        }

        public Object getCellEditorValue() {
            return this.myEditorComponent.getEditorValue();
        }

        public Component getTableCellEditorComponent(JTable table2, Object value2, boolean isSelected, int row, int column) {
            VirtualFile file2 = EditLibraryDialog.this.myFileTableModel.getFileAt(row);
            this.myEditorComponent.setCell(table2, row, column);
            if (file2 != null) {
                Object colValue = EditLibraryDialog.this.myFileTableModel.getValueAt(row, 1);
                this.myEditorComponent.setDefaultValue(colValue);
            }
            return this.myEditorComponent;
        }
    }

    private class FileNameTableCellRenderer
    extends DefaultTableCellRenderer {
        private FileNameTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table2, Object value2, boolean isSelected, boolean hasFocus, int row, int column) {
            Component renderer = super.getTableCellRendererComponent(table2, value2, isSelected, hasFocus, row, column);
            if (renderer instanceof JLabel) {
                JLabel label = (JLabel)renderer;
                VirtualFile file2 = EditLibraryDialog.this.myFileTableModel.getFileAt(row);
                if (file2 != null) {
                    label.setToolTipText(file2.getPresentableUrl());
                    label.setIcon(file2.isDirectory() ? EditLibraryDialog.this.myDirectoryIcon : EditLibraryDialog.this.myFileIcon);
                }
                label.setBorder(null);
            }
            return renderer;
        }
    }
}

