/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webcore.libraries.ui;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ui.JBUI;
import com.intellij.webcore.libraries.ui.ModuleScopeSelectionView;
import java.awt.Dimension;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModuleScopeSelectionDialog
extends DialogWrapper {
    private final ModuleScopeSelectionView myView;

    public ModuleScopeSelectionDialog(@NotNull Project project2, @Nullable Set<Module> selectedModules, @Nullable VirtualFile requestor, @NotNull String libraryName) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/webcore/libraries/ui/ModuleScopeSelectionDialog", "<init>"));
        }
        if (libraryName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraryName", "com/intellij/webcore/libraries/ui/ModuleScopeSelectionDialog", "<init>"));
        }
        this(project2, libraryName, ModuleScopeSelectionDialog.createView(project2, requestor, selectedModules));
    }

    public ModuleScopeSelectionDialog(@NotNull Project project2, @NotNull String libraryName, @NotNull ModuleScopeSelectionView view2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/webcore/libraries/ui/ModuleScopeSelectionDialog", "<init>"));
        }
        if (libraryName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraryName", "com/intellij/webcore/libraries/ui/ModuleScopeSelectionDialog", "<init>"));
        }
        if (view2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "view", "com/intellij/webcore/libraries/ui/ModuleScopeSelectionDialog", "<init>"));
        }
        super(project2, false);
        this.myView = view2;
        this.setTitle("Choose Modules for " + libraryName);
        view2.getComponent().setPreferredSize(new Dimension(JBUI.scale((int)350), JBUI.scale((int)400)));
        this.init();
    }

    @NotNull
    private static ModuleScopeSelectionView createView(@NotNull Project project2, @Nullable VirtualFile requestor, @Nullable Set<Module> selectedModules) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/webcore/libraries/ui/ModuleScopeSelectionDialog", "createView"));
        }
        ModuleScopeSelectionView view2 = new ModuleScopeSelectionView(project2, requestor, true, false);
        if (selectedModules != null) {
            view2.setSelectedModules(selectedModules);
        }
        ModuleScopeSelectionView moduleScopeSelectionView = view2;
        if (moduleScopeSelectionView == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/webcore/libraries/ui/ModuleScopeSelectionDialog", "createView"));
        }
        return moduleScopeSelectionView;
    }

    @NotNull
    public ModuleScopeSelectionView getView() {
        ModuleScopeSelectionView moduleScopeSelectionView = this.myView;
        if (moduleScopeSelectionView == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/webcore/libraries/ui/ModuleScopeSelectionDialog", "getView"));
        }
        return moduleScopeSelectionView;
    }

    protected JComponent createCenterPanel() {
        return this.myView.getComponent();
    }

    @NotNull
    public Set<Module> getSelectedModules() {
        HashSet<Module> hashSet = new HashSet<Module>(this.myView.getSelectedModules());
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/webcore/libraries/ui/ModuleScopeSelectionDialog", "getSelectedModules"));
        }
        return hashSet;
    }
}

