/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webcore.libraries.ui;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.WebModuleTypeBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.CheckBoxList;
import com.intellij.ui.ListSpeedSearch;
import com.intellij.ui.OptionalChooserComponent;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.SwingHelper;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModuleScopeSelectionView {
    private static final String KEY_SHOW_WEB_MODULE_ONLY = ModuleScopeSelectionView.class.getName() + "#SHOW_WEB_MODULE_ONLY";
    private final JComponent myComponent;
    private final OptionalChooserComponent<Module> myMultiModulesChooser;
    private final Module myAssociateWithProjectModule;
    private final JCheckBox myAssociateWithProjectCheckBox;

    public ModuleScopeSelectionView(@NotNull Project project2, @Nullable VirtualFile requestor, boolean allowAssociationWithProject, boolean withHeaderLabel) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/webcore/libraries/ui/ModuleScopeSelectionView", "<init>"));
        }
        List<Module> allModules = ModuleScopeSelectionView.getAllModules(project2);
        if (allowAssociationWithProject && allModules.size() == 1 && ModuleScopeSelectionView.isWebModule(allModules.get(0))) {
            this.myAssociateWithProjectModule = allModules.get(0);
            this.myAssociateWithProjectCheckBox = ModuleScopeSelectionView.createSingleWebModuleComponent();
            this.myComponent = this.myAssociateWithProjectCheckBox;
            this.myMultiModulesChooser = null;
            return;
        }
        this.myAssociateWithProjectModule = null;
        this.myAssociateWithProjectCheckBox = null;
        Module requestingModule = ModuleScopeSelectionView.findRequestingModule(project2, requestor, allModules);
        Pair<OptionalChooserComponent<Module>, JComponent> result2 = ModuleScopeSelectionView.createMultiModulesComponent(allModules, requestingModule, withHeaderLabel);
        this.myMultiModulesChooser = (OptionalChooserComponent)result2.getFirst();
        this.myComponent = (JComponent)result2.getSecond();
    }

    @NotNull
    private static List<Module> getAllModules(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/webcore/libraries/ui/ModuleScopeSelectionView", "getAllModules"));
        }
        List list2 = (List)ReadAction.compute(() -> {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/webcore/libraries/ui/ModuleScopeSelectionView", "lambda$getAllModules$0"));
            }
            Module[] modules = ModuleManager.getInstance((Project)project2).getModules();
            Arrays.sort(modules, Comparator.comparing(Module::getName));
            return Arrays.asList(modules);
        });
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/webcore/libraries/ui/ModuleScopeSelectionView", "getAllModules"));
        }
        return list2;
    }

    @Nullable
    private static Module findRequestingModule(@NotNull Project project2, @Nullable VirtualFile requestor, @NotNull List<Module> allModules) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/webcore/libraries/ui/ModuleScopeSelectionView", "findRequestingModule"));
        }
        if (allModules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allModules", "com/intellij/webcore/libraries/ui/ModuleScopeSelectionView", "findRequestingModule"));
        }
        if (requestor == null || !requestor.isValid()) {
            return null;
        }
        ProjectFileIndex fileIndex = ProjectFileIndex.getInstance((Project)project2);
        Module module2 = fileIndex.getModuleForFile(requestor);
        return module2 != null && allModules.contains(module2) ? module2 : null;
    }

    @NotNull
    public JComponent getComponent() {
        JComponent jComponent = this.myComponent;
        if (jComponent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/webcore/libraries/ui/ModuleScopeSelectionView", "getComponent"));
        }
        return jComponent;
    }

    public boolean isAssociateWithProjectView() {
        return this.myAssociateWithProjectCheckBox != null;
    }

    public boolean isAssociateWithProjectRequested() {
        return this.myAssociateWithProjectCheckBox != null && this.myAssociateWithProjectCheckBox.isSelected();
    }

    @NotNull
    public List<Module> getSelectedModules() {
        if (this.myAssociateWithProjectCheckBox != null) {
            List<Module> list2 = this.myAssociateWithProjectCheckBox.isSelected() ? Collections.singletonList(this.myAssociateWithProjectModule) : Collections.emptyList();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/webcore/libraries/ui/ModuleScopeSelectionView", "getSelectedModules"));
            }
            return list2;
        }
        List<Module> list3 = ModuleScopeSelectionView.getSelectedMultiModules(this.myMultiModulesChooser);
        if (list3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/webcore/libraries/ui/ModuleScopeSelectionView", "getSelectedModules"));
        }
        return list3;
    }

    @NotNull
    private static List<Module> getSelectedMultiModules(@NotNull OptionalChooserComponent<Module> chooser) {
        if (chooser == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chooser", "com/intellij/webcore/libraries/ui/ModuleScopeSelectionView", "getSelectedMultiModules"));
        }
        List list2 = ContainerUtil.mapNotNull((Collection)chooser.getCurrentModel(), pair -> (Boolean)pair.getSecond() != false ? (Module)pair.getFirst() : null);
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/webcore/libraries/ui/ModuleScopeSelectionView", "getSelectedMultiModules"));
        }
        return list2;
    }

    public void setSelectedModules(@NotNull Set<Module> selectedModules) {
        if (selectedModules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectedModules", "com/intellij/webcore/libraries/ui/ModuleScopeSelectionView", "setSelectedModules"));
        }
        if (this.myAssociateWithProjectModule != null) {
            this.myAssociateWithProjectCheckBox.setSelected(selectedModules.contains(this.myAssociateWithProjectModule));
        } else {
            ModuleScopeSelectionView.setSelectedMultiModules(this.myMultiModulesChooser, selectedModules);
        }
    }

    private static void setSelectedMultiModules(@NotNull OptionalChooserComponent<Module> chooser, @NotNull Set<Module> selectedModules) {
        if (chooser == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chooser", "com/intellij/webcore/libraries/ui/ModuleScopeSelectionView", "setSelectedMultiModules"));
        }
        if (selectedModules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectedModules", "com/intellij/webcore/libraries/ui/ModuleScopeSelectionView", "setSelectedMultiModules"));
        }
        List newModel = ContainerUtil.mapNotNull((Collection)chooser.getCurrentModel(), pair -> {
            if (selectedModules == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectedModules", "com/intellij/webcore/libraries/ui/ModuleScopeSelectionView", "lambda$setSelectedMultiModules$2"));
            }
            return Pair.create((Object)pair.first, (Object)selectedModules.contains(pair.first));
        });
        chooser.setInitialList(newModel);
        chooser.reset();
    }

    private static void setMultiModules(@NotNull OptionalChooserComponent<Module> chooser, @NotNull List<Module> modules) {
        if (chooser == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chooser", "com/intellij/webcore/libraries/ui/ModuleScopeSelectionView", "setMultiModules"));
        }
        if (modules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modules", "com/intellij/webcore/libraries/ui/ModuleScopeSelectionView", "setMultiModules"));
        }
        HashSet<Module> selected = new HashSet<Module>(ModuleScopeSelectionView.getSelectedMultiModules(chooser));
        ArrayList<Pair> pairs = new ArrayList<Pair>();
        for (Module module2 : modules) {
            pairs.add(Pair.create((Object)module2, (Object)selected.contains(module2)));
        }
        chooser.setInitialList(pairs);
        chooser.reset();
    }

    @NotNull
    private static JCheckBox createSingleWebModuleComponent() {
        JCheckBox associateWithProject = new JCheckBox("For the whole project");
        associateWithProject.setSelected(true);
        JCheckBox jCheckBox = associateWithProject;
        if (jCheckBox == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/webcore/libraries/ui/ModuleScopeSelectionView", "createSingleWebModuleComponent"));
        }
        return jCheckBox;
    }

    @NotNull
    private static Pair<OptionalChooserComponent<Module>, JComponent> createMultiModulesComponent(@NotNull List<Module> allModules, @Nullable Module requestingModule, boolean withHeaderLabel) {
        if (allModules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allModules", "com/intellij/webcore/libraries/ui/ModuleScopeSelectionView", "createMultiModulesComponent"));
        }
        OptionalChooserComponent<Module> chooser = new OptionalChooserComponent<Module>(Collections.emptyList()){

            protected JCheckBox createCheckBox(Module value2, boolean checked) {
                JBCheckBox checkBox2 = new JBCheckBox(value2.getName(), checked);
                ModuleType moduleType = ModuleType.get((Module)value2);
                Icon moduleIcon = moduleType.getIcon();
                if (moduleIcon != null) {
                    checkBox2.setTextIcon(moduleIcon);
                }
                return checkBox2;
            }
        };
        CheckBoxList checkboxList = chooser.getList();
        checkboxList.setSelectionMode(2);
        checkboxList.setVisibleRowCount(Math.min(6, allModules.size()));
        new ListSpeedSearch((JList)checkboxList, (Function<Object, String>)((Function)o2 -> {
            JCheckBox checkbox = (JCheckBox)o2;
            return checkbox.getText();
        }));
        chooser.getEmptyText().setText("No modules found");
        ArrayList components = ContainerUtil.newArrayList();
        if (withHeaderLabel) {
            components.add(new JLabel("Select modules:"));
            components.add(Box.createVerticalStrut(JBUI.scale((int)4)));
        }
        components.add(chooser.getContentPane());
        boolean showWebModulesOnly = false;
        List<Module> webModules = ContainerUtil.filter(allModules, module2 -> ModuleScopeSelectionView.isWebModule(module2));
        if (webModules.size() < allModules.size() && webModules.size() > 0) {
            final PropertiesComponent propertiesComponent = PropertiesComponent.getInstance();
            showWebModulesOnly = propertiesComponent.getBoolean(KEY_SHOW_WEB_MODULE_ONLY);
            if (showWebModulesOnly && requestingModule != null) {
                showWebModulesOnly = ModuleScopeSelectionView.isWebModule(requestingModule);
            }
            final JCheckBox showWebModulesOnlyCheckbox = new JCheckBox("Show Web modules only", showWebModulesOnly);
            components.add(Box.createVerticalStrut(JBUI.scale((int)4)));
            components.add(showWebModulesOnlyCheckbox);
            showWebModulesOnlyCheckbox.addActionListener(new ActionListener((OptionalChooserComponent)chooser, webModules, allModules){
                final /* synthetic */ OptionalChooserComponent val$chooser;
                final /* synthetic */ List val$webModules;
                final /* synthetic */ List val$allModules;
                {
                    this.val$chooser = optionalChooserComponent;
                    this.val$webModules = list2;
                    this.val$allModules = list3;
                }

                @Override
                public void actionPerformed(ActionEvent e2) {
                    boolean showWebModulesOnly = showWebModulesOnlyCheckbox.isSelected();
                    propertiesComponent.setValue(KEY_SHOW_WEB_MODULE_ONLY, showWebModulesOnly);
                    ModuleScopeSelectionView.setMultiModules((OptionalChooserComponent<Module>)this.val$chooser, showWebModulesOnly ? this.val$webModules : this.val$allModules);
                }
            });
        }
        ModuleScopeSelectionView.setMultiModules(chooser, showWebModulesOnly ? webModules : allModules);
        if (requestingModule != null) {
            ModuleScopeSelectionView.setSelectedMultiModules(chooser, Collections.singleton(requestingModule));
        } else if (showWebModulesOnly) {
            ModuleScopeSelectionView.setSelectedMultiModules(chooser, new HashSet<Module>(webModules));
        }
        Pair pair = Pair.create((Object)chooser, (Object)SwingHelper.newLeftAlignedVerticalPanel(components));
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/webcore/libraries/ui/ModuleScopeSelectionView", "createMultiModulesComponent"));
        }
        return pair;
    }

    private static boolean isWebModule(@NotNull Module module2) {
        if (module2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/webcore/libraries/ui/ModuleScopeSelectionView", "isWebModule"));
        }
        return WebModuleTypeBase.isWebModule(module2);
    }

    @NotNull
    public List<VirtualFile> getLibraryScope() {
        if (this.isAssociateWithProjectView()) {
            List<Object> list2 = this.isAssociateWithProjectRequested() ? Collections.singletonList(null) : Collections.emptyList();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/webcore/libraries/ui/ModuleScopeSelectionView", "getLibraryScope"));
            }
            return list2;
        }
        List list3 = (List)ReadAction.compute(() -> {
            HashSet result2 = ContainerUtil.newHashSet();
            for (Module module2 : this.getSelectedModules()) {
                ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module2);
                VirtualFile[] roots = moduleRootManager.getContentRoots();
                Collections.addAll(result2, roots);
            }
            return ContainerUtil.newArrayList((Iterable)result2);
        });
        if (list3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/webcore/libraries/ui/ModuleScopeSelectionView", "getLibraryScope"));
        }
        return list3;
    }
}

