/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webcore.libraries.ui;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.tree.PerFileConfigurableBase;
import com.intellij.webcore.libraries.ScriptingLibraryMappings;
import com.intellij.webcore.libraries.ScriptingLibraryModel;
import com.intellij.webcore.libraries.ui.ScriptingLibraryIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScriptingContextsConfigurable
extends PerFileConfigurableBase<ScriptingLibraryModel> {
    public ScriptingContextsConfigurable(Project project2, ScriptingLibraryMappings mappings) {
        super(project2, mappings);
    }

    public String getDisplayName() {
        return IdeBundle.message((String)"scripting.lib.usageScope", (Object[])new Object[0]);
    }

    public String getHelpTopic() {
        return null;
    }

    @Override
    protected <S> Object getParameter(@NotNull Key<S> key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/webcore/libraries/ui/ScriptingContextsConfigurable", "getParameter"));
        }
        if (key == DESCRIPTION) {
            return IdeBundle.message((String)"scripting.lib.usageScope.caption", (Object[])new Object[0]);
        }
        if (key == MAPPING_TITLE) {
            return IdeBundle.message((String)"scripting.lib.usageScope.tableTitle", (Object[])new Object[0]);
        }
        if (key == OVERRIDE_QUESTION) {
            return IdeBundle.message((String)"scripting.lib.usageScope.override.question", (Object[])new Object[0]);
        }
        if (key == OVERRIDE_TITLE) {
            return IdeBundle.message((String)"scripting.lib.usageScope.override.title", (Object[])new Object[0]);
        }
        return null;
    }

    @Override
    @Nullable
    protected Icon getActionListIcon(Object target, ScriptingLibraryModel libraryModel) {
        ScriptingLibraryModel currValue;
        ScriptingLibraryModel scriptingLibraryModel = currValue = target instanceof VirtualFile ? (ScriptingLibraryModel)this.getNewMapping((VirtualFile)target) : null;
        if (libraryModel == null) {
            return ScriptingLibraryIcons.CLEAR_ICON;
        }
        if (currValue instanceof ScriptingLibraryMappings.CompoundLibrary && ((ScriptingLibraryMappings.CompoundLibrary)currValue).containsLibrary(libraryModel.getName())) {
            return ScriptingLibraryIcons.CHECKED_ICON;
        }
        return ScriptingLibraryIcons.UNCHECKED_ICON;
    }

    @Override
    @NotNull
    protected Collection<ScriptingLibraryModel> getValueVariants(@Nullable Object target) {
        Collection variants = ((ScriptingLibraryMappings)this.myMappings).getValueVariants((VirtualFile)target);
        ArrayList list2 = ContainerUtil.newArrayList((Iterable)variants);
        Iterator it = list2.iterator();
        while (it.hasNext()) {
            if (!(it.next() instanceof ScriptingLibraryMappings.CompoundLibrary)) continue;
            it.remove();
        }
        ArrayList arrayList = list2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/webcore/libraries/ui/ScriptingContextsConfigurable", "getValueVariants"));
        }
        return arrayList;
    }

    @Override
    protected void renderValue(@Nullable Object target, @NotNull ScriptingLibraryModel library, @NotNull ColoredTextContainer renderer) {
        if (library == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "com/intellij/webcore/libraries/ui/ScriptingContextsConfigurable", "renderValue"));
        }
        if (renderer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renderer", "com/intellij/webcore/libraries/ui/ScriptingContextsConfigurable", "renderValue"));
        }
        renderer.append(library.getName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
    }

    @Override
    public boolean isModified() {
        if (super.isModified()) {
            return true;
        }
        Map libMappings = this.myMappings.getMappings();
        for (ScriptingLibraryModel libraryModel : libMappings.values()) {
            if (!(libraryModel instanceof ScriptingLibraryMappings.CompoundLibrary) || !((ScriptingLibraryMappings.CompoundLibrary)libraryModel).isModified()) continue;
            return true;
        }
        return false;
    }

    @Override
    protected ScriptingLibraryModel adjustChosenValue(@Nullable Object target, ScriptingLibraryModel chosen) {
        return ((ScriptingLibraryMappings)this.myMappings).adjustChosenValue((VirtualFile)target, chosen);
    }
}

