/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webcore.libraries.ui;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.table.JBTable;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.webcore.libraries.LangScriptingContextProvider;
import com.intellij.webcore.libraries.ScriptingLibraryManager;
import com.intellij.webcore.libraries.ScriptingLibraryModel;
import com.intellij.webcore.libraries.ui.EditLibraryDialog;
import com.intellij.webcore.libraries.ui.ScriptingLibrariesPanelStub;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ScriptingLibrariesPanel
extends ScriptingLibrariesPanelStub {
    private JPanel myTopPanel;
    private JButton myAddLibraryButton;
    private JButton myRemoveLibraryButton;
    private JButton myEditLibraryButton;
    private JPanel myScriptingLibrariesPanel;
    private JBTable myLibraryTable;
    private JButton myDownloadButton;
    private JButton myManageScopesButton;

    public ScriptingLibrariesPanel(LangScriptingContextProvider provider, Project project2, ScriptingLibraryManager libraryManager) {
        super(project2, provider, libraryManager);
        this.$$$setupUI$$$();
        this.myAddLibraryButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                ScriptingLibraryModel createdLib = ScriptingLibrariesPanel.this.addLibrary();
                if (createdLib != null) {
                    ScriptingLibrariesPanel.this.selectLibrary(createdLib.getName());
                }
            }
        });
        this.myRemoveLibraryButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                int[] selectedRows = ScriptingLibrariesPanel.this.myLibraryTable.getSelectedRows();
                ArrayList librariesToRemove = ContainerUtil.newArrayList();
                for (int i2 = 0; i2 < selectedRows.length; ++i2) {
                    ScriptingLibraryModel library = ScriptingLibrariesPanel.this.myLibTableModel.getLibraryAt(selectedRows[i2]);
                    if (library == null || library.isPredefined()) continue;
                    librariesToRemove.add(library);
                }
                for (ScriptingLibraryModel library : librariesToRemove) {
                    ScriptingLibrariesPanel.this.removeLibrary(library.getName());
                }
            }
        });
        this.myEditLibraryButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                String libName = ScriptingLibrariesPanel.this.myLibTableModel.getLibNameAt(ScriptingLibrariesPanel.this.myLibraryTable.getSelectedRow());
                ScriptingLibrariesPanel.this.editLibrary(libName);
            }
        });
        this.myRemoveLibraryButton.setEnabled(false);
        this.myEditLibraryButton.setEnabled(false);
        this.myLibraryTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e2) {
                ScriptingLibrariesPanel.this.onSelectionChange();
            }
        });
        this.myLibraryTable.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e2) {
                ScriptingLibraryModel library;
                int row;
                if (e2.getClickCount() == 2 && (row = ScriptingLibrariesPanel.this.myLibraryTable.getSelectedRow()) != -1 && (library = ScriptingLibrariesPanel.this.myLibTableModel.getLibraryAt(ScriptingLibrariesPanel.this.myLibraryTable.getSelectedRow())) != null && !library.isPredefined()) {
                    ScriptingLibrariesPanel.this.editLibrary(library.getName());
                }
            }
        });
    }

    @Override
    public JPanel getPanel() {
        return this.myTopPanel;
    }

    private void createUIComponents() {
        this.myLibraryTable = ((ScriptingLibrariesPanelStub)this).myLibraryTable;
        this.myManageScopesButton = ((ScriptingLibrariesPanelStub)this).myManageScopesButton;
        this.myDownloadButton = ((ScriptingLibrariesPanelStub)this).myDownloadButton;
    }

    private void removeLibrary(String libName) {
        ApplicationManager.getApplication().runWriteAction(() -> this.myLibTableModel.removeLibrary(libName));
    }

    private ScriptingLibraryModel addLibrary() {
        EditLibraryDialog editLibDialog = new EditLibraryDialog("New Library", this.myProvider, this.myProject);
        if (editLibDialog.showAndGet()) {
            ScriptingLibraryModel newLib = this.myLibTableModel.createLibrary(editLibDialog.getLibName(), editLibDialog.getSourceFiles(), editLibDialog.getCompactFiles(), editLibDialog.getDocUrls(), editLibDialog.getLibraryLevel(), false);
            newLib.setFrameworkDescriptor(editLibDialog.getSelectedFramework());
            return newLib;
        }
        return null;
    }

    private void onSelectionChange() {
        int[] selectedRows;
        boolean isEditable;
        int selectedRowsCount = this.myLibraryTable.getSelectedRowCount();
        boolean bl = isEditable = selectedRowsCount == 1;
        if (isEditable) {
            ScriptingLibraryModel library = this.myLibTableModel.getLibraryAt(this.myLibraryTable.getSelectedRow());
            isEditable = library != null && !library.isPredefined();
        }
        this.myEditLibraryButton.setEnabled(isEditable);
        boolean isRemovable = selectedRowsCount > 0;
        for (int row : selectedRows = this.myLibraryTable.getSelectedRows()) {
            ScriptingLibraryModel library = this.myLibTableModel.getLibraryAt(row);
            if (library == null || !library.isPredefined()) continue;
            isRemovable = false;
            break;
        }
        this.myRemoveLibraryButton.setEnabled(isRemovable);
    }

    private void editLibrary(String libName) {
        ScriptingLibraryModel changedLib;
        EditLibraryDialog editLibDialog;
        if (libName == null) {
            return;
        }
        ScriptingLibraryModel lib = this.myLibTableModel.getLibrary(libName);
        if (lib != null && (editLibDialog = new EditLibraryDialog("Edit Library", this.myProvider, this.myProject, lib)).showAndGet() && (changedLib = this.myLibTableModel.updateLibrary(libName, editLibDialog.getLibName(), editLibDialog.getSourceFiles(), editLibDialog.getCompactFiles(), editLibDialog.getDocUrls())) != null) {
            changedLib.setFrameworkDescriptor(editLibDialog.getSelectedFramework());
            changedLib.setLibraryLevel(editLibDialog.getLibraryLevel());
        }
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JButton jButton;
        JButton jButton2;
        JButton jButton3;
        JPanel jPanel;
        JPanel jPanel2;
        this.createUIComponents();
        this.myTopPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myScriptingLibrariesPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(7, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel2.add((Component)jPanel, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel.setBorder(IdeBorderFactory.PlainSmallWithoutIndent.createTitledBorder(null, (String)"Libraries", (int)0, (int)0, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel.add((Component)jBScrollPane, new GridConstraints(0, 0, 7, 1, 0, 3, 7, 7, null, null, null));
        JBTable jBTable = this.myLibraryTable;
        jBTable.setStriped(true);
        jBScrollPane.setViewportView((Component)jBTable);
        this.myAddLibraryButton = jButton3 = new JButton();
        this.$$$loadButtonText$$$(jButton3, ResourceBundle.getBundle("messages/IdeBundle").getString("scripting.lib.add"));
        jPanel.add((Component)jButton3, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myRemoveLibraryButton = jButton2 = new JButton();
        this.$$$loadButtonText$$$(jButton2, ResourceBundle.getBundle("messages/IdeBundle").getString("scripting.lib.remove"));
        jPanel.add((Component)jButton2, new GridConstraints(2, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myEditLibraryButton = jButton = new JButton();
        this.$$$loadButtonText$$$(jButton, ResourceBundle.getBundle("messages/IdeBundle").getString("scripting.lib.edit"));
        jPanel.add((Component)jButton, new GridConstraints(1, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(6, 1, 1, 1, 0, 2, 1, 6, null, null, null));
        JButton jButton4 = this.myDownloadButton;
        jButton4.setText("Download...");
        jButton4.setMnemonic('D');
        jButton4.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jButton4, new GridConstraints(3, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        JButton jButton5 = this.myManageScopesButton;
        jButton5.setText("Manage Scopes...");
        jButton5.setMnemonic('S');
        jButton5.setDisplayedMnemonicIndex(7);
        jPanel.add((Component)jButton5, new GridConstraints(5, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(4, 1, 1, 1, 0, 2, 1, 0, null, new Dimension(-1, 10), null));
    }

    @Override
    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myTopPanel;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c2 = '\u0000';
        int n2 = -1;
        for (int i2 = 0; i2 < string2.length(); ++i2) {
            if (string2.charAt(i2) == '&') {
                if (++i2 == string2.length()) break;
                if (!bl && string2.charAt(i2) != '&') {
                    bl = true;
                    c2 = string2.charAt(i2);
                    n2 = stringBuffer.length();
                }
            }
            stringBuffer.append(string2.charAt(i2));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c2);
            abstractButton.setDisplayedMnemonicIndex(n2);
        }
    }
}

