/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webcore.libraries.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.RootProvider;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.ui.configuration.ProjectSettingsService;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.table.JBTable;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.download.DownloadableFileSetDescription;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.SwingHelper;
import com.intellij.webcore.ModuleHelper;
import com.intellij.webcore.libraries.LangScriptingContextProvider;
import com.intellij.webcore.libraries.ScriptingLibraryManager;
import com.intellij.webcore.libraries.ScriptingLibraryMappings;
import com.intellij.webcore.libraries.ScriptingLibraryModel;
import com.intellij.webcore.libraries.ui.LibraryScopesDialog;
import com.intellij.webcore.libraries.ui.ModuleScopeSelectionDialog;
import com.intellij.webcore.libraries.ui.PartlySelectedCheckBoxEditor;
import com.intellij.webcore.libraries.ui.PartlySelectedCheckBoxRenderer;
import com.intellij.webcore.libraries.ui.ScriptingContextsConfigurable;
import com.intellij.webcore.libraries.ui.ScriptingLibraryTableModel;
import com.intellij.webcore.libraries.ui.download.DownloadWebLibraryDialog;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Map;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;

public class ScriptingLibrariesPanelStub {
    private JPanel myMainPanel;
    protected JButton myManageScopesButton;
    protected Project myProject;
    protected ScriptingLibraryTableModel myLibTableModel;
    protected JBTable myLibraryTable;
    private JPanel myLibrariesPanel;
    protected JButton myDownloadButton;
    private JButton myConfigureButton;
    protected LangScriptingContextProvider myProvider;
    protected final ScriptingLibraryManager myLibraryManager;
    private final ScriptingLibraryMappings myLibraryMappings;
    private boolean areMappingsChanged = false;

    public ScriptingLibrariesPanelStub(Project project2, LangScriptingContextProvider provider, final ScriptingLibraryManager libraryManager) {
        this.myProject = project2;
        this.myProvider = provider;
        this.$$$setupUI$$$();
        this.myLibraryMappings = provider.getLibraryMappings(project2);
        this.myLibraryManager = libraryManager;
        this.myProvider = provider;
        this.myLibTableModel = new ScriptingLibraryTableModel(libraryManager, this.myLibraryMappings);
        this.myLibraryTable.setModel((TableModel)this.myLibTableModel);
        JTableHeader tableHeader = this.myLibraryTable.getTableHeader();
        tableHeader.setReorderingAllowed(false);
        TableColumn enabledColumn = this.myLibraryTable.getColumnModel().getColumn(0);
        ScriptingLibrariesPanelStub.setColumnWidth(enabledColumn, JBUI.scale((int)60));
        enabledColumn.setCellRenderer(new PartlySelectedCheckBoxRenderer());
        enabledColumn.setCellEditor(new PartlySelectedCheckBoxEditor(this));
        SwingHelper.setNoBorderCellRendererFor(this.myLibraryTable.getColumnModel().getColumn(1));
        ScriptingLibrariesPanelStub.setColumnWidth(this.myLibraryTable.getColumnModel().getColumn(2), JBUI.scale((int)80));
        this.myLibraryTable.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e2) {
                if (e2.getKeyChar() == ' ') {
                    int[] selectedRows = ScriptingLibrariesPanelStub.this.myLibraryTable.getSelectedRows();
                    boolean allSelected = true;
                    for (int row : selectedRows) {
                        if (ScriptingLibraryTableModel.EnabledState.ON == ScriptingLibrariesPanelStub.this.myLibTableModel.getValueAt(row, 0)) continue;
                        allSelected = false;
                    }
                    for (int row : selectedRows) {
                        if (!allSelected && ScriptingLibraryTableModel.EnabledState.ON != ScriptingLibrariesPanelStub.this.myLibTableModel.getValueAt(row, 0)) {
                            ScriptingLibrariesPanelStub.this.myLibTableModel.setValueAt(Boolean.TRUE, row, 0);
                            continue;
                        }
                        if (!allSelected) continue;
                        ScriptingLibrariesPanelStub.this.myLibTableModel.setValueAt(Boolean.FALSE, row, 0);
                    }
                }
            }
        });
        this.myConfigureButton.setToolTipText("Configure JavaScript library (Project Structure)");
        this.myConfigureButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                String libraryName;
                ScriptingLibraryModel libraryModel;
                LibraryTable.Listener listener2 = new LibraryTable.Listener(){

                    public void afterLibraryAdded(Library newLibrary) {
                        ScriptingLibrariesPanelStub.this.myLibraryManager.reset();
                    }

                    public void afterLibraryRenamed(Library library) {
                        ScriptingLibrariesPanelStub.this.myLibraryManager.reset();
                    }

                    public void afterLibraryRemoved(Library library) {
                        ScriptingLibrariesPanelStub.this.myLibraryManager.reset();
                    }
                };
                ScriptingLibrariesPanelStub.this.myProvider.getLibraryMappings(ScriptingLibrariesPanelStub.this.myProject).registerLibraryTableListener(listener2, (Disposable)ScriptingLibrariesPanelStub.this.myLibraryMappings);
                for (final ScriptingLibraryModel libraryModel2 : ScriptingLibrariesPanelStub.this.myLibraryManager.getAllLibraries()) {
                    final Library originalLibrary = libraryModel2.getOriginalLibrary();
                    if (originalLibrary == null) continue;
                    originalLibrary.getRootProvider().addRootSetChangedListener(new RootProvider.RootSetChangedListener(){

                        public void rootSetChanged(RootProvider wrapper) {
                            libraryModel2.setSourceFiles(originalLibrary.getFiles(OrderRootType.SOURCES));
                            libraryModel2.setCompactFiles(originalLibrary.getFiles(OrderRootType.CLASSES));
                            libraryModel2.setDocUrls(originalLibrary.getUrls(OrderRootType.DOCUMENTATION));
                        }
                    }, (Disposable)ScriptingLibrariesPanelStub.this.myLibraryMappings);
                }
                Library selectedLibrary = null;
                if (ScriptingLibrariesPanelStub.this.myLibraryTable.getSelectedRowCount() == 1 && (libraryModel = libraryManager.getLibraryByName(libraryName = ScriptingLibrariesPanelStub.this.myLibTableModel.getLibNameAt(ScriptingLibrariesPanelStub.this.myLibraryTable.getSelectedRow()))) != null && !libraryModel.isPredefined()) {
                    selectedLibrary = libraryModel.getOriginalLibrary();
                }
                if (selectedLibrary != null) {
                    ProjectSettingsService.getInstance(ScriptingLibrariesPanelStub.this.myProject).openLibrary(selectedLibrary);
                } else {
                    ProjectSettingsService.getInstance(ScriptingLibrariesPanelStub.this.myProject).openGlobalLibraries();
                }
                ScriptingLibrariesPanelStub.this.myLibTableModel.fireLibTableChanged(true);
            }
        });
        this.myDownloadButton.setToolTipText("Download from content delivery network (CDN) and install");
        this.myDownloadButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                ScriptingLibrariesPanelStub.this.showDownloadDialog(ScriptingLibrariesPanelStub.this.getPanel());
            }
        });
        this.myManageScopesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                ScriptingLibrariesPanelStub.this.showUsageScopesDialog();
            }
        });
        this.myLibrariesPanel.setBorder(IdeBorderFactory.createTitledBorder((String)"Libraries"));
    }

    private static void setColumnWidth(@NotNull TableColumn column, int width) {
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/webcore/libraries/ui/ScriptingLibrariesPanelStub", "setColumnWidth"));
        }
        column.setPreferredWidth(width);
        column.setMaxWidth(width);
    }

    public JComponent getPanel() {
        return this.myMainPanel;
    }

    public boolean isModified() {
        return this.myLibTableModel.isChanged() || this.areMappingsChanged;
    }

    public void resetTable() {
        this.myLibTableModel.resetTable();
        this.areMappingsChanged = false;
    }

    public void apply() {
        this.myLibTableModel.applyChanges();
        Map libMappings = this.myLibraryMappings.getMappings();
        for (ScriptingLibraryModel libraryModel : libMappings.values()) {
            if (!(libraryModel instanceof ScriptingLibraryMappings.CompoundLibrary)) continue;
            ((ScriptingLibraryMappings.CompoundLibrary)libraryModel).applyChanges();
        }
    }

    protected void selectLibrary(String libName) {
        int libIndex = this.myLibTableModel.getLibraryIndex(libName);
        if (libIndex >= 0) {
            this.myLibraryTable.getSelectionModel().setSelectionInterval(libIndex, libIndex);
        }
    }

    protected void afterDownload(DownloadableFileSetDescription description) {
        this.myLibTableModel.fireLibTableChanged(true);
        String libName = LangScriptingContextProvider.getIdeLibraryName(description);
        assert (libName != null);
        this.selectLibrary(libName);
        if (ModuleHelper.getModules((Project)this.myProject).length > 1) {
            this.configureModules();
        }
    }

    private void showDownloadDialog(@NotNull Component notificationAreaComponent) {
        if (notificationAreaComponent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notificationAreaComponent", "com/intellij/webcore/libraries/ui/ScriptingLibrariesPanelStub", "showDownloadDialog"));
        }
        DownloadWebLibraryDialog downloadDialog = new DownloadWebLibraryDialog(this.myProject, this.myProvider);
        if (downloadDialog.showAndGet()) {
            DownloadableFileSetDescription descriptor2 = downloadDialog.getSelection();
            if (descriptor2 == null) {
                return;
            }
            this.myProvider.downloadLibrary(this.myProject, descriptor2, notificationAreaComponent, () -> this.afterDownload(descriptor2));
        }
    }

    private void showUsageScopesDialog() {
        ScriptingContextsConfigurable configurable;
        this.myLibTableModel.applyMappings();
        LibraryScopesDialog dialogWrapper = new LibraryScopesDialog(this, this.myProject, this.myLibraryMappings);
        dialogWrapper.setTitle(this.myProvider.getLanguage().getDisplayName() + " Libraries Usage Scopes");
        if (dialogWrapper.showAndGet() && (configurable = dialogWrapper.getConfigurable()).isModified()) {
            try {
                configurable.apply();
                this.areMappingsChanged = true;
                this.myLibTableModel.fireLibTableChanged(false);
            }
            catch (ConfigurationException configurationException) {
                // empty catch block
            }
        }
    }

    int configureModules() {
        String name;
        ScriptingLibraryModel libraryModel;
        if (ModuleHelper.getModules((Project)this.myProject).length == 1) {
            return -1;
        }
        int selectedRow = this.myLibraryTable.getSelectedRow();
        if (selectedRow >= 0 && (libraryModel = this.myLibraryManager.getLibraryByName(name = this.myLibTableModel.getLibNameAt(selectedRow))) != null) {
            if (libraryModel.isPredefined()) {
                return -1;
            }
            ModuleScopeSelectionDialog dialog2 = new ModuleScopeSelectionDialog(this.myProject, libraryModel.getAssociatedModules(), null, libraryModel.getName());
            if (dialog2.showAndGet()) {
                Set<Module> selectedModules = dialog2.getSelectedModules();
                if (!libraryModel.getAssociatedModules().equals(selectedModules)) {
                    libraryModel.setAssociatedModules(selectedModules);
                    this.myLibraryMappings.updateMappings();
                    this.areMappingsChanged = true;
                }
                return selectedModules.size();
            }
            return libraryModel.getAssociatedModules().size();
        }
        return -1;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JButton jButton;
        JButton jButton2;
        JButton jButton3;
        JBTable jBTable;
        JPanel jPanel;
        JPanel jPanel2;
        this.myMainPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        this.myLibrariesPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel2.add((Component)jPanel, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel.setBorder(IdeBorderFactory.PlainSmallWithoutIndent.createTitledBorder(null, (String)"Libraries", (int)0, (int)0, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel.add((Component)jBScrollPane, new GridConstraints(0, 0, 4, 1, 0, 3, 7, 7, null, null, null));
        this.myLibraryTable = jBTable = new JBTable();
        jBTable.setStriped(true);
        jBScrollPane.setViewportView((Component)jBTable);
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(3, 1, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myManageScopesButton = jButton3 = new JButton();
        jButton3.setText("Manage Scopes...");
        jButton3.setMnemonic('S');
        jButton3.setDisplayedMnemonicIndex(7);
        jPanel.add((Component)jButton3, new GridConstraints(2, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myDownloadButton = jButton2 = new JButton();
        jButton2.setText("Download...");
        jButton2.setMnemonic('D');
        jButton2.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jButton2, new GridConstraints(1, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myConfigureButton = jButton = new JButton();
        jButton.setText("Configure...");
        jButton.setMnemonic('C');
        jButton.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jButton, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }
}

