/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webcore.libraries.ui;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.webcore.libraries.ScriptingLibraryManager;
import com.intellij.webcore.libraries.ScriptingLibraryMappings;
import com.intellij.webcore.libraries.ScriptingLibraryModel;
import com.intellij.webcore.libraries.ScriptingLibraryTable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.table.AbstractTableModel;
import org.jetbrains.annotations.Nullable;

public class ScriptingLibraryTableModel
extends AbstractTableModel {
    public static final int LIB_ENABLED_COL = 0;
    public static final int LIB_NAME_COL = 1;
    public static final int LIB_TYPE_COL = 2;
    private ScriptingLibraryManager myLibraryManager;
    private LibraryScope[] myLibraries;
    private ScriptingLibraryMappings myMappings;
    private boolean myIsChanged;

    public ScriptingLibraryTableModel(ScriptingLibraryManager libManager, ScriptingLibraryMappings mappings) {
        this.myLibraryManager = libManager;
        this.myMappings = mappings;
        this.myIsChanged = false;
        this.myLibraries = this.getLibrariesScopes();
    }

    public void resetTable() {
        this.myMappings.reset();
        this.myLibraries = this.getLibrariesScopes();
        this.myIsChanged = false;
        this.fireTableDataChanged();
    }

    @Override
    public int getRowCount() {
        return this.myLibraries.length;
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex == 0;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        LibraryScope lib = this.myLibraries[rowIndex];
        assert (lib != null);
        switch (columnIndex) {
            case 0: {
                return lib.myState;
            }
            case 1: {
                return lib.myLibrary.getName();
            }
            case 2: {
                switch (lib.myLibrary.getLibraryLevel()) {
                    case PREDEFINED: {
                        return "Predefined";
                    }
                    case GLOBAL: {
                        return "Global";
                    }
                    case PROJECT: {
                        return "Project";
                    }
                }
            }
        }
        return "?";
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        this.myIsChanged = true;
        switch (columnIndex) {
            case 0: {
                if (!(aValue instanceof Boolean)) break;
                LibraryScope libraryScope = this.myLibraries[rowIndex];
                libraryScope.myState = Boolean.TRUE.equals(aValue) ? EnabledState.ON : EnabledState.OFF;
            }
        }
        this.fireTableCellUpdated(rowIndex, columnIndex);
    }

    @Override
    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return "Enabled";
            }
            case 1: {
                return "Name";
            }
            case 2: {
                return "Type";
            }
        }
        return "?";
    }

    public void applyChanges() {
        Set files2 = this.myMappings.getMappings().keySet();
        for (LibraryScope libraryScope : this.myLibraries) {
            String libName = libraryScope.myLibrary.getName();
            if (libraryScope.myState == EnabledState.ON && !this.myMappings.isAssociatedWithProject(libName)) {
                this.myMappings.associate(null, libName, libraryScope.myLibrary.isPredefined());
                continue;
            }
            if (libraryScope.myState != EnabledState.OFF) continue;
            this.myMappings.disassociate(null, libName);
            for (VirtualFile file2 : files2) {
                if (!this.myMappings.isAssociatedWith(file2, libName)) continue;
                this.myMappings.disassociate(file2, libName);
            }
        }
    }

    public void applyMappings() {
        Map mappings = this.myMappings.getMappings();
        for (Map.Entry entry : mappings.entrySet()) {
            if (!(entry.getValue() instanceof ScriptingLibraryMappings.CompoundLibrary)) continue;
            ScriptingLibraryMappings.CompoundLibrary compoundLibrary = (ScriptingLibraryMappings.CompoundLibrary)entry.getValue();
            List compoundFileLibraries = ContainerUtil.map((Collection)compoundLibrary.getLibraries(), model2 -> model2.getName());
            for (LibraryScope libraryScope : this.myLibraries) {
                if (libraryScope.myState == EnabledState.OFF && compoundFileLibraries.contains(libraryScope.myLibrary.getName())) {
                    compoundLibrary.toggleLibrary(libraryScope.myLibrary);
                    continue;
                }
                if (libraryScope.myState != EnabledState.ON || entry.getKey() != null || compoundFileLibraries.contains(libraryScope.myLibrary.getName())) continue;
                compoundLibrary.toggleLibrary(libraryScope.myLibrary);
            }
        }
    }

    public ScriptingLibraryModel createLibrary(final String name, final VirtualFile[] sourceFiles, final VirtualFile[] compactFiles, final String[] docUrls, final ScriptingLibraryModel.LibraryLevel level, final boolean isOnByDefault) {
        return (ScriptingLibraryModel)ApplicationManager.getApplication().runWriteAction((Computable)new Computable<ScriptingLibraryModel>(){

            public ScriptingLibraryModel compute() {
                ScriptingLibraryModel result2 = ScriptingLibraryTableModel.this.myLibraryManager.createLibrary(name, sourceFiles, compactFiles, docUrls, level, isOnByDefault);
                ScriptingLibraryTableModel.this.fireLibTableChanged(true);
                for (int i2 = 0; i2 < ScriptingLibraryTableModel.this.myLibraries.length; ++i2) {
                    LibraryScope scope = ScriptingLibraryTableModel.this.myLibraries[i2];
                    if (scope.myLibrary != result2) continue;
                    ScriptingLibraryTableModel.this.setValueAt(Boolean.TRUE, i2, 0);
                    break;
                }
                return result2;
            }
        });
    }

    @Nullable
    public ScriptingLibraryModel getLibrary(String name) {
        ScriptingLibraryTable libraryTable = this.myLibraryManager.getScriptingLibraryTable();
        return libraryTable.getLibraryByName(name);
    }

    public int getLibraryIndex(String name) {
        int index = 0;
        for (LibraryScope lib : this.myLibraries) {
            if (lib.myLibrary.getName().equals(name)) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public void removeLibrary(String name) {
        ScriptingLibraryModel libToRemove = this.getLibrary(name);
        if (libToRemove != null) {
            this.myLibraryManager.removeLibrary(libToRemove);
            this.fireLibTableChanged(true);
        }
    }

    @Nullable
    public ScriptingLibraryModel updateLibrary(final String oldName, final String name, final VirtualFile[] sourceFiles, final VirtualFile[] compactFiles, final String[] docUrls) {
        return (ScriptingLibraryModel)ApplicationManager.getApplication().runWriteAction((Computable)new Computable<ScriptingLibraryModel>(){

            public ScriptingLibraryModel compute() {
                ScriptingLibraryModel result2 = ScriptingLibraryTableModel.this.myLibraryManager.updateLibrary(oldName, name, sourceFiles, compactFiles, docUrls);
                ScriptingLibraryTableModel.this.myIsChanged = true;
                ScriptingLibraryTableModel.this.fireTableDataChanged();
                return result2;
            }
        });
    }

    public void fireLibTableChanged(boolean keepMappings) {
        this.myIsChanged = true;
        LibraryScope[] newLibraryScopes = this.getLibrariesScopes();
        if (keepMappings) {
            for (LibraryScope newLibraryScope : newLibraryScopes) {
                for (LibraryScope oldLibraryScope : this.myLibraries) {
                    if (!oldLibraryScope.myLibrary.getName().equals(newLibraryScope.myLibrary.getName())) continue;
                    newLibraryScope.myState = oldLibraryScope.myState;
                }
            }
        }
        this.myLibraries = newLibraryScopes;
        this.fireTableDataChanged();
    }

    @Nullable
    public String getLibNameAt(int row) {
        ScriptingLibraryModel lib = this.myLibraries[row].myLibrary;
        return lib != null ? lib.getName() : null;
    }

    @Nullable
    public ScriptingLibraryModel getLibraryAt(int row) {
        return this.myLibraries[row].myLibrary;
    }

    public boolean isChanged() {
        return this.myIsChanged;
    }

    private static ScriptingLibraryModel[] getOrderedLibraries(ScriptingLibraryTable libraryTable) {
        ArrayList<ScriptingLibraryModel> orderedLibraries = new ArrayList<ScriptingLibraryModel>();
        for (ScriptingLibraryModel libraryModel : libraryTable.getAllLibraries()) {
            if (libraryModel == null) continue;
            orderedLibraries.add(libraryModel);
        }
        Collections.sort(orderedLibraries, (lib1, lib2) -> {
            if (lib1.isPredefined() != lib2.isPredefined()) {
                return (lib1.isPredefined() ? 1 : 0) - (lib2.isPredefined() ? 1 : 0);
            }
            return lib1.getName().compareToIgnoreCase(lib2.getName());
        });
        return orderedLibraries.toArray(new ScriptingLibraryModel[orderedLibraries.size()]);
    }

    public LibraryScope[] getLibrariesScopes() {
        Map fileMappings = this.myMappings.getMappings();
        HashMap<String, HashSet<VirtualFile>> librariesAssociations = new HashMap<String, HashSet<VirtualFile>>();
        for (Map.Entry fileMapping : fileMappings.entrySet()) {
            VirtualFile file2 = (VirtualFile)fileMapping.getKey();
            ScriptingLibraryModel model2 = (ScriptingLibraryModel)fileMapping.getValue();
            if (!(model2 instanceof ScriptingLibraryMappings.CompoundLibrary)) continue;
            ScriptingLibraryMappings.CompoundLibrary compoundLibrary = (ScriptingLibraryMappings.CompoundLibrary)model2;
            Collection fileLibraries = compoundLibrary.getLibraries();
            for (ScriptingLibraryModel library : fileLibraries) {
                HashSet<VirtualFile> files2 = (HashSet<VirtualFile>)librariesAssociations.get(library.getName());
                if (files2 == null) {
                    files2 = new HashSet<VirtualFile>();
                    librariesAssociations.put(library.getName(), files2);
                }
                files2.add(file2);
            }
        }
        ScriptingLibraryModel[] libraries = ScriptingLibraryTableModel.getOrderedLibraries(this.myLibraryManager.getScriptingLibraryTable());
        LibraryScope[] scopes = new LibraryScope[libraries.length];
        for (int i2 = 0; i2 < libraries.length; ++i2) {
            EnabledState enabledState = EnabledState.OFF;
            String libraryName = libraries[i2].getName();
            if (librariesAssociations.containsKey(libraryName)) {
                if (this.myMappings.isAssociatedWithProject(libraryName)) {
                    enabledState = EnabledState.ON;
                } else {
                    for (VirtualFile file3 : (Set)librariesAssociations.get(libraryName)) {
                        if (file3 == null) continue;
                        enabledState = EnabledState.PARTLY;
                        break;
                    }
                }
            }
            scopes[i2] = new LibraryScope(libraries[i2], enabledState);
        }
        return scopes;
    }

    private static class LibraryScope {
        public ScriptingLibraryModel myLibrary;
        public EnabledState myState;

        private LibraryScope(ScriptingLibraryModel library, EnabledState state) {
            this.myLibrary = library;
            this.myState = state;
        }
    }

    public static enum EnabledState {
        ON,
        PARTLY,
        OFF;

    }
}

