/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webcore.libraries.ui.download;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.SpeedSearchComparator;
import com.intellij.ui.TableSpeedSearch;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.table.JBTable;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.download.DownloadableFileDescription;
import com.intellij.util.download.DownloadableFileSetDescription;
import com.intellij.util.download.DownloadableFileSetVersions;
import com.intellij.webcore.libraries.LangScriptingContextProvider;
import com.intellij.webcore.libraries.ui.download.DownloadableFileSetDescriptionWithUrl;
import com.intellij.webcore.libraries.ui.download.DownloadableFileSetDescriptionWithUrlImpl;
import com.intellij.webcore.libraries.ui.download.TypeScriptStubsDownloader;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DownloadWebLibraryDialog
extends DialogWrapper {
    private JPanel contentPane;
    private JBTable myLibraryTable;
    private JComboBox myLibrariesSource;
    private DownloadableFileSetDescription myLastSelectedElement;

    public DownloadWebLibraryDialog(final Project project2, final LangScriptingContextProvider provider) {
        super(project2);
        this.$$$setupUI$$$();
        this.setTitle("Download Library");
        this.setOKButtonText("Download and Install");
        this.setCancelButtonText("Close");
        this.setOKActionEnabled(false);
        this.myLibraryTable.setSelectionMode(0);
        DefaultComboBoxModel<MyLibrariesSource> librariesSourceModel = new DefaultComboBoxModel<MyLibrariesSource>();
        librariesSourceModel.addElement(new MyLibrariesSource("Official libraries", true){

            @Override
            void prepareTableModel(final DownloadableFileSetVersions.FileSetVersionsCallback<DownloadableFileSetDescriptionWithUrl> callback) {
                DownloadableFileSetVersions.FileSetVersionsCallback<DownloadableFileSetDescription> _callback = new DownloadableFileSetVersions.FileSetVersionsCallback<DownloadableFileSetDescription>(){

                    public void onSuccess(@NotNull List<? extends DownloadableFileSetDescription> versions) {
                        if (versions == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "versions", "com/intellij/webcore/libraries/ui/download/DownloadWebLibraryDialog$1$1", "onSuccess"));
                        }
                        ArrayList listWithUrls = new ArrayList();
                        for (DownloadableFileSetDescription downloadableFileSetDescription : versions) {
                            listWithUrls.add(this.createDownloadableFileSetDescriptionWithUrl(downloadableFileSetDescription, downloadableFileSetDescription.getFiles()));
                        }
                        callback.onSuccess(listWithUrls);
                    }

                    private <T extends DownloadableFileDescription> DownloadableFileSetDescriptionWithUrlImpl<T> createDownloadableFileSetDescriptionWithUrl(DownloadableFileSetDescription version, List<T> files2) {
                        return new DownloadableFileSetDescriptionWithUrlImpl<T>(version.getName(), version.getVersionString(), ((DownloadableFileDescription)version.getFiles().get(0)).getDownloadUrl(), files2);
                    }
                };
                provider.getDownloadableLibraryDescriptors(project2).fetchVersions((DownloadableFileSetVersions.FileSetVersionsCallback)_callback);
            }
        });
        librariesSourceModel.addElement(new TypeScriptStubsDownloader());
        this.myLibrariesSource.setModel(librariesSourceModel);
        final DefaultTableModel loadingMessageTableModel = new DefaultTableModel(new Object[]{"Fetching a list of libraries..."}, 1){

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        this.myLibrariesSource.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                final MyLibrariesSource librariesSourceElement = (MyLibrariesSource)DownloadWebLibraryDialog.this.myLibrariesSource.getSelectedItem();
                if (librariesSourceElement != null) {
                    DownloadWebLibraryDialog.this.setOKActionEnabled(false);
                    DownloadWebLibraryDialog.this.myLibraryTable.setModel((TableModel)loadingMessageTableModel);
                    ApplicationManager.getApplication().executeOnPooledThread(() -> librariesSourceElement.prepareTableModel(new DownloadableFileSetVersions.FileSetVersionsCallback<DownloadableFileSetDescriptionWithUrl>(){

                        public void onSuccess(@NotNull List<? extends DownloadableFileSetDescriptionWithUrl> versions) {
                            if (versions == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "versions", "com/intellij/webcore/libraries/ui/download/DownloadWebLibraryDialog$3$1", "onSuccess"));
                            }
                            if (versions.size() > 0) {
                                provider.filterExistingLibraries(project2, versions);
                                ApplicationManager.getApplication().invokeLater(() -> {
                                    if (versions == null) {
                                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "versions", "com/intellij/webcore/libraries/ui/download/DownloadWebLibraryDialog$3$1", "lambda$onSuccess$0"));
                                    }
                                    DownloadWebLibraryDialog.this.myLibraryTable.setModel((TableModel)new MyLibraryTableModel(versions, librariesSourceElement.includeVersionColumn()));
                                }, ModalityState.any());
                            }
                        }

                        public void onError(@NotNull String errorMessage) {
                            if (errorMessage == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorMessage", "com/intellij/webcore/libraries/ui/download/DownloadWebLibraryDialog$3$1", "onError"));
                            }
                            ApplicationManager.getApplication().invokeLater(() -> {
                                if (errorMessage == null) {
                                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorMessage", "com/intellij/webcore/libraries/ui/download/DownloadWebLibraryDialog$3$1", "lambda$onError$1"));
                                }
                                loadingMessageTableModel.setColumnIdentifiers(new Object[]{"Error while fetching list of libraries: " + errorMessage});
                            }, ModalityState.any());
                        }
                    }));
                }
            }
        });
        this.init();
        TableColumnModel columnModel = this.myLibraryTable.getColumnModel();
        int[] colSizes = new int[]{100, 20, 300};
        for (int col = 0; col < columnModel.getColumnCount(); ++col) {
            columnModel.getColumn(col).setPreferredWidth(colSizes[col]);
        }
        new TableSpeedSearch((JTable)this.myLibraryTable).setComparator(new SpeedSearchComparator(true));
        this.myLibraryTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e2) {
                TableModel model2 = DownloadWebLibraryDialog.this.myLibraryTable.getModel();
                if (model2 instanceof MyLibraryTableModel) {
                    DownloadWebLibraryDialog.this.setOKActionEnabled(true);
                    DownloadWebLibraryDialog.this.myLastSelectedElement = ((MyLibraryTableModel)model2).getDescriptionAt(DownloadWebLibraryDialog.this.myLibraryTable.getSelectedRow());
                }
            }
        });
    }

    protected void init() {
        super.init();
        this.myLibrariesSource.setSelectedIndex(1);
    }

    @Nullable
    protected String getHelpId() {
        return "JavaScript.Libraries";
    }

    protected JComponent createCenterPanel() {
        return this.contentPane;
    }

    @Nullable
    public DownloadableFileSetDescription getSelection() {
        return this.myLastSelectedElement;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JComboBox jComboBox;
        JBTable jBTable;
        JPanel jPanel;
        this.contentPane = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel2.add((Component)jBScrollPane, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myLibraryTable = jBTable = new JBTable();
        jBTable.setStriped(true);
        jBTable.setAutoResizeMode(2);
        jBScrollPane.setViewportView((Component)jBTable);
        this.myLibrariesSource = jComboBox = new JComboBox();
        jPanel2.add(jComboBox, new GridConstraints(0, 0, 1, 1, 8, 0, 2, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.contentPane;
    }

    static abstract class MyLibrariesSource {
        private final String myName;
        private final boolean myIncludeVersionColumn;

        MyLibrariesSource(String name, boolean includeVersionColumn) {
            this.myName = name;
            this.myIncludeVersionColumn = includeVersionColumn;
        }

        public String toString() {
            return this.myName;
        }

        boolean includeVersionColumn() {
            return this.myIncludeVersionColumn;
        }

        abstract void prepareTableModel(DownloadableFileSetVersions.FileSetVersionsCallback<DownloadableFileSetDescriptionWithUrl> var1);
    }

    private static class MyLibraryTableModel
    extends AbstractTableModel {
        private final int NAME_COL;
        private final int VERSION_COL;
        private final int URL_COL;
        private final List<? extends DownloadableFileSetDescriptionWithUrl> myDescriptions;
        private final boolean myIncludeVersionColumn;

        public MyLibraryTableModel(List<? extends DownloadableFileSetDescriptionWithUrl> descriptions, boolean includeVersionColumn) {
            this.myDescriptions = descriptions;
            this.myIncludeVersionColumn = includeVersionColumn;
            this.NAME_COL = 0;
            this.VERSION_COL = this.myIncludeVersionColumn ? 1 : -1;
            this.URL_COL = this.myIncludeVersionColumn ? 2 : 1;
            Collections.sort(this.myDescriptions, new Comparator<DownloadableFileSetDescription>(){

                @Override
                public int compare(DownloadableFileSetDescription d1, DownloadableFileSetDescription d2) {
                    if (d1.getName().equals(d2.getName())) {
                        return d1.getVersionString().compareTo(d2.getVersionString());
                    }
                    return d1.getName().compareToIgnoreCase(d2.getName());
                }
            });
        }

        @Override
        public int getRowCount() {
            return this.myDescriptions.size();
        }

        @Override
        public int getColumnCount() {
            return this.myIncludeVersionColumn ? 3 : 2;
        }

        @Override
        @Nullable
        public Object getValueAt(int rowIndex, int columnIndex) {
            DownloadableFileSetDescriptionWithUrl descriptor2 = this.myDescriptions.get(rowIndex);
            if (columnIndex == this.NAME_COL) {
                return descriptor2.getName();
            }
            if (columnIndex == this.VERSION_COL) {
                return descriptor2.getVersionString();
            }
            if (columnIndex == this.URL_COL) {
                return descriptor2.getUrl();
            }
            return null;
        }

        @Override
        @Nullable
        public String getColumnName(int column) {
            if (column == this.NAME_COL) {
                return "Name";
            }
            if (column == this.VERSION_COL) {
                return "Version";
            }
            if (column == this.URL_COL) {
                return "URL";
            }
            return "";
        }

        @Nullable
        public DownloadableFileSetDescription getDescriptionAt(int rowIndex) {
            if (rowIndex < 0 || rowIndex >= this.myDescriptions.size()) {
                return null;
            }
            return this.myDescriptions.get(rowIndex);
        }
    }
}

