/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webcore.libraries.ui.download;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.download.DownloadableFileDescription;
import com.intellij.util.download.DownloadableFileSetVersions;
import com.intellij.util.download.impl.DownloadableFileDescriptionImpl;
import com.intellij.util.io.HttpRequests;
import com.intellij.webcore.libraries.ui.download.DownloadWebLibraryDialog;
import com.intellij.webcore.libraries.ui.download.DownloadableFileSetDescriptionWithUrl;
import com.intellij.webcore.util.JsonUtil;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptStubsDownloader
extends DownloadWebLibraryDialog.MyLibrariesSource {
    private static final String TYPES_DIR = "types/";
    private static final String URL_ALL = "https://api.github.com/repos/DefinitelyTyped/DefinitelyTyped/git/trees/master?recursive=1";
    private static final String URL_ITEM = "https://api.github.com/repos/DefinitelyTyped/DefinitelyTyped/contents/types/";
    private static final String FILE_URL = "https://github.com/DefinitelyTyped/DefinitelyTyped/raw/master/types/";
    private static final String D_TS_FILE = "d.ts";
    private static final String D_TSX_FILE = "d.tsx";

    TypeScriptStubsDownloader() {
        super("TypeScript community stubs", false);
    }

    @Override
    void prepareTableModel(final DownloadableFileSetVersions.FileSetVersionsCallback<DownloadableFileSetDescriptionWithUrl> callback) {
        try {
            HttpRequests.request((String)URL_ALL).connect((HttpRequests.RequestProcessor)new HttpRequests.RequestProcessor<Object>(){

                public Object process(@NotNull HttpRequests.Request request2) throws IOException {
                    if (request2 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/webcore/libraries/ui/download/TypeScriptStubsDownloader$1", "process"));
                    }
                    try {
                        JsonReader reader = new JsonReader((Reader)request2.getReader());
                        List versions = TypeScriptStubsDownloader.parseTypes(reader);
                        callback.onSuccess(versions);
                    }
                    catch (IOException e2) {
                        callback.onError(HttpRequests.createErrorMessage((IOException)e2, (HttpRequests.Request)request2, (boolean)true));
                    }
                    return null;
                }
            });
        }
        catch (IOException e2) {
            callback.onError(e2.getMessage());
        }
    }

    @NotNull
    private static List<DownloadableFileSetDescriptionWithUrl> parseTypes(@NotNull JsonReader reader) throws IOException {
        if (reader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reader", "com/intellij/webcore/libraries/ui/download/TypeScriptStubsDownloader", "parseTypes"));
        }
        if (reader.peek() != JsonToken.BEGIN_OBJECT) {
            throw new IOException("Unable to parse types: root element is not an object");
        }
        ArrayList versions = ContainerUtil.newArrayList();
        reader.beginObject();
        while (reader.hasNext()) {
            String name = reader.nextName();
            if ("tree".equals(name)) {
                if (reader.peek() != JsonToken.BEGIN_ARRAY) {
                    throw new IOException("Unable to parse types: tree child is not an array");
                }
                reader.beginArray();
                while (reader.hasNext()) {
                    String typeName = TypeScriptStubsDownloader.parseTypeName(reader);
                    if (typeName == null) continue;
                    versions.add(new LazyDefinitelyTypedFileSetDescription(typeName));
                }
                reader.endArray();
                continue;
            }
            reader.skipValue();
        }
        reader.endObject();
        ArrayList arrayList = versions;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/webcore/libraries/ui/download/TypeScriptStubsDownloader", "parseTypes"));
        }
        return arrayList;
    }

    @Nullable
    private static String parseTypeName(@NotNull JsonReader reader) throws IOException {
        String subPath;
        if (reader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reader", "com/intellij/webcore/libraries/ui/download/TypeScriptStubsDownloader", "parseTypeName"));
        }
        Map<String, String> map2 = JsonUtil.getTopLevelStringValues(reader, ContainerUtil.newHashSet((Object[])new String[]{"path", "type"}));
        String path = map2.get("path");
        String type = map2.get("type");
        if (path != null && "tree".equals(type) && path.startsWith(TYPES_DIR) && !(subPath = path.substring(TYPES_DIR.length())).contains("/")) {
            return subPath;
        }
        return null;
    }

    @Nullable
    private static String getDefinitionFileExtension(@Nullable String name) {
        if (name == null) {
            return null;
        }
        if (name.endsWith(".d.ts")) {
            return D_TS_FILE;
        }
        if (name.endsWith(".d.tsx")) {
            return D_TSX_FILE;
        }
        return null;
    }

    private static boolean isFile(@Nullable String type) {
        return "file".equals(type);
    }

    private static class LazyDefinitelyTypedFileSetDescription
    implements DownloadableFileSetDescriptionWithUrl {
        @NotNull
        private final String myName;
        private final AtomicNotNullLazyValue<List<DownloadableFileDescription>> myDescriptions;

        public LazyDefinitelyTypedFileSetDescription(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/webcore/libraries/ui/download/TypeScriptStubsDownloader$LazyDefinitelyTypedFileSetDescription", "<init>"));
            }
            this.myDescriptions = AtomicNotNullLazyValue.createValue(this::downloadDescriptions);
            this.myName = name;
        }

        @Override
        @NotNull
        public String getUrl() {
            String string2 = TypeScriptStubsDownloader.FILE_URL + this.myName + "/";
            if (string2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/webcore/libraries/ui/download/TypeScriptStubsDownloader$LazyDefinitelyTypedFileSetDescription", "getUrl"));
            }
            return string2;
        }

        @NotNull
        public String getName() {
            String string2 = this.myName;
            if (string2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/webcore/libraries/ui/download/TypeScriptStubsDownloader$LazyDefinitelyTypedFileSetDescription", "getName"));
            }
            return string2;
        }

        @NotNull
        public String getVersionString() {
            if ("DefinitelyTyped" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/webcore/libraries/ui/download/TypeScriptStubsDownloader$LazyDefinitelyTypedFileSetDescription", "getVersionString"));
            }
            return "DefinitelyTyped";
        }

        @NotNull
        private List<DownloadableFileDescription> downloadDescriptions() {
            Collection<String> files2 = LazyDefinitelyTypedFileSetDescription.filterDuplicateFilesWithVersion(this.downloadUrlList());
            List list2 = ContainerUtil.map(files2, name -> {
                String fileNameWithoutExtension = LazyDefinitelyTypedFileSetDescription.getFileNameWithoutExtension(name);
                String extension = TypeScriptStubsDownloader.getDefinitionFileExtension(name);
                assert (extension != null);
                return new DownloadableFileDescriptionImpl(TypeScriptStubsDownloader.FILE_URL + this.myName + "/" + name, fileNameWithoutExtension, extension);
            });
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/webcore/libraries/ui/download/TypeScriptStubsDownloader$LazyDefinitelyTypedFileSetDescription", "downloadDescriptions"));
            }
            return list2;
        }

        @NotNull
        public List<? extends DownloadableFileDescription> getFiles() {
            List list2 = (List)this.myDescriptions.getValue();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/webcore/libraries/ui/download/TypeScriptStubsDownloader$LazyDefinitelyTypedFileSetDescription", "getFiles"));
            }
            return list2;
        }

        @NotNull
        private static Collection<String> filterDuplicateFilesWithVersion(Collection<String> names) {
            LinkedHashMap fileNamesWithoutExtensionsToFullNames = ContainerUtil.newLinkedHashMap();
            for (String name : names) {
                String fileNameWithoutExtension = LazyDefinitelyTypedFileSetDescription.getFileNameWithoutExtension(name);
                if (StringUtil.isEmpty((String)fileNameWithoutExtension)) continue;
                fileNamesWithoutExtensionsToFullNames.put(fileNameWithoutExtension, name);
            }
            Set fileNamesWithoutExtensions = fileNamesWithoutExtensionsToFullNames.keySet();
            ArrayList results = ContainerUtil.newArrayList();
            for (Map.Entry entry : fileNamesWithoutExtensionsToFullNames.entrySet()) {
                String normalizedName;
                String nameWithoutExtension = (String)entry.getKey();
                if (!nameWithoutExtension.equals(normalizedName = LazyDefinitelyTypedFileSetDescription.getNormalizedName(nameWithoutExtension)) && fileNamesWithoutExtensions.contains(normalizedName)) continue;
                results.add(entry.getValue());
            }
            ArrayList arrayList = results;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/webcore/libraries/ui/download/TypeScriptStubsDownloader$LazyDefinitelyTypedFileSetDescription", "filterDuplicateFilesWithVersion"));
            }
            return arrayList;
        }

        private static String getNormalizedName(@NotNull String name) {
            int nextIndex;
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/webcore/libraries/ui/download/TypeScriptStubsDownloader$LazyDefinitelyTypedFileSetDescription", "getNormalizedName"));
            }
            int i2 = name.indexOf("-");
            while (i2 > 0 && (nextIndex = i2 + 1) < name.length()) {
                char nextChar = name.charAt(nextIndex);
                if (StringUtil.isDecimalDigit((char)nextChar)) {
                    return name.substring(0, i2);
                }
                i2 = name.indexOf("-", nextIndex);
            }
            return name;
        }

        private static String getFileNameWithoutExtension(String fullName) {
            return FileUtil.getNameWithoutExtension((String)FileUtil.getNameWithoutExtension((String)fullName));
        }

        @NotNull
        private Collection<String> downloadUrlList() {
            final ArrayList files2 = ContainerUtil.newArrayList();
            HttpRequests.request((String)(TypeScriptStubsDownloader.URL_ITEM + this.myName)).connect((HttpRequests.RequestProcessor)new HttpRequests.RequestProcessor<Object>(){

                public Object process(@NotNull HttpRequests.Request request2) throws IOException {
                    if (request2 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/webcore/libraries/ui/download/TypeScriptStubsDownloader$LazyDefinitelyTypedFileSetDescription$1", "process"));
                    }
                    JsonElement jsonElement = new JsonParser().parse((Reader)request2.getReader());
                    if (jsonElement instanceof JsonArray) {
                        for (JsonElement element : (JsonArray)jsonElement) {
                            if (!element.isJsonObject()) continue;
                            JsonObject jsonObject = element.getAsJsonObject();
                            String name = JsonUtil.getChildAsString(jsonObject, "name");
                            String type = JsonUtil.getChildAsString(jsonObject, "type");
                            String extension = TypeScriptStubsDownloader.getDefinitionFileExtension(name);
                            if (!TypeScriptStubsDownloader.isFile(type) || extension == null) continue;
                            files2.add(name);
                        }
                    }
                    return null;
                }
            }, null, null);
            ArrayList arrayList = files2;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/webcore/libraries/ui/download/TypeScriptStubsDownloader$LazyDefinitelyTypedFileSetDescription", "downloadUrlList"));
            }
            return arrayList;
        }
    }
}

