/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webcore.packaging;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PackageVersionComparator
implements Comparator<String> {
    public static final Comparator<String> VERSION_COMPARATOR = new PackageVersionComparator();

    @Override
    public int compare(String version1, String version2) {
        List<String> vs1 = this.parse(version1);
        List<String> vs2 = this.parse(version2);
        int result2 = 0;
        for (int i2 = 0; i2 < vs1.size() && i2 < vs2.size() && (result2 = vs1.get(i2).compareTo(vs2.get(i2))) == 0; ++i2) {
        }
        if (result2 == 0) {
            return vs1.size() - vs2.size();
        }
        return result2;
    }

    @Nullable
    private static String replace(@NotNull String s2) {
        if (s2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/webcore/packaging/PackageVersionComparator", "replace"));
        }
        ImmutableMap sub = ImmutableMap.of((Object)"pre", (Object)"c", (Object)"preview", (Object)"c", (Object)"rc", (Object)"c", (Object)"dev", (Object)"@");
        String tmp = (String)sub.get(s2);
        if (tmp != null) {
            s2 = tmp;
        }
        if (s2.equals(".") || s2.equals("-")) {
            return null;
        }
        if (s2.matches("[0-9]+")) {
            try {
                long value2 = Long.parseLong(s2);
                return String.format("%08d", value2);
            }
            catch (NumberFormatException e2) {
                return s2;
            }
        }
        return "*" + s2;
    }

    @NotNull
    private List<String> parse(@Nullable String s2) {
        if (s2 == null) {
            List<String> list2 = Collections.emptyList();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/webcore/packaging/PackageVersionComparator", "parse"));
            }
            return list2;
        }
        Pattern COMPONENT_RE = Pattern.compile("\\d+|[a-z]+|\\.|-|.+");
        ArrayList<String> results = new ArrayList<String>();
        Matcher matcher = COMPONENT_RE.matcher(s2);
        while (matcher.find()) {
            String component = PackageVersionComparator.replace(matcher.group());
            if (component == null) continue;
            results.add(component);
        }
        for (int i2 = results.size() - 1; i2 > 0 && "00000000".equals(results.get(i2)); --i2) {
            results.remove(i2);
        }
        results.add("*final");
        ArrayList<String> arrayList = results;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/webcore/packaging/PackageVersionComparator", "parse"));
        }
        return arrayList;
    }
}

