/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webcore.resourceRoots;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.MultiMap;
import com.intellij.webcore.resourceRoots.WebResourcesPathsConfiguration;
import java.util.Collection;

public class MarkResourceRootActionBase
extends AnAction {
    private static final Logger LOG = Logger.getInstance((String)("#" + MarkResourceRootActionBase.class.getName()));
    private final boolean myMark;

    public MarkResourceRootActionBase(boolean mark, String text2) {
        super(text2);
        this.myMark = mark;
    }

    public void update(AnActionEvent e2) {
        boolean enabled = this.canMark(e2);
        e2.getPresentation().setVisible(enabled);
        e2.getPresentation().setEnabled(enabled);
    }

    public void actionPerformed(AnActionEvent e2) {
        Project project2 = (Project)e2.getData(CommonDataKeys.PROJECT);
        VirtualFile[] vFiles = (VirtualFile[])e2.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        if (project2 == null) {
            LOG.warn("Can not resolve a project (null)");
            return;
        }
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project2).getFileIndex();
        WebResourcesPathsConfiguration config = WebResourcesPathsConfiguration.getInstance(project2);
        MultiMap<String, String> roots = config.getResourceRoots();
        assert (vFiles != null);
        for (VirtualFile vFile : vFiles) {
            String entryUrl = fileIndex.getContentRootForFile(vFile).getUrl();
            if (this.myMark) {
                roots.putValue((Object)entryUrl, (Object)vFile.getUrl());
                continue;
            }
            roots.remove((Object)entryUrl, (Object)vFile.getUrl());
        }
        config.setResourceRoots(roots);
    }

    private boolean canMark(AnActionEvent e2) {
        Module module2 = (Module)e2.getData(LangDataKeys.MODULE);
        VirtualFile[] vFiles = (VirtualFile[])e2.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        if (module2 == null || vFiles == null) {
            return false;
        }
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)module2.getProject()).getFileIndex();
        for (VirtualFile vFile : vFiles) {
            if (!vFile.isDirectory()) {
                return false;
            }
            if (!fileIndex.isInContent(vFile)) {
                return false;
            }
            WebResourcesPathsConfiguration configuration = WebResourcesPathsConfiguration.getInstance(module2.getProject());
            if (configuration != null) {
                MultiMap<String, String> resourceRoots = configuration.getResourceRoots();
                Collection rootsForEntry = resourceRoots.get((Object)fileIndex.getContentRootForFile(vFile).getUrl());
                if (this.myMark != rootsForEntry.contains(vFile.getUrl())) continue;
                return false;
            }
            LOG.warn("Can not get configuration for " + module2.getProject());
            return false;
        }
        return true;
    }
}

