/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webcore.resourceRoots;

import com.intellij.ide.IconProvider;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.webcore.resourceRoots.WebResourcesPathsConfiguration;
import icons.WebideApiIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class ResourceRootIconProvider
extends IconProvider {
    public static final Icon RESOURCE_ROOT_ICON = WebideApiIcons.ResourceRoot;

    public Icon getIcon(@NotNull PsiElement element, int flags) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/webcore/resourceRoots/ResourceRootIconProvider", "getIcon"));
        }
        if (element instanceof PsiDirectory) {
            VirtualFile vFile = ((PsiDirectory)element).getVirtualFile();
            if (WebResourcesPathsConfiguration.getInstance(element.getProject()).hasResourceRootPath(vFile.getUrl())) {
                return RESOURCE_ROOT_ICON;
            }
        }
        return null;
    }
}

