/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webcore.resourceRoots;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceHelper;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.webcore.resourceRoots.WebResourcesPathsConfiguration;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WebIdeFileReferenceHelper
extends FileReferenceHelper {
    @Override
    public PsiFileSystemItem findRoot(Project project2, @NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/webcore/resourceRoots/WebIdeFileReferenceHelper", "findRoot"));
        }
        VirtualFile contentRootForFile = WebIdeFileReferenceHelper.retrieveTheDeepestAncestorForFile(file2, WebResourcesPathsConfiguration.getInstance(project2).getResourceDirectories());
        if (contentRootForFile == null) {
            ProjectFileIndex index = ProjectRootManager.getInstance((Project)project2).getFileIndex();
            contentRootForFile = index.getSourceRootForFile(file2);
        }
        return contentRootForFile != null ? PsiManager.getInstance((Project)project2).findDirectory(contentRootForFile) : null;
    }

    @Override
    @NotNull
    public Collection<PsiFileSystemItem> getRoots(@NotNull Module module2) {
        if (module2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/webcore/resourceRoots/WebIdeFileReferenceHelper", "getRoots"));
        }
        List list2 = ContainerUtil.map((Object[])ModuleRootManager.getInstance((Module)module2).getContentRoots(), virtualFile -> {
            if (module2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/webcore/resourceRoots/WebIdeFileReferenceHelper", "lambda$getRoots$0"));
            }
            return PsiManager.getInstance((Project)module2.getProject()).findDirectory(virtualFile);
        });
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/webcore/resourceRoots/WebIdeFileReferenceHelper", "getRoots"));
        }
        return list2;
    }

    @Override
    @NotNull
    public Collection<PsiFileSystemItem> getContexts(Project project2, @NotNull VirtualFile file2) {
        PsiFileSystemItem parent;
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/webcore/resourceRoots/WebIdeFileReferenceHelper", "getContexts"));
        }
        PsiFileSystemItem item = this.getPsiFileSystemItem(project2, file2);
        if (item != null && (parent = item.getParent()) != null) {
            Set<PsiFileSystemItem> set2 = Collections.singleton(parent);
            if (set2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/webcore/resourceRoots/WebIdeFileReferenceHelper", "getContexts"));
            }
            return set2;
        }
        List<PsiFileSystemItem> list2 = Collections.emptyList();
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/webcore/resourceRoots/WebIdeFileReferenceHelper", "getContexts"));
        }
        return list2;
    }

    @Override
    public boolean isMine(Project project2, @NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/webcore/resourceRoots/WebIdeFileReferenceHelper", "isMine"));
        }
        return ProjectRootManager.getInstance((Project)project2).getFileIndex().isInContent(file2);
    }

    @Nullable
    private static VirtualFile retrieveTheDeepestAncestorForFile(VirtualFile file2, Collection<VirtualFile> resourceDirectories) {
        VirtualFile result2 = null;
        for (VirtualFile potentialRoot : resourceDirectories) {
            if (!potentialRoot.equals(VfsUtil.getCommonAncestor((VirtualFile)potentialRoot, (VirtualFile)file2)) || result2 != null && !result2.equals(VfsUtil.getCommonAncestor((VirtualFile)result2, (VirtualFile)potentialRoot))) continue;
            result2 = potentialRoot;
        }
        return result2;
    }
}

